package jp.sf.codememo;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import org.eclipse.core.runtime.IPath;

/**
 * 
 * @author bskuroneko
 */
public class MemoRegistry {

    private IPath path;
    private IElementResolver elementResolver;
    
    public MemoRegistry(IPath path, IElementResolver elementResolver) {
        this.path = path;
        this.elementResolver = elementResolver;
    }

    public String load(Object element) throws IOException {
        File file = getFile(element);
        if (! file.exists()) {
            return null;
        }
        
        StringBuffer result = new StringBuffer();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            char[] buffer = new char[4096];
            int length = 0;
            while ((length = reader.read(buffer)) > 0) {
                result.append(buffer, 0, length);
            }
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignore) {
                }
            }
        }
        
        return result.toString();
    }

    public void save(Object element, String memo) throws IOException {
        File file = getFile(element);
        if (memo == null || memo.length() == 0) {
            if (file.exists()) {
                file.delete();
            }
            return;
        }
        
        File parentDir = file.getParentFile();
        if (!parentDir.exists() && !parentDir.mkdirs()) {
            throw new IOException("Unable to create directory " + file.getParentFile());
        }
        
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(file));
            writer.write(memo);
            writer.flush();
        } finally {
            try {
                writer.close();
            }
            catch (IOException ignore) {
            }
        }
    }
    
    private File getFile(Object element) {
        return elementResolver.getRegistryPath(path, element);
    }
    
}
