/*
 * Decompiled with CFR 0.152.
 */
package japa.parser;

import japa.parser.ast.CompilationUnit;
import japa.parser.ast.body.BodyDeclaration;
import japa.parser.ast.body.FieldDeclaration;
import japa.parser.ast.body.MethodDeclaration;
import japa.parser.ast.body.Parameter;
import japa.parser.ast.body.TypeDeclaration;
import japa.parser.ast.body.VariableDeclarator;
import japa.parser.ast.body.VariableDeclaratorId;
import japa.parser.ast.expr.DimExpr;
import japa.parser.ast.expr.Expression;
import japa.parser.ast.expr.MethodCallExpr;
import japa.parser.ast.expr.NameExpr;
import japa.parser.ast.expr.QualifiedNameExpr;
import japa.parser.ast.expr.VariableDeclarationExpr;
import japa.parser.ast.stmt.BlockStmt;
import japa.parser.ast.stmt.ExpressionStmt;
import japa.parser.ast.stmt.Statement;
import japa.parser.ast.type.ClassOrInterfaceType;
import japa.parser.ast.type.PrimitiveType;
import japa.parser.ast.type.ReferenceType;
import japa.parser.ast.type.Type;
import japa.parser.ast.type.VoidType;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ASTHelper {
    public static final PrimitiveType BYTE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Byte);
    public static final PrimitiveType SHORT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Short);
    public static final PrimitiveType INT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Int);
    public static final PrimitiveType LONG_TYPE = new PrimitiveType(PrimitiveType.Primitive.Long);
    public static final PrimitiveType FLOAT_TYPE = new PrimitiveType(PrimitiveType.Primitive.Float);
    public static final PrimitiveType DOUBLE_TYPE = new PrimitiveType(PrimitiveType.Primitive.Double);
    public static final PrimitiveType BOOLEAN_TYPE = new PrimitiveType(PrimitiveType.Primitive.Boolean);
    public static final PrimitiveType CHAR_TYPE = new PrimitiveType(PrimitiveType.Primitive.Char);
    public static final VoidType VOID_TYPE = new VoidType();

    private ASTHelper() {
    }

    public static NameExpr createNameExpr(String qualifiedName) {
        String[] split = qualifiedName.split("\\.");
        NameExpr ret = new NameExpr(split[0]);
        for (int i = 1; i < split.length; ++i) {
            ret = new QualifiedNameExpr(ret, split[i]);
        }
        return ret;
    }

    public static Parameter createParameter(Type type, String name) {
        return new Parameter(type, new VariableDeclaratorId(name));
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers, Type type, VariableDeclarator variable) {
        ArrayList<VariableDeclarator> variables = new ArrayList<VariableDeclarator>();
        variables.add(variable);
        FieldDeclaration ret = new FieldDeclaration(modifiers, type, variables);
        return ret;
    }

    public static FieldDeclaration createFieldDeclaration(int modifiers, Type type, String name) {
        VariableDeclaratorId id = new VariableDeclaratorId(name);
        VariableDeclarator variable = new VariableDeclarator(id);
        return ASTHelper.createFieldDeclaration(modifiers, type, variable);
    }

    public static VariableDeclarationExpr createVariableDeclarationExpr(Type type, String name) {
        ArrayList<VariableDeclarator> vars = new ArrayList<VariableDeclarator>();
        vars.add(new VariableDeclarator(new VariableDeclaratorId(name)));
        return new VariableDeclarationExpr(type, vars);
    }

    public static void addParameter(MethodDeclaration method, Parameter parameter) {
        List<Parameter> parameters = method.getParameters();
        if (parameters == null) {
            parameters = new ArrayList<Parameter>();
            method.setParameters(parameters);
        }
        parameters.add(parameter);
    }

    public static void addArgument(MethodCallExpr call, Expression arg) {
        List<Expression> args = call.getArgs();
        if (args == null) {
            args = new ArrayList<Expression>();
            call.setArgs(args);
        }
        args.add(arg);
    }

    public static void addTypeDeclaration(CompilationUnit cu, TypeDeclaration type) {
        List<TypeDeclaration> types = cu.getTypes();
        if (types == null) {
            types = new ArrayList<TypeDeclaration>();
            cu.setTypes(types);
        }
        types.add(type);
    }

    public static ReferenceType createReferenceType(String name, List<DimExpr> dims) {
        return new ReferenceType(new ClassOrInterfaceType(name), dims);
    }

    public static ReferenceType createReferenceType(PrimitiveType type, List<DimExpr> dims) {
        return new ReferenceType(type, dims);
    }

    public static void addStmt(BlockStmt block, Statement stmt) {
        List<Statement> stmts = block.getStmts();
        if (stmts == null) {
            stmts = new ArrayList<Statement>();
            block.setStmts(stmts);
        }
        stmts.add(stmt);
    }

    public static void addStmt(BlockStmt block, Expression expr) {
        ASTHelper.addStmt(block, new ExpressionStmt(expr));
    }

    public static void addMember(TypeDeclaration type, BodyDeclaration decl) {
        List<BodyDeclaration> members = type.getMembers();
        if (members == null) {
            members = new ArrayList<BodyDeclaration>();
            type.setMembers(members);
        }
        members.add(decl);
    }
}

