/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ScriptOrFnNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassCompiler {
    private String mainMethodClassName;
    private CompilerEnvirons compilerEnv;
    private Class<?> targetExtends;
    private Class<?>[] targetImplements;

    public ClassCompiler(CompilerEnvirons compilerEnv) {
        if (compilerEnv == null) {
            throw new IllegalArgumentException();
        }
        this.compilerEnv = compilerEnv;
        this.mainMethodClassName = "org.mozilla.javascript.optimizer.OptRuntime";
    }

    public void setMainMethodClass(String className) {
        this.mainMethodClassName = className;
    }

    public String getMainMethodClass() {
        return this.mainMethodClassName;
    }

    public CompilerEnvirons getCompilerEnv() {
        return this.compilerEnv;
    }

    public Class<?> getTargetExtends() {
        return this.targetExtends;
    }

    public void setTargetExtends(Class<?> extendsClass) {
        this.targetExtends = extendsClass;
    }

    public Class<?>[] getTargetImplements() {
        return this.targetImplements == null ? null : (Class[])this.targetImplements.clone();
    }

    public void setTargetImplements(Class<?>[] implementsClasses) {
        this.targetImplements = implementsClasses == null ? null : (Class[])implementsClasses.clone();
    }

    protected String makeAuxiliaryClassName(String mainClassName, String auxMarker) {
        return mainClassName + auxMarker;
    }

    public Object[] compileToClassFiles(String source, String sourceLocation, int lineno, String mainClassName) {
        Parser p = new Parser(this.compilerEnv, this.compilerEnv.getErrorReporter());
        ScriptOrFnNode tree = p.parse(source, sourceLocation, lineno);
        return null;
    }
}

