#ifndef COUNTE_LINE_H_
#define COUNTE_LINE_H_

/*----------------------------------------------------------------------------*/
/* include file                                                               */
/*----------------------------------------------------------------------------*/


/*----------------------------------------------------------------------------*/
/* define                                                                     */
/*----------------------------------------------------------------------------*/
#define EXT_SIZE (7)
#define CMNT_NUM (3)
#define CMNT_SIZE (7)
#define BUFF_TOKEN_SIZE (128)

/*ftHgRg*/
#define COMMENT_DEFAULTNUM 2
/*Rg*/
#define COMMENT_LINE "//"
#define COMMENT_BLOCKSTART "/*"
#define COMMENT_BLOCKEND "*/"
/*hLg*/
#define COMMENT_DOC "/**"
#define COMMENT_DOX "/*!"

#define COMMENT_INDEX_NONE (-1)

#define PREPRO_START "#"
#define PREPRO_NAME_INCLUDE "include"

/*sXe[^X*/
enum LINE_STATUS{
    LINE_STATUS_INIT = 0,    /**/
    LINE_STATUS_PREPRO,      /*vvZbTs*/
    LINE_STATUS_LINECOMMENT,     /*CRg*/
    LINE_STATUS_BLOCKCOMMENT,    /*ubNRg*/
};

/*Xe[^X*/
enum STR_STATUS{
    STR_STATUS_INIT = 0,        /**/
    STR_STATUS_STRING,          /**/
    STR_STATUS_CHAR,            /**/
    STR_STATUS_INCLUDE,         /*INCLUDEŗL<>*/    
};

/*Rg^Cv*/
enum COMMENT_TYPE{
    COMMENT_TYPE_LINE = 0,    /*CRg*/
    COMMENT_TYPE_BLOCK,      /*ubNRg*/
};

/*vvL[[h*/
enum PREPRO_NAME_ID{
    PREPRO_ID_UNKNOW = 0,   /*`}N*/
    PREPRO_ID_INCLUDE,   /*include*/
};


/* NULLǂ? 0:noA1:yes */
#define IS_NULL_CHAR(p) (*(p) == '\0')

/* sR[h<LF>? 0:noA1:yes */
//#define IS_LF(c) (c == 0x0a)
#define IS_LF(p) (*(p) == 0x0a)

/* sR[h<CR>? 0:noA1:yes */
//#define IS_CR(c) (c == 0x0d)
#define IS_CR(p) (*(p) == 0x0d)

/* sR[h? 0:noA1:yes */
//#define IS_BREAK_LINE(c) (IS_LF(c) || IS_CR(c))
#define IS_BREAK_LINE(p) (IS_LF(p) || IS_CR(p))

/* CR[? 0:noA1:yes */
//#define IS_EQUAL(c) ((c) == '=')

/* XbV? 0:noA1:yes */
//#define IS_SLASH(c) ((c) == '/')

/* obNXbV? 0:noA1:yes */
//#define IS_BACKSLASH(c) ((c) == '\\')
#define IS_BACKSLASH(p) (*(p) == '\\')

/* 󔒁A^u? 0:noA1:yes */
//#define IS_WHITE_SPACE(c) ((c == ' ') || (c == '\t'))
#define IS_WHITE_SPACE(p) ((*(p) == ' ') || (*(p) == '\t'))

/* skip white space */
#define SKIP_WHITE_SPACE(pp) {\
    while(IS_WHITE_SPACE(*(pp))){\
        (*(pp))++;\
    }\
}

/* vvJns? 0:noA1:yes */
#define IS_PREPRO(p) (*(p) == '#')


/*----------------------------------------------------------------------------*/
/* structure definition                                                       */
/*----------------------------------------------------------------------------*/
/*L[[h*/
typedef struct tag_PREPRO_NAME{
    char *name;
    int id; 
} _PREPRO_NAME;

/*JEgs*/
typedef struct tag_LINECOL{
    unsigned int iCol; /*s*/
    unsigned int iPreCol;  /*vv*/
    unsigned int iCmntCol; /*Rg*/
} _LINECOL;

/*[UwRg*/
typedef struct tag_USRCOMMENT{
	int iType;
	char cCmntS[CMNT_SIZE + 1];    
	char cCmntE[CMNT_SIZE + 1];    
} _USRCOMMENT;

/*gqƃRg*/
typedef struct tag_COMMENT{
	int iNum;					/*wRg*/
    char chExt[EXT_SIZE + 1]; /*gq*/
    _USRCOMMENT stCmnt[CMNT_NUM]; /*[UwRg*/
} _COMMENT;

/*----------------------------------------------------------------------------*/
/* global variable declaration                                                */
/*----------------------------------------------------------------------------*/
int initDefaultSetComment();
int setComment(_COMMENT* pstComment);
int getLineCount(FILE *fin);

/*----------------------------------------------------------------------------*/
/* static variable declaration                                                */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* global function                                                            */
/*----------------------------------------------------------------------------*/


#endif /*COUNTE_LINE_H_*/
