/*linecounter.c*/
/*----------------------------------------------------------------------------*/
/* include file                                                               */
/*----------------------------------------------------------------------------*/
//#include "StdAfx.h"
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>

#include "count_cmn.h"
#include "count_line.h"
#include "count_result.h"
#include "file_cmn.h"

/*----------------------------------------------------------------------------*/
/* define                                                                     */
/*----------------------------------------------------------------------------*/
//#define TESTFILE "D:\\work\\test.c"
#define OUT_FILENAME "LineCounter.csv"

/*----------------------------------------------------------------------------*/
/* static function declaration                                                */
/*----------------------------------------------------------------------------*/

static int executeLineCount(char *pcInfile, char *pcOufile);
static int executeLineCountDir(char *pcInfile, char *pcOutfile);
static int executeLineCountFile(char *pcInfile, char *pcOutfile);
static int getDefaultResultPath(char *pcToolPath, char *pcFilePath);

/*----------------------------------------------------------------------------*/
/* global function                                                            */
/*----------------------------------------------------------------------------*/

int main(int argc, char* argv[]) {
    int iRet;
    char cInpath[FILE_PATH_SIZE];         /*͂ꂽt@CpX*/
    char cOutpath[FILE_PATH_SIZE];        /*ʏo͂t@C*/
    char *pcToolPath;       /*c[pX*/  
    
    /*TODO@Ƃ肠͈͂ЂƂ̂*/
    if(argc != 2){
        /*G[*/
        printf("InputFile not found!!\n");
        goto FUNC_END;
    }
    
    /*͂ꂽpX΃pXɕϊĎ擾*/
    iRet = getAbsolutePath(argv[argc - 1], cInpath);
    if(iRet == RET_NG){
        /*G[*/
        goto FUNC_END;
    }
#if CNT_DEBUG
    printf("INFILE = %s\n",cInpath);
#endif
    
    /*o̓t@CpX擾*/
    pcToolPath = argv[0];
    iRet = getDefaultResultPath(pcToolPath, cOutpath);
    if(iRet == RET_NG){
        /*G[*/
        printf("line count error.\n");
        goto FUNC_END;
    }
#if CNT_DEBUG
    printf("OUTFILE = %s\n",cOutpath);//TODO DEBUG
#endif

    initDefaultSetComment();
    
    /*JEgƌʏo*/
    iRet = executeLineCount(cInpath, cOutpath);
    if(iRet == RET_NG){
        /*G[*/
        printf("line count error.\n");
        goto FUNC_END;
    }
    printf("linecounter finish...\n");

FUNC_END:        

    return 0;
}


static int executeLineCount(char *pcInfile, char *pcOutfile)
{
    int iRet;
    
    iRet = RET_NG;
    
    /*fBNgH*/
    if(isDir(pcInfile)){
        iRet = executeLineCountDir(pcInfile, pcOutfile);
    }else{
        iRet = executeLineCountFile(pcInfile, pcOutfile);        
    }
    return iRet;
}

static int executeLineCountDir(char *pcInfile, char *pcOutfile)
{
    int iRet;
    int i;
    _FileList *pflist;
    
    iRet = RET_NG;
    pflist = NULL;
    
    /*t@Cꗗ擾*/
    iRet = getFileList(pcInfile, &pflist);
    if(iRet != RET_OK){
        goto FUNC_END;
    }
    
    for(i = 0; i < pflist->count; i++){
        iRet = executeLineCountFile(pflist->filename[i], pcOutfile);
    }
    
FUNC_END:
    freeFileList(pflist);
    return iRet;
}


static int executeLineCountFile(char *pcInfile, char *pcOutfile)
{
    int iRet;
    FILE *fin;
    
    iRet = RET_NG;
    
    /*t@CI[v*/
    if( (fin = fopen(pcInfile,"rb") ) != NULL ) {
#if CNT_DEBUG
            printf("count start : %s\n", pcInfile);
#endif
        
        /*JEg*/
        iRet = getLineCount(fin);
        fclose(fin);
        
        if(iRet != RET_OK){
            goto FUNC_END;    
        }
#if CNT_DEBUG
        printf("count finish.\n");
#endif
        
        /*ʏo*/
        putResultLineCount(pcOutfile, pcInfile);
    }
FUNC_END:
    return iRet;
}

//#if 0
///*I:t@CAc[pX*/
///*O:΃pX(J͌ĂяoŁI)*/
//static int getAbsoluteInputPath(char *pcFile, char **ppcFilePath)
//{
//    int iRet;
//    char *pcPath;
//    char filebuf[FILE_PATH_SIZE];
//    
//    /*΃pX擾*/
//    iRet = getAbsolutePath(pcFile, filebuf);
//    if(iRet == RET_NG){
//        /*G[*/
//        goto FUNC_END;
//    }
//    pcPath = malloc(strlen(filebuf) + 1);
//    if(pcPath == NULL){
//        goto FUNC_END;
//    }
//    memset(pcPath, 0x00, strlen(filebuf) + 1);
//    strcpy(pcPath, filebuf);
//    
//    iRet = RET_OK;    
//    *ppcFilePath = pcPath;
//
//FUNC_END:
//    return iRet;
//}
//#endif

/*I:c[pX*/
/*O:o̓t@CpX(J͌ĂяoŁI)*/
static int getDefaultResultPath(char *pcToolPath, char *pcFilePath)
{
    int iRet;
    char dirbuf[FILE_DIR_SIZE];
    char filebuf[FILE_NAME_SIZE];
    
    iRet = RET_NG;
    
    getDirFileName(pcToolPath, dirbuf, filebuf);
    setDirFileName(dirbuf, OUT_FILENAME, pcFilePath);

    iRet = RET_OK;

    return iRet;
}
