/*JEg*/
/*----------------------------------------------------------------------------*/
/* include file                                                               */
/*----------------------------------------------------------------------------*/
#include <stdio.h>

#include "file_cmn.h"
#include "count_result.h"

/*----------------------------------------------------------------------------*/
/* define                                                                     */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* structure definition                                                       */
/*----------------------------------------------------------------------------*/

/*----------------------------------------------------------------------------*/
/* global variable declaration                                                */
/*----------------------------------------------------------------------------*/
extern _LINECOUNT  gtCount;

/*----------------------------------------------------------------------------*/
/* static variable declaration                                                */
/*----------------------------------------------------------------------------*/
static int putResutlRow(char *pcfile);
static int putResultCount(char *pcOutFile, char *pcCountFile);

/*----------------------------------------------------------------------------*/
/* global function                                                            */
/*----------------------------------------------------------------------------*/
int putResultLineCount(char* pcOutFile, char* pcCountFile) 
{
    int iRet;
    FILE *fout;

    iRet = RET_NG;

    if(pcOutFile == NULL || pcCountFile == NULL) {
        goto FUNC_END;
    }
	
    /*o̓t@C݂邩mF*/
    if( (fout = fopen(pcOutFile,"rb") ) == NULL ) {
        /*t@C݂ȂꍇAVK쐬sA񖼂o*/
        putResutlRow(pcOutFile);
    } else {
        /*o̓t@C݂*/
        fclose(fout);
    }

    /*JEgʏo*/
    putResultCount(pcOutFile, pcCountFile);

    iRet = RET_OK;

FUNC_END:
    return iRet;
}

/*----------------------------------------------------------------------------*/
/* static function                                                            */
/*----------------------------------------------------------------------------*/
/*񖼂tH[}bgɏ]o*/
static int putResutlRow(char *pcfile) {
    int iRet;
    FILE *fout;

    iRet = RET_NG;

    /*񖼏o*/
    if ( (fout = fopen(pcfile,"wb") ) != NULL ) {
        fprintf(fout, OUT_FORMAT_ROWNAME,
                ROWNAME_DIR,
                ROWNAME_FILE,
                ROWNAME_TOTAL,
                ROWNAME_CODE,
                ROWNAME_BLANK,
                ROWNAME_COMMENT);
        fclose(fout);
        iRet = RET_OK;
    }

    return iRet;
}

/*JEgʂtH[}bgɏ]o*/
static int putResultCount(char *pcOutFile, char *pcCountFile) 
{
    int iRet;
    FILE *fout;
    char pcdir[FILE_DIR_SIZE];
    char pcfile[FILE_NAME_SIZE];
    int iTotal, iLine, iComment, iBlank;

    iRet = RET_NG;

    /*t@CƃfBNg擾*/
    getDirFileName(pcCountFile, pcdir, pcfile);

    /*JEgʌvZ*/
    iLine = gtCount.iLine + gtCount.iPre;
    iComment = gtCount.iCmnt;
    iBlank = gtCount.iBlank;
    iTotal = iLine + iComment + iBlank;

    /*JEgʂǋL*/
    if ( (fout = fopen(pcOutFile,"ab") ) != NULL ) {
        fprintf(fout, OUT_FORMAT_COUNTRESULT,
                pcdir,
                pcfile,
                iTotal,
                iLine,
                iBlank,
                iComment);
        fclose(fout);
        iRet = RET_OK;
    }

    return iRet;
}

