// global vars
var editor = ace.edit("content_body");
editor.fit = function() {
	$('#content_body').css('height',($(window).height() - 150) + 'px');
	$('#content_body').css('width', ($(window).width() - 410) + 'px');

	var w = $(window);
	$('#content_body').css({
		height: (w.height() - 150) + 'px'
	});
	editor.resize(true);
};

var current = {
	contents: [],
	item_id: 0,
	item: null,
	node_id: '',
	content_id: 0
};

var MSG = {
	BTN_OK: 'OK',
	BTN_CANCEL: 'キャンセル',
	SETTING: '設定',
	NEW_GROUP: '新しいフォルダ',
	NEW_ITEM: '新しいスニペット',
	NEW_CONTENT: '新しいコンテンツ',
	DEFAULT_CONTENT_NAME: 'Untitled'
};

function createTabBtnHTML(id, lang, name) {
	return '<a href="#" class="tabbtn" data-id="'+id+'" data-options="iconCls: \'icon-lang-'+lang+'\'">'+name+'</a>';
}

//tree
$('#groups_items').etree({
	dnd: false,
	updateUrl: 'api/update_tree',
	onContextMenu: function(e, node){
		e.preventDefault();

		current.item_id = node.id;
		current.item = node;

		$('#groups_items').etree('select', node.target);
		$('#tree-menu').menu('show', {
			left: e.pageX,
			top: e.pageY
		});
	},
	onClick: function(node){
		current.item_id = node.id;
		current.item = node;

		if(node.attributes.type === 'group') {
			console.log('group select: '+node.id);

			//コンテンツ追加ボタン・メニューバーの無効化
			enableContentMenubar(false);

		}else{
			console.log('item select:'+node.id);

			enableContentMenubar(true);
			loadContents(node.id);
		}
	}
});

function loadContents(item_id) {
	$.getJSON('api/get_contents/'+item_id+'.json', function(json){
		if(!json) { json = []; }
	
		var new_val = '';
		for(var i = 0; i < json.length; i++) {
			var content = json[i];
			new_val += createTabBtnHTML(content.id, content.lang, content.name);
		}
		document.getElementById('tabs').innerHTML = new_val;
	
		$('.tabbtn').linkbutton().click(tabbtnOnClick);

		current.contents = json;
		if(current.contents.length > 0) {
			$('.tabbtn').first().click();
		}
	});
}

function tabbtnOnClick() {
	var target_id = $(this).attr('data-id');
	var contents = current.contents;
	for(var i = 0; i < contents.length; i++) {
		var content = contents[i];
		if(content.id === target_id) {
			current.content_id = target_id;
			editor.setValue(content.body);
			$('#content_name').val(content.name);
			$('#editor_lang').combobox('select',content.lang);
		}
	}
	
	$('.tabbtn').removeClass('selected');
	$(this).addClass('selected');
}

$('#tree-menu').menu({  
    onClick:function(item){  
		switch(item.id) {
			case 'menu_new_group':
				$('#dlg_newgroup').dialog('open');
				break;
			case 'menu_new_item':
				$('#dlg_newitem').dialog('open');
				break;
			case 'menu_remove_item':
				$.post('api/remove_item',{
					id: current.item_id
				},function() {
					$('#groups_items').etree('reload');
				});
				break;
		}
    }  
});

function doSearch(value) {
	$('#groups_items').etree({url: 'api/get_tree.json?q='+value});
}

$('#editor_lang').combobox({
	onSelect: function(record) {
		console.log(record);
		var mode = 'ace/mode/'+record.value;
		editor.getSession().setMode(mode);
	}
});

//新しいフォルダダイアログ
$('#dlg_newgroup').dialog({
    title: MSG.NEW_GROUP,
    width: 400,
    height: 200,
    closed: true,
    cache: false,
    modal: true,
	buttons: [{
	    text: MSG.BTN_OK,
	    iconCls:'icon-ok',
	    handler:function(){
			$.post('api/add_group',{
				name: $('#new_group_name').val()
			});
			$('#groups_items').etree('reload');
			$('#dlg_newgroup').dialog('close');
	    }
	},{
	    text: MSG.BTN_CANCEL,
	    handler:function(){
			$('#dlg_newgroup').dialog('close');
	    }
	}]
});  

$('#dlg_setting').dialog({
	title: MSG.SETTING,
	href: 'setting/index',
	width: 400,
	height: 300,
	closed: true
});
$('#lnk_config').click(function() {
	$('#dlg_setting').dialog('open');
});

//新しいスニペットダイアログ
$('#dlg_newitem').dialog({
    title: MSG.NEW_ITEM,  
    width: 400,
    height: 200,
    closed: true,
    cache: false,
    modal: true,
	buttons: [{
	    text: MSG.BTN_OK,
	    iconCls:'icon-ok',
	    handler:function(){
			var tmp = current.item_id.split(':');
			var type = tmp[0];
			var group_id = tmp.pop();

			if(type === 'i') {
				//選択中のアイテムがアイテムの場合
				var parent = $('#groups_items').etree('getParent', current.item.target);
				tmp = parent.id.split(':');
				group_id = tmp.pop();
			}

			$.post('api/add_item',{
				group_id: group_id,
				name: $('#new_item_name').val()
			},function() {
				$('#groups_items').etree('reload');

			});

			$('#dlg_newitem').dialog('close');
	    }
	},{
	    text: MSG.BTN_CANCEL,
	    handler:function(){
			$('#dlg_newitem').dialog('close');
	    }
	}]
});  


//コンテンツの追加ボタン
$('#btn_add_contents').click(function() {
	$('#new_content_name').val('');
	var item_id = current.item_id.split(':').pop();
	
	$.post('api/add_content',{
		item_id: item_id,
		name: MSG.DEFAULT_CONTENT_NAME
	},function(){
		loadContents(current.item_id);
	});
	
});

//保存ボタン
$('#btn_content_save').click(function() {
	var id = current.content_id;
	var body = editor.getValue();
	//var lang = $('#editor_lang').combobox('select',content.lang);
	var lang = $('#editor_lang').combobox('getValue');

	$.post('api/update_content', {
		id: id,
		body: body,
		lang: lang
	},function() {
		loadContents(current.item_id);
	});

});

//元に戻すボタン
$('#btn_content_revert').click(function(){
	editor.undo();
});

//削除ボタン
$('#btn_content_remove').click(function(){
	$.post('api/remove_content', {
		id: current.content_id
	},function(){
		loadContents(current.item_id);
	});
});

function enableContentMenubar(enabled) {
	var bool_text = enabled ? 'enable' : 'disable';
	var visibility = enabled ? '' : 'hidden';
	$('#tab_menu').css('visibility', visibility);
	$('#tabs').css('visibility', visibility);
	$('#content_menu *').css('visibility', visibility);
	$('#content_name').val('');
}

function fitLayout() {
	editor.fit();
}

//init
enableContentMenubar(false);
fitLayout();
$(window).resize(function () {
	fitLayout();
});