<?php

class Controller_Api_Tree extends Controller_Rest
{
	private $groupid_pre = 100000;
	private $itemid_pre  = 200000;

	private function resetItemDispNum($group_id) {
		$items = Model_Item::find(array(
			'where' => array('group_id' => $group_id),
			'order_by'=>array('disp_num'=>'asc', 'id' => 'asc'),
		));

		$disp_num = 0;
		foreach($items as $item) {
			$item->disp_num = $disp_num;
			$item->save();

			$disp_num += 10;
		}
	}
	private function resetGroupDispNum() {
		$groups = Model_Group::find(array(
			'order_by'=>array('disp_num'=>'asc', 'id' => 'asc'),
		));

		$disp_num = 0;
		foreach($groups as $group) {
			$group->disp_num = $disp_num;
			$group->save();

			$disp_num += 10;
		}
	}

	private function setGroupInfo($group) {
		return array(
			'id' => $this->groupid_pre + $group->id,
			'text' => $group->name,
			'disp_num' => $group->disp_num,
			'state' => 'open',
			'iconCls' => 'icon-sum',
			'children' => array(),
			'attributes' => array(
				'type' => 'group',
				'itemid' => 'g:'.$group->id,
			),
		);

	}

	private function setItemInfo($item) {
		return array(
			'id'   => $this->itemid_pre + $item->id,
			'text' => $item->name,
			'type' => 'item',
			'disp_num' => $item->disp_num,
			'attributes' => array(
				'type' => 'item',
				'itemid' => 'i:'.$item->id,
			),
		);
	}

	private function getTypeAndId($input) {
		if(strpos($input,':') !== false) {
			$tmp = explode(':', $input);
			$type = $tmp[0] == 'g' ? 'group' : 'item';
			$id = $tmp[1];
		}else{
			$rawid = intval($input);
			$tmp = $rawid - $this->itemid_pre;
			$type = $tmp < 0 ? 'group' : 'item';
			$id = $type == 'group' ? $rawid - $this->groupid_pre : $rawid - $this->itemid_pre;
		}

		return array(
			'type' => $type,
			'id' => $id,
		);
	}

	public function action_index()
	{
		$search_text = Input::get('q');
		$ret = array();

		$groups = Model_Group::find(array(
			'order_by'=>array('disp_num'=>'asc', 'id' => 'asc'),
		));

		foreach($groups as $group) {
			$group_info = $this->setGroupInfo($group);

			$items = Model_Item::find(array(
				'where' => array('group_id' => $group->id),
				'order_by'=>array('disp_num'=>'asc'),
			));

			if(count($items) > 0) {
				foreach($items as $item) {
					if((strlen($search_text) == 0)
					|| (strpos($item->name, $search_text) !== false)) {
						$group_info['children'][] = $this->setItemInfo($item);
					}
					
				}
			}

			$ret[] = $group_info;
		}

		$this->response($ret);
	}


	public function post_update()
	{
		$param = $this->getTypeAndId(Input::post('id'));
		$type = $param['type'];
		$id = $param['id'];

		$new_name = Input::post('text');
		if($type == 'group') {
			$target = Model_Group::find_by_pk($id);
		}else {
			$target = Model_Item::find_by_pk($id);
		}
		$target->name = $new_name;

		$target->save();

	}

	public function post_sort()
	{
		$source_param = $this->getTypeAndId(Input::post('id'));
		$source_type = $source_param['type'];
		$source_id = $source_param['id'];

		$target_param = $this->getTypeAndId(Input::post('targetId'));
		$target_type = $target_param['type'];
		$target_id = $target_param['id'];

		if($source_type == $target_type) {
		//同一フォルダ間での並べ替え
			if($source_type == 'group') {
				$source = Model_Group::find_by_pk($source_id);
				$target = Model_Group::find_by_pk($target_id);
			}else{
				$source = Model_Item::find_by_pk($source_id);
				$target = Model_Item::find_by_pk($target_id);
			}

			$i = (Input::post('point') == 'top') ? -5 : 5;
			$source->disp_num = $target->disp_num + $i;
			$source->save();

			if($source_type == 'group') {
				$this->resetGroupDispNum();
			}else{
				$this->resetItemDispNum($source->group_id);
			}
		}else{
		//別フォルダへのアイテムの移動
			$source = Model_Item::find_by_pk($source_id);
			$source->group_id = $target_id;
			$source->save();

			$this->resetItemDispNum($source->group_id);
		}

	}

}
