<?php

class Model_Lang extends \Model_Crud
{
	protected static $_properties = array(
		'id',
		'name',
		'fullname',
		'enabled',
		'created_at',
		'updated_at',
	);

	public static function getHtmlOptions() {
		$langs = Model_Lang::find_by('enabled', 1);
		$ret = '';
		foreach($langs as $lang) {
			$ret .= '<option value="'.$lang->name.'">'.$lang->fullname.'</option>';
		}
		return $ret;
	}

	public static function getHtmlCheckboxes() {
		$langs = Model_Lang::find_all();
		$ret = '<ul>';
		foreach($langs as $lang) {
			$checked = $lang->enabled ? ' checked' : '';
			$name = $lang->name;
			$ret .= '<li><input id="'.$name.'" type="checkbox" name="langs[]" value="'.$name.'"'.$checked.'>'
				        . '<label for="'.$name.'">'.$lang->fullname.'</label></li>';
		}
		$ret .= '</ul>';
	
		return $ret;
	}

	protected static $_observers = array(
		'Orm\Observer_CreatedAt' => array(
			'events' => array('before_insert'),
			'mysql_timestamp' => false,
		),
		'Orm\Observer_UpdatedAt' => array(
			'events' => array('before_update'),
			'mysql_timestamp' => false,
		),
	);
	protected static $_table_name = 'langs';

}
