/* ---------------------------------------------------------------------
%   Copyright (C) 2007 Association for the COINS Compiler Infrastructure
%       (Read COPYING for detailed information.)
--------------------------------------------------------------------- */
/*
 * DeadCodeElim.java
 *
 * Created on August 27, 2002, 4:30 PM
 */

package coins.opt;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set; //##63

//##63 import coins.aflow.BBlock;
import coins.flow.BBlock; //##63
//##63 import coins.aflow.Flow;
import coins.flow.Flow; //##63
//##63 import coins.aflow.FlowAnalSymVector;
import coins.flow.FlowAnalSymVector; //##63
import coins.aflow.FlowResults;
//##63 import coins.aflow.FlowUtil;
import coins.flow.FlowUtil; //##63
//##63 import coins.aflow.NodeIterator;
import coins.flow.NodeIterator; //##63
//##63 import coins.aflow.SetRefRepr;
import coins.flow.SetRefRepr; //##63
//##63 import coins.aflow.SetRefReprIterator;
import coins.flow.SetRefReprHirImpl; //##65
//##63 import coins.aflow.SetRefReprList;
import coins.flow.SetRefReprList; //##63
//##63 import coins.aflow.SubpFlow;
import coins.flow.SubpFlow; //##63
//##63 import coins.aflow.util.FAList;
import coins.flow.FAList; //##63
import coins.ir.IR;
import coins.ir.hir.AssignStmt; //##65
import coins.ir.hir.HIR;
import coins.sym.FlowAnalSym;
import coins.sym.Sym;
import coins.sym.Var; //##63

/**
 * Dead code elimination class.
 *
 * @author  hasegawa
 */
public class DeadCodeElim
{
  final FlowResults fResults;
  public final Flow flow;
  public final Opt opt;
  protected SubpFlow fSubpFlow; //##63
  protected int fDbgLevel; //##65

  /** Creates a new instance of DeadCodeElim */
  //##64 DeadCodeElim(FlowResults pResults)
  DeadCodeElim(FlowResults pResults, Opt pOpt) //##64
  {
      fResults = pResults;
      flow = fResults.flowRoot.flow;
      //##64 opt = new Opt(fResults.flowRoot);
      opt = pOpt; //##64
  }

  /**
   * Performs dead code elimination for the given SubpFlow. Only checks each BBlock once.
   */
  public boolean doSubp(SubpFlow pSubpFlow)
  {
    boolean lOptimized = false;
    fSubpFlow = pSubpFlow; //##63
    fDbgLevel = fResults.flowRoot.ioRoot.dbgOpt1.getLevel(); //##65
    flow.dbg(1, "deadcode elim", fSubpFlow.getSubpSym().getName()); //##78
    //##63 for (Iterator lIt = pSubpFlow.getReachableBBlocks().iterator();
    for (Iterator lIt = pSubpFlow.getListOfBBlocksFromEntry().iterator(); //##63
         lIt.hasNext(); ) {
      lOptimized |= doBBlock((BBlock)lIt.next());
    }
    return lOptimized;
  }

  /**
   * Perform dead code elimination for the given BBlock.
   */
  public boolean doBBlock(BBlock pBBlock)
  {
    if ((pBBlock == null)||(pBBlock.getBBlockNumber() == 0))
      return false; //##63
    flow.dbg(3, "\nBBlock " + pBBlock.getBBlockNumber()); //##78
    //##63 SetRefReprList lSetRefReprs = pBBlock.getSetRefReprs();
    SetRefReprList lSetRefReprs = fSubpFlow.getSetRefReprList(pBBlock); //##63
    SetRefRepr lSetRefRepr;
    SubpFlow lSubpFlow = pBBlock.getSubpFlow();
    //##63 FlowAnalSymVector lLive = flow.flowAnalSymVector(lSubpFlow);
    FlowAnalSymVector lLive = lSubpFlow.flowAnalSymVector(); //##63
    //##63 FlowAnalSymVector lFullVect = flow.flowAnalSymVector(lSubpFlow);
    FlowAnalSymVector lFullVect = lSubpFlow.flowAnalSymVector(); //##63
    lFullVect.vectorNot(lFullVect);
    FlowAnalSymVector lUsed = pBBlock.getUsed(); //##78
    Set lUsedSyms = lUsed.flowAnalSyms(); //##78
    //##63 pBBlock.getPLiveOut().vectorCopy(lLive);
    pBBlock.getLiveOut().vectorCopy(lLive); //##63
    flow.dbg(4, "LiveOut", lLive.toStringDescriptive()); //##78
    flow.dbg(4, "Used", lUsedSyms.toString()); //##78
    IR lIR;
    IR lCallNode = null;
    boolean lHasCall;
    //##63 FAList lSymIndexTable = lSubpFlow.getSymIndexTable();
    Set lSetOfUsedSyms = lSubpFlow.getUsedSyms(); //##63
    boolean lOptimized = false;
    FlowAnalSym lFlowAnalSym;
    //##63 final FlowAnalSymVector lExternallyReferrableVars = flow.flowAnalSymVector(lSubpFlow);
    final FlowAnalSymVector lExternallyReferrableVars = lSubpFlow.
      flowAnalSymVector(); //##63
    LinkedList FlowAnalList;
    FlowAnalList = new LinkedList();

    //##63 for (int i = 1; i <= lSubpFlow.getSymIndexTable().size(); i++)
    //##63     lExternallyReferrableVars.setBit(i);
    //##63 BEGIN
    for (Iterator lIterator = lSetOfUsedSyms.iterator();
         lIterator.hasNext(); ) {
      Sym lSym = (Sym)lIterator.next();
      lExternallyReferrableVars.setBit(((FlowAnalSym)lSym).getIndex());
    }
    //##63 END
    //##63 for (SetRefReprIterator lSetRefReprIt
    //##63      = lSetRefReprs.setRefReprIterator(lSetRefReprs.size());
    //##63      lSetRefReprIt.hasPrevious();)
    for (Iterator lSetRefReprIt = lSetRefReprs.reverseIterator(); //##63
         lSetRefReprIt.hasNext(); ) { //##63
      //##63 lSetRefRepr = (SetRefRepr)lSetRefReprIt.previous();
      lSetRefRepr = (SetRefRepr)lSetRefReprIt.next(); //##63
      HIR lDefNode = (HIR)lSetRefRepr.defNode(); //##65
      lHasCall = lSetRefRepr.hasCallWithSideEffect(); //##71
      if ((fDbgLevel > 1)&&(lDefNode != null))
        flow.dbg(4, "SetRefRepr", "Def " + lDefNode.toStringShort()
                 + " hasCall " + lHasCall + " sets " + lSetRefRepr.sets()
                 + " topUseNode " + lSetRefRepr.topUseNode()); //##78
      if (lSetRefRepr.sets()) {
        //##63 if (FlowUtil.isSameTree(lSetRefRepr.defNode(), lSetRefRepr.topUseNode(), fResults))
        if (((HIR)lSetRefRepr.defNode()).isSameAs((HIR)lSetRefRepr.topUseNode()))  //##63
        { //##63
          //##65 if (!lHasCall)
          if ((!lHasCall)&&(lDefNode instanceof AssignStmt)) //##65
          {
            if (fDbgLevel >= 3)
              flow.dbg(3, "deleteStmt", lDefNode.toStringShort()); //##65
            OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt()); //##65
            lSetRefReprIt.remove();
            /* //##65
            if (opt.shouldTrace(3)) {
              lSubpFlow.getSubpDefinition().printHir("Dead code elim");
            }
              */ //##65
            lOptimized = true;
            continue;
          }
        }
        FlowAnalSym lDefSym = (FlowAnalSym)lSetRefRepr.defSym();

        //##63 FlowAnalSymVector lIntersection = flow.flowAnalSymVector(lSubpFlow);
        FlowAnalSymVector lIntersection = lSubpFlow.flowAnalSymVector(); //##63
        //##63 lSetRefRepr.getPDefined().vectorAnd(lLive, lIntersection);
        pBBlock.getDefined().vectorAnd(lLive, lIntersection); //##63
        if (lIntersection.isZero() && !mayWriteToExternalAddress(lSetRefRepr) &&
            !lHasCall) {
          boolean remove;
          remove = true;
          for (NodeIterator lNodeIt =
               FlowUtil.nodeListIterator(lSetRefRepr.getIR(), true, false);
               lNodeIt.hasNext(); ) {
            HIR node = (HIR)lNodeIt.next();
            //##63 if  (FlowUtil.flowAnalSym(node) != null)  {
            if (node.getSym()instanceof FlowAnalSym) { //##63
              lFlowAnalSym = (FlowAnalSym)node.getSym();
              if (fDbgLevel >= 3)
                flow.dbg(5, "symNode", node.toStringShort()); //##78
              if (lFlowAnalSym.getFlag(Sym.FLAG_ADDRESS_TAKEN) == true) {
                remove = false;
                break;
              }
              //##63 if(FlowUtil.IsVarSyms((Sym)lFlowAnalSym) == false) {
              if (!((lFlowAnalSym instanceof Var) && //##63
                    lFlowAnalSym.getSymType().isScalar())) { //##63
                remove = false;
                break;
              }
              if (FlowAnalList.contains(lFlowAnalSym) == true) {
                remove = false;
                break;
              }
              if (lFlowAnalSym.isGlobal() == true) {
                remove = false;
                break;
              }
              //##78 BEGIN
              if (lUsedSyms.contains(lFlowAnalSym)) {
                // REFINE (see DefUseList)
                remove = false;
                break;
              }
              //##78 END
            }
          }

          //##65 if (remove == true)
          if (remove &&
              (((SetRefReprHirImpl)lSetRefRepr).getStmt() instanceof AssignStmt)) //##65
          {
            if (fDbgLevel >= 3) //##65
              flow.dbg(3, "removeStmt",
                ((SetRefReprHirImpl)lSetRefRepr).getStmt().toStringShort()); //##65
            OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt()); //##65
            lSetRefReprIt.remove();
            lOptimized = true; //##65
          }
          else {
            for (NodeIterator lNodeIt =
                 FlowUtil.nodeListIterator(lSetRefRepr.getIR(), true, false);
                 lNodeIt.hasNext(); ) {
              HIR node = (HIR)lNodeIt.next();
              //##63 if  (FlowUtil.flowAnalSym(node) != null)  {
              if (node.getSym()instanceof FlowAnalSym) { //##63
                lFlowAnalSym = (FlowAnalSym)node.getSym();
                FlowAnalList.add(lFlowAnalSym);
              }
            }
          }
          /* //##65
          if (opt.shouldTrace(3)) {
            lSubpFlow.getSubpDefinition().printHir("Dead code elim");
          }
            */ //##65
          //##65 lOptimized = true;
        }
        else {
          if (lDefSym != null) {

            //##63 lLive.resetBit(lSymIndexTable.indexOf(lDefSym));
            lLive.resetBit(lDefSym.getIndex()); //##63
            //##63 lLive.vectorOr(lSetRefRepr.getPExposed(), lLive);
          }
          lLive.vectorOr(pBBlock.getExposed(), lLive); //##63
        }
      }
      else if (!lSetRefRepr.hasControl() && !lSetRefRepr.isReturn() &&
               //##65 !lHasCall)
               !lHasCall &&
               (((SetRefReprHirImpl)lSetRefRepr).getStmt() instanceof AssignStmt)) //##65
      {
        OptUtil.deleteStmt(((SetRefReprHirImpl)lSetRefRepr).getStmt()); //##65
        lSetRefReprIt.remove();
//                for (NodeIterator lNodeIt = FlowUtil.nodeListIterator(lSetRefRepr.getIR(), true, false); lNodeIt.hasNext();) // Assuming left-to-right evaluation order
//                {
//                    lIR = lNodeIt.next();
//
//                }
        lOptimized = true;
      }
      else {
        //##63 lLive.vectorOr(lSetRefRepr.getPExposed(), lLive);
        lLive.vectorOr(pBBlock.getExposed(), lLive); //##63
      }
    }
    return lOptimized;
  }

  private static boolean mayWriteToExternalAddress(SetRefRepr pSetRefRepr)
  {
    IR lDefNode = pSetRefRepr.defNode();
    return lDefNode != null && FlowUtil.mayBeExternalAddress(lDefNode);
  }
}
