package coins.backend.gen;

import coins.backend.Storage;
import coins.backend.sym.SymTab;
import coins.backend.util.ImList;

public class MachineParams_x86 extends coins.backend.MachineParams {

  public int nRegisters() { return 40; }
  public int nRegsets() { return 54; }

  public int typeAddress() { return 514; }
  public int typeBool() { return 514; }
  public String[] getSymName() {
    return new String[]{
      "%edxeax",
      "%ebxecx",
      "%ediesi",
      "%eax",
      "%ecx",
      "%edx",
      "%ebx",
      "%esi",
      "%edi",
      "%ax",
      "%cx",
      "%dx",
      "%bx",
      "%si",
      "%di",
      "%al",
      "%ah",
      "%cl",
      "%ch",
      "%dl",
      "%dh",
      "%bl",
      "%bh",
      "%f0",
      "%f1",
      "%f2",
      "%f3",
      "%f4",
      "%t0",
      "%t1",
      "%t2",
      "%t3",
      "%t4",
      "%t5",
      "%t6",
      "%t7",
      "%ebp",
      "%esp",
      "%t0/F32/0",
      "%t1/F32/0",
      "%t2/F32/0",
      "%t3/F32/0",
      "%t4/F32/0",
      "%t5/F32/0",
      "%t6/F32/0",
      "%t7/F32/0",
    };
  };
  public int[] getSymType() {
    return new int[] {
      1026,
      1026,
      1026,
      514,
      514,
      514,
      514,
      514,
      514,
      258,
      258,
      258,
      258,
      258,
      258,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      130,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      1028,
      514,
      514,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
      516,
    };
  };
  public int[] getSymRegNumber() {
    return new int[] {
      1,
      2,
      3,
      4,
      5,
      6,
      7,
      8,
      9,
      10,
      11,
      12,
      13,
      14,
      15,
      16,
      17,
      18,
      19,
      20,
      21,
      22,
      23,
      0,
      0,
      0,
      0,
      0,
      24,
      25,
      26,
      27,
      28,
      29,
      30,
      31,
      0,
      0,
      32,
      33,
      34,
      35,
      36,
      37,
      38,
      39,
    };
  };

  public short[][] getOverlapReg() {
    return new short[][] { {},
  /* 1: */ {4,6,10,12,16,17,20,21,},
  /* 2: */ {5,7,11,13,18,19,22,23,},
  /* 3: */ {8,9,14,15,},
  /* 4: */ {1,10,16,17,},
  /* 5: */ {2,11,18,19,},
  /* 6: */ {1,12,20,21,},
  /* 7: */ {2,13,22,23,},
  /* 8: */ {3,14,},
  /* 9: */ {3,15,},
  /* 10: */ {1,4,16,17,},
  /* 11: */ {2,5,18,19,},
  /* 12: */ {1,6,20,21,},
  /* 13: */ {2,7,22,23,},
  /* 14: */ {3,8,},
  /* 15: */ {3,9,},
  /* 16: */ {1,4,10,},
  /* 17: */ {1,4,10,},
  /* 18: */ {2,5,11,},
  /* 19: */ {2,5,11,},
  /* 20: */ {1,6,12,},
  /* 21: */ {1,6,12,},
  /* 22: */ {2,7,13,},
  /* 23: */ {2,7,13,},
  /* 24: */ {32,},
  /* 25: */ {33,},
  /* 26: */ {34,},
  /* 27: */ {35,},
  /* 28: */ {36,},
  /* 29: */ {37,},
  /* 30: */ {38,},
  /* 31: */ {39,},
  /* 32: */ {24,},
  /* 33: */ {25,},
  /* 34: */ {26,},
  /* 35: */ {27,},
  /* 36: */ {28,},
  /* 37: */ {29,},
  /* 38: */ {30,},
  /* 39: */ {31,},
    };
  };

  public short[][] getSuperReg() {
    return new short[][] { {},
  /* 1: */ {},
  /* 2: */ {},
  /* 3: */ {},
  /* 4: */ {1,},
  /* 5: */ {2,},
  /* 6: */ {1,},
  /* 7: */ {2,},
  /* 8: */ {3,},
  /* 9: */ {3,},
  /* 10: */ {1,4,},
  /* 11: */ {2,5,},
  /* 12: */ {1,6,},
  /* 13: */ {2,7,},
  /* 14: */ {3,8,},
  /* 15: */ {3,9,},
  /* 16: */ {1,4,10,},
  /* 17: */ {1,4,10,},
  /* 18: */ {2,5,11,},
  /* 19: */ {2,5,11,},
  /* 20: */ {1,6,12,},
  /* 21: */ {1,6,12,},
  /* 22: */ {2,7,13,},
  /* 23: */ {2,7,13,},
  /* 24: */ {},
  /* 25: */ {},
  /* 26: */ {},
  /* 27: */ {},
  /* 28: */ {},
  /* 29: */ {},
  /* 30: */ {},
  /* 31: */ {},
  /* 32: */ {24,},
  /* 33: */ {25,},
  /* 34: */ {26,},
  /* 35: */ {27,},
  /* 36: */ {28,},
  /* 37: */ {29,},
  /* 38: */ {30,},
  /* 39: */ {31,},
    };
  };

  public short[][] getSubReg() {
    return new short[][] { {},
  /* 1: */ {4,6,10,12,16,17,20,21,},
  /* 2: */ {5,7,11,13,18,19,22,23,},
  /* 3: */ {8,9,14,15,},
  /* 4: */ {10,16,17,},
  /* 5: */ {11,18,19,},
  /* 6: */ {12,20,21,},
  /* 7: */ {13,22,23,},
  /* 8: */ {14,},
  /* 9: */ {15,},
  /* 10: */ {16,17,},
  /* 11: */ {18,19,},
  /* 12: */ {20,21,},
  /* 13: */ {22,23,},
  /* 14: */ {},
  /* 15: */ {},
  /* 16: */ {},
  /* 17: */ {},
  /* 18: */ {},
  /* 19: */ {},
  /* 20: */ {},
  /* 21: */ {},
  /* 22: */ {},
  /* 23: */ {},
  /* 24: */ {32,},
  /* 25: */ {33,},
  /* 26: */ {34,},
  /* 27: */ {35,},
  /* 28: */ {36,},
  /* 29: */ {37,},
  /* 30: */ {38,},
  /* 31: */ {39,},
  /* 32: */ {},
  /* 33: */ {},
  /* 34: */ {},
  /* 35: */ {},
  /* 36: */ {},
  /* 37: */ {},
  /* 38: */ {},
  /* 39: */ {},
    };
  };

  public String[] getRegsetName() {
    return new String[] {
      "*reg-edxeax-I64*",
      "*reg-ebxecx-I64*",
      "*reg-eax-I32*",
      "*reg-ecx-I32*",
      "*reg-edx-I32*",
      "*reg-ax-I16*",
      "*reg-cx-I16*",
      "*reg-al-I8*",
      "*reg-cl-I8*",
      "*reg-I64*",
      "*reg-I32*",
      "*reg-I16*",
      "*reg-I8*",
      "*reg-tmp-F64*",
      "*reg-tmp-F32*",
      "*reg-bytable-I64*",
      "*reg-bytable-I32*",
      "*reg-bytable-I16*",
      "*reg-call-clobbers*",
      "*reg-callee-saves*",
      "*reg-mod$2-I32*",
    };
  };
  public int[] getRegsetNumber() {
    return new int[] {
      1,
      2,
      4,
      5,
      6,
      10,
      11,
      16,
      18,
      40,
      41,
      42,
      43,
      44,
      45,
      46,
      47,
      48,
      49,
      50,
      51,
    };
  };
  public short[][] getRegsetMap() {
    return new short[][] {
      {1,2,3,},
      {4,5,6,7,8,9,},
      {10,11,12,13,14,15,},
      {16,17,18,19,20,21,22,23,},
      {24,25,26,27,28,29,30,31,},
      {32,33,34,35,36,37,38,39,},
      {1,2,},
      {4,5,6,7,},
      {10,11,12,13,},
      {4,5,6,},
      {7,8,9,},
      {4,5,7,8,9,},
      {4,5,7,},
      {4,5,},
    };
  };

  public short[] getRegsetNAvail() {
    return new short[] {
      0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
      3, 6, 6, 8, 8, 8, 2, 4, 4, 3, 
      3, 5, 3, 2,     };
  };

  public int[] getCompAndTbl() {
    return new int[] {
      -781,1,2,3,
      -824,4,5,6,7,8,9,
      -871,10,11,12,13,14,15,
      -919,16,17,18,19,20,21,22,23,
      -970,24,25,26,27,28,29,30,31,
      -1022,32,33,34,35,36,37,38,39,
      -1036,1,2,
      -1075,46,
      -1085,4,5,6,7,
      -1122,47,
      -1138,10,11,12,13,
      -1170,48,
      -1180,4,5,6,
      -1217,49,
      -1223,49,
      -1232,7,8,9,
      -1266,50,
      -1272,7,
      -1279,4,5,
      -1282,7,8,9,
      -1316,51,
      -1322,52,
      -1324,53,50,
      -1330,4,5,
      -1333,7,
      -1367,52,
      -1373,52,
      -1375,53,7,52,
      -1382,4,5,
      -1419,53,
      -1425,53,
      -1427,53,
      -1429,53,53,    };
  };

  public int[] getCompWeightTbl() {
    return new int[] {
    55,65,
    58,65,
    60,65,
    64,65,
    66,65,
    70,129,
    74,129,
    94,257,
    100,257,
    105,193,
    110,65,
    113,65,
    115,65,
    119,65,
    121,65,
    126,129,
    130,129,
    148,257,
    154,513,
    165,65,
    170,129,
    176,129,
    202,193,
    212,129,
    217,65,
    220,65,
    226,65,
    232,129,
    256,257,
    262,257,
    267,193,
    272,65,
    275,65,
    281,65,
    288,129,
    310,257,
    316,257,
    321,193,
    325,65,
    330,65,
    336,65,
    344,129,
    364,257,
    370,257,
    380,65,
    385,65,
    391,65,
    400,129,
    418,257,
    424,193,
    428,193,
    435,65,
    440,65,
    446,65,
    472,193,
    482,129,
    489,65,
    495,65,
    501,65,
    526,193,
    536,129,
    541,65,
    544,65,
    550,65,
    556,129,
    580,257,
    586,257,
    591,193,
    596,65,
    599,65,
    605,65,
    612,129,
    634,257,
    640,257,
    645,193,
    649,65,
    654,65,
    660,65,
    668,129,
    688,257,
    694,257,
    704,65,
    709,65,
    715,65,
    724,129,
    742,257,
    748,193,
    752,193,
    759,65,
    764,65,
    770,65,
    796,193,
    806,129,
    813,65,
    819,65,
    825,65,
    850,193,
    860,129,
    865,65,
    868,65,
    874,65,
    880,65,
    904,257,
    910,257,
    915,193,
    919,65,
    922,65,
    928,65,
    935,65,
    958,257,
    964,257,
    969,193,
    974,65,
    977,65,
    983,65,
    990,65,
    1012,257,
    1018,257,
    1023,193,
    1028,65,
    1031,65,
    1037,65,
    1045,65,
    1066,257,
    1072,257,
    1077,193,
    1081,65,
    1086,65,
    1092,65,
    1100,65,
    1120,257,
    1126,257,
    1135,65,
    1140,65,
    1146,65,
    1155,65,
    1174,257,
    1180,257,
    1190,65,
    1195,65,
    1201,65,
    1210,65,
    1228,257,
    1234,193,
    1238,193,
    1244,65,
    1249,65,
    1255,65,
    1265,65,
    1282,257,
    1288,193,
    1292,193,
    1320,65,
    1328,65,
    1340,129,
    1375,65,
    1383,65,
    1394,129,
    1430,65,
    1438,65,
    1448,129,
    1485,65,
    1493,65,
    1502,129,
    1540,65,
    1548,65,
    1556,129,
    1595,65,
    1603,65,
    1610,129,
    1650,65,
    1658,65,
    1664,129,
    1705,65,
    1713,65,
    1718,129,
    1752,65,
    1760,65,
    1772,129,
    1807,65,
    1815,65,
    1826,129,
    1862,65,
    1870,65,
    1880,129,
    1917,65,
    1925,65,
    1934,129,
    1972,65,
    1980,65,
    1988,129,
    2027,65,
    2035,65,
    2042,129,
    2082,65,
    2090,65,
    2096,129,
    2137,65,
    2145,65,
    2150,129,
    2161,1473,
    2200,257,
    2206,513,
    2215,194,
    2218,1281,
    2254,66,
    2255,193,
    2260,66,
    2261,449,
    2269,194,
    2272,1281,
    2308,66,
    2309,193,
    2314,66,
    2315,449,
    2323,132,
    2326,258,
    2332,258,
    2338,513,
    2362,68,
    2363,130,
    2365,65,
    2368,68,
    2369,450,
    2400,1025,
    2420,129,
    2454,1025,
    2474,129,
    2485,129,
    2488,257,
    2494,257,
    2500,513,
    2524,257,
    2530,513,
    2539,130,
    2542,257,
    2548,257,
    2554,513,
    2578,66,
    2579,193,
    2584,66,
    2585,449,
    2593,130,
    2596,257,
    2602,257,
    2608,513,
    2632,66,
    2633,193,
    2638,66,
    2639,449,
    2647,66,
    2648,65,
    2650,193,
    2656,193,
    2662,385,
    2686,66,
    2687,193,
    2692,66,
    2693,193,
    2697,193,
    2702,65,
    2703,66,
    2707,193,
    2713,193,
    2722,129,
    2740,66,
    2741,193,
    2746,193,
    2750,193,
    2755,65,
    2756,130,
    2758,129,
    2761,321,
    2767,449,
    2776,129,
    2794,66,
    2795,193,
    2800,66,
    2801,449,
    2809,65,
    2810,66,
    2812,129,
    2815,65,
    2818,129,
    2821,65,
    2824,257,
    2830,129,
    2848,66,
    2849,193,
    2854,66,
    2855,449,
    2863,129,
    2866,129,
    2872,129,
    2878,257,
    2902,257,
    2908,257,
    2913,193,
    };
  };

  public int[] getRegsetTypeTbl() {
    return new int[] {
    -1,
    1026,
    1026,
    1026,
    514,
    514,
    514,
    514,
    514,
    514,
    258,
    258,
    258,
    258,
    258,
    258,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    130,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    1028,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    516,
    1026,
    514,
    258,
    130,
    1028,
    516,
    1026,
    514,
    258,
    514,
    514,
    514,
    514,
    514,
    };
  }
}
