/* ---------------------------------------------------------------------
%   Copyright (C) 2007 Association for the COINS Compiler Infrastructure
%       (Read COPYING for detailed information.)
--------------------------------------------------------------------- */
package coins.util;

/**
 * ξ岼(Ѥͥ饹).
 * ͭ¥ӥåȿ2ʿͤΤȤϰϤ򡢾峦Ȳɽ
 * ϰϤȤȤϸ¤ʤ㤨3,4,7Ȥˤ37ޤǤɽ
 * 峦ȲϡΥӥåȿǤ롣
 * ʤĤξβб뤿ᡢ&gt;峦ǤäƤ褤Ȥ롣
 * Ĥޤꡢ&lt;=峦ʤ顢&lt;=&lt;=峦Ǥ뤳Ȥɽ
 * &gt;峦ʤ顢&lt;=ͤޤ&lt;=峦Ǥ뤳Ȥɽ
 * ϰϤ黻ˤäƤɤΤ褦Ť뤫᥽åɤ󶡤롣
 */
public final class IntBound {

// field

/**  */
  public final IntConst lower;
/** 峦 */
  public final IntConst upper;

// constructor

/** Ⱦ峦IntBound. */
  public IntBound(IntConst val) {
    this.lower=val; this.upper=val;
  }
/** ꤵ줿Ⱦ峦IntBound.
 * @exception IllegalArgumentException Ⱦ峦Υӥåȿۤʤ */
  public IntBound(IntConst lower,IntConst upper) {
    if(lower.size()!=upper.size()) throw new IllegalArgumentException(lower+" "+upper);
    this.lower=lower; this.upper=upper;
  }

// method

/** IntBoundΥӥåȿ֤. */
  public int size() {
    return lower.size();
  }
/** ꤵ줿IntBoundäƤ뤫ɤ֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿Υӥåȿۤʤ */
  public boolean contains(IntConst c) {
    if(size()!=c.size()) throw new IllegalArgumentException(this+" "+c);
    return c.sub(lower).compareTo(upper.sub(lower))<=0;
  }
/** ꤵ줿IntBoundȤιʻ֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound union(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    // IntBoundβ
    IntConst u0=upper.sub(lower);
    IntConst l1=b.lower.sub(lower);
    IntConst u1=b.upper.sub(lower);
    if(l1.compareTo(u1)<=0) { // l0=0,l1,u1ν
      if(u1.compareTo(u0)<=0) return this;
      if(l1.compareTo(u0)<=0) return new IntBound(lower,b.upper);
      // l0=0,u0,l1,u1νΤȤϡu1-l0=u1u0-l1٤
      if(u1.compareTo(u0.sub(l1))<=0) return new IntBound(lower,b.upper);
      else return new IntBound(b.lower,upper);
    } else { // l0=0,u1,l1ν
      if(u1.compareTo(u0)>=0) return b;
      if(l1.compareTo(u0)>0) return new IntBound(b.lower,upper);
      // l0=0,u1,l1,u0ΤȤϡˤ錄
      IntConst l=IntConst.valueOf(size(),0);
      return new IntBound(l,l.bnot());
    }
  }
/** ꤵ줿IntBoundȤζʬ֤.
 * ʬΤȤnull֤
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound intersection(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    // IntBoundβ
    IntConst u0=upper.sub(lower);
    IntConst l1=b.lower.sub(lower);
    IntConst u1=b.upper.sub(lower);
    if(l1.compareTo(u1)<=0) { // l0=0,l1,u1ν
      if(u1.compareTo(u0)<=0) return b;
      if(l1.compareTo(u0)<=0) return new IntBound(b.lower,upper);
      // l0=0,u0,l1,u1νΤȤϡ
      return null;
    } else { // l0=0,u1,l1ν
      if(u1.compareTo(u0)>=0) return this;
      if(l1.compareTo(u0)>0) return new IntBound(lower,b.upper);
      // l0=0,u1,l1,u0νΤȤϡu0-l0=u0u1-l1٤
      if(u0.compareTo(u1.sub(l1))<=0) return this;
      else return b;
    }
  }
/** this+bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound add(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    IntConst r0=upper.sub(lower); // thisξ岼κ
    IntConst r1=b.upper.sub(b.lower); // bξ岼κ
    IntConst l,u;
    // r0r1¤åץ饦ɤ顢this+bˤ錄
    if(r0.add(r1).compareTo(r0)<0) { l=IntConst.valueOf(size(),0); u=l.bnot(); }
    // ǤʤС̤˷׻
    else { l=lower.add(b.lower); u=upper.add(b.upper); }
    return new IntBound(l,u);
  }
/** this-bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound sub(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    IntConst r0=upper.sub(lower); // thisξ岼κ
    IntConst r1=b.upper.sub(b.lower); // bξ岼κ
    IntConst l,u;
    // r0r1¤åץ饦ɤ顢this-bˤ錄
    if(r0.add(r1).compareTo(r0)<0) { l=IntConst.valueOf(size(),0); u=l.bnot(); }
    // ǤʤС̤˷׻
    else { l=lower.sub(b.upper); u=upper.sub(b.lower); }
    return new IntBound(l,u);
  }
/** this*bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound mul(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    final IntConst zero=IntConst.valueOf(size(),0);
    final IntConst msb=IntConst.valueOf(size(),1).lsh(size()-1);
    final IntBound plus=new IntBound(zero,msb.bnot()); // 0ޤϰ
    final IntBound minus=new IntBound(msb,zero.bnot()); // ϰ
    IntBound result=null;
    IntBound b0,b1,b2;
    // 軻ϥڥɤͤ礭ʬǤͭפʷ̤ФʤΤǡĤȤƹͤ
    // ڥɤǾʬΤιʻ롣
    if((b0=this.intersection(plus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        result=mul1(b0,b1);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=mul1(b0,b1.neg()).neg();
        result=result==null ? b2 : result.union(b2);
      }
    }
    if((b0=this.intersection(minus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        b2=mul1(b0.neg(),b1).neg();
        result=result==null ? b2 : result.union(b2);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=mul1(b0.neg(),b1.neg());
        result=result==null ? b2 : result.union(b2);
      }
    }
    //assert result!=null;
    return result;
  }
  // 椬ξΡѤξ岼֤
  private static IntBound mul1(IntBound b0,IntBound b1) {
    //assert b0.size()==b1.size();
    final int s=b0.size(),s2=s*2;
    final IntConst m=IntConst.valueOf(s2,1).lsh(s);
    IntConst l,u;
    // ĹǷ׻ơѤϰϤåץ饦ɤƤ顢ˤ錄
    if(b0.upper.convzx(s2).mul(b1.upper.convzx(s2))
      .sub(b0.lower.convzx(s2).mul(b1.lower.convzx(s2)))
      .compareTo(m)>=0) { l=IntConst.valueOf(s,0); u=l.bnot(); }
    // ǤʤС̤˷׻
    else { l=b0.lower.mul(b1.lower); u=b0.upper.mul(b1.upper); }
    return new IntBound(l,u);
  }
/** this/b(ʤ)IntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ
 * @exception ArithmeticException b0Τߤξ */
  public IntBound divu(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    IntConst l0=lower,u0=upper;
    IntConst l1=b.lower,u1=b.upper;
    // l0>u0,l1>u1ΤȤˤ錄Ȥ
    if(l0.compareTo(u0)>0) { l0=IntConst.valueOf(size(),0); u0=l0.bnot(); }
    if(l1.compareTo(u1)>0) { l1=IntConst.valueOf(size(),0); u1=l1.bnot(); }
    // l10ΤȤ1ˤ
    if(l1.signum()==0) l1=IntConst.valueOf(size(),1);
    // ̤˷׻(u10ΤȤArithmeticException)
    return new IntBound(l0.divu(u1),u0.divu(l1));
  }
/** this/b(Ĥ)IntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ
 * @exception ArithmeticException b0Τߤξ */
  public IntBound divs(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    if(b.lower.signum()==0 && b.upper.signum()==0) throw new ArithmeticException(this+" "+b);
    final IntConst zero=IntConst.valueOf(size(),0);
    final IntConst msb=IntConst.valueOf(size(),1).lsh(size()-1);
    final IntBound plus=new IntBound(zero,msb.bnot()); // 0ޤϰ
    final IntBound minus=new IntBound(msb,zero.bnot()); // ϰ
    IntBound result=null;
    IntBound b0,b1,b2;
    // ڥɤǾʬΤιʻ롣
    if((b0=this.intersection(plus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        result=b0.divu(b1);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=b0.divu(b1.neg()).neg();
        result=result==null ? b2 : result.union(b2);
      }
    }
    if((b0=this.intersection(minus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        b2=b0.neg().divu(b1).neg();
        result=result==null ? b2 : result.union(b2);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=b0.neg().divu(b1.neg());
        result=result==null ? b2 : result.union(b2);
      }
    }
    //assert result!=null;
    return result;
  }
/** this%b(ʤ;)IntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ
 * @exception ArithmeticException b0Τߤξ */
  public IntBound modu(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    // bñͤǡΤȤϡ̤˷׻
    // Ǥʤb.lower<=b.upperʤ顢0ʾb.upper̤
    // ʳʤ顢ϰϤˤ錄
    if(b.lower.equals(b.upper)) {
      if(b.lower.signum()==0) throw new ArithmeticException(this+" "+b);
      if(lower.compareTo(upper)<=0 && lower.divu(b.lower).equals(upper.divu(b.lower))) {
        return new IntBound(lower.modu(b.lower),upper.modu(b.lower));
      }
    }
    IntConst l=IntConst.valueOf(size(),0);
    IntConst u=b.lower.compareTo(b.upper)<=0 ? b.upper.sub(IntConst.valueOf(size(),1)) : l.bnot();
    return new IntBound(l,u);
  }
/** this%b(Ĥ;)IntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ
 * @exception ArithmeticException b0Τߤξ */
  public IntBound mods(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    if(b.lower.signum()==0 && b.upper.signum()==0) throw new ArithmeticException(this+" "+b);
    final IntConst zero=IntConst.valueOf(size(),0);
    final IntConst msb=IntConst.valueOf(size(),1).lsh(size()-1);
    final IntBound plus=new IntBound(zero,msb.bnot()); // 0ޤϰ
    final IntBound minus=new IntBound(msb,zero.bnot()); // ϰ
    IntBound result=null;
    IntBound b0,b1,b2;
    // ڥɤǾʬΤιʻ롣
    if((b0=this.intersection(plus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        result=b0.modu(b1);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=b0.modu(b1.neg());
        result=result==null ? b2 : result.union(b2);
      }
    }
    if((b0=this.intersection(minus))!=null) {
      if((b1=b.intersection(plus))!=null) {
        b2=b0.neg().modu(b1).neg();
        result=result==null ? b2 : result.union(b2);
      }
      if((b1=b.intersection(minus))!=null) {
        b2=b0.neg().modu(b1.neg()).neg();
        result=result==null ? b2 : result.union(b2);
      }
    }
    //assert result!=null;
    return result;
  }
/** this&amp;bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound band(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    // 0ޤǤȤʬ䤷ơ줾ξ岼ιʻ
    if(lower.compareTo(upper)<=0) {
      if(b.lower.compareTo(b.upper)<=0) {
        return minMaxAnd(lower,upper,b.lower,b.upper);
      } else {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxAnd(lower,upper,c0,b.upper).union(minMaxAnd(lower,upper,b.lower,c1));
      }
    } else {
      if(b.lower.compareTo(b.upper)<=0) {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxAnd(c0,upper,b.lower,b.upper).union(minMaxAnd(lower,c1,b.lower,b.upper));
      } else {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxAnd(c0,upper,c0,b.upper).union(minMaxAnd(c0,upper,b.lower,c1))
               .union(minMaxAnd(lower,c1,c0,b.upper)).union(minMaxAnd(lower,c1,b.lower,c1));
      }
    }
  }
// a<=x<=b, c<=y<=dΤȤΡx&yIntBound֤
  private static IntBound minMaxAnd(IntConst a,IntConst b,IntConst c,IntConst d) {
    return new IntBound(minAnd(a,b,c,d),maxAnd(a,b,c,d));
  }
// a<=x<=b, c<=y<=dΤȤΡx&yκǾ֤ͤ
// : Hacker's Delight 4-3
  private static IntConst minAnd(IntConst a,IntConst b,IntConst c,IntConst d) {
    final int size=a.size();
    IntConst m=IntConst.valueOf(size,1).lsh(size-1);
    while(m.signum()!=0) {
      if(a.bor(c).bnot().band(m).signum()!=0) {
        IntConst t;
        t=a.bor(m).band(m.neg());
        if(t.compareTo(b)<=0) { a=t; break; }
        t=c.bor(m).band(m.neg());
        if(t.compareTo(d)<=0) { c=t; break; }
      }
      m=m.rshu(1);
    }
    return a.band(c);
  }
// a<=x<=b, c<=y<=dΤȤΡx&yκ֤ͤ
// : Hacker's Delight 4-3
  private static IntConst maxAnd(IntConst a,IntConst b,IntConst c,IntConst d) {
    final int size=a.size();
    IntConst m=IntConst.valueOf(size,1).lsh(size-1);
    final IntConst one=IntConst.valueOf(size,1);
    while(m.signum()!=0) {
      if(b.band(d.bnot()).band(m).signum()!=0) {
        IntConst t=b.band(m.bnot()).bor(m.sub(one));
        if(t.compareTo(a)>=0) { b=t; break; }
      } else if(b.bnot().band(d).band(m).signum()!=0) {
        IntConst t=d.band(m.bnot()).bor(m.sub(one));
        if(t.compareTo(c)<=0) { d=t; break; }
      }
      m=m.rshu(1);
    }
    return b.band(d);
  }
/** this|bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound bor(IntBound b) {
    return this.bnot().band(b.bnot()).bnot();
  }
/** this^bIntBound֤.
 * @exception IllegalArgumentException IntBoundȻꤵ줿IntBoundΥӥåȿۤʤ */
  public IntBound bxor(IntBound b) {
    if(size()!=b.size()) throw new IllegalArgumentException(this+" "+b);
    // 0ޤǤȤʬ䤷ơ줾ξ岼ιʻ
    if(lower.compareTo(upper)<=0) {
      if(b.lower.compareTo(b.upper)<=0) {
        return minMaxXor(lower,upper,b.lower,b.upper);
      } else {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxXor(lower,upper,c0,b.upper).union(minMaxXor(lower,upper,b.lower,c1));
      }
    } else {
      if(b.lower.compareTo(b.upper)<=0) {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxXor(c0,upper,b.lower,b.upper).union(minMaxXor(lower,c1,b.lower,b.upper));
      } else {
        IntConst c0=IntConst.valueOf(size(),0),c1=c0.bnot();
        return minMaxXor(c0,upper,c0,b.upper).union(minMaxXor(c0,upper,b.lower,c1))
               .union(minMaxXor(upper,c1,c0,b.upper)).union(minMaxXor(upper,c1,b.lower,c1));
      }
    }
  }
// a<=x<=b, c<=y<=dΤȤΡx^yIntBound֤
  private static IntBound minMaxXor(IntConst a,IntConst b,IntConst c,IntConst d) {
    return new IntBound(minXor(a,b,c,d),maxXor(a,b,c,d));
  }
// a<=x<=b, c<=y<=dΤȤΡx^yβΰĤ֤
// : Hacker's Delight 4-3
  private static IntConst minXor(IntConst a,IntConst b,IntConst c,IntConst d) {
    return minAnd(a,b,d.bnot(),c.bnot()).bor(minAnd(b.bnot(),a.bnot(),c,d));
  }
// a<=x<=b, c<=y<=dΤȤΡx^yξ峦ΰĤ֤
// : Hacker's Delight 4-3
  private static IntConst maxXor(IntConst a,IntConst b,IntConst c,IntConst d) {
    final IntConst m=IntConst.valueOf(a.size(),0).bnot();
    return minAnd(maxAnd(a,b,d.bnot(),c.bnot()).bnot(),m,
                  maxAnd(b.bnot(),a.bnot(),c,d).bnot(),m).bnot();
  }
/** this&lt;&lt;bIntBound֤. */
  public IntBound lsh(IntBound b) {
    b=saturate(b,size());
    IntBound result=null;
    // 0ӥåȿޤǤγƥեȥȤϰϤᡢʻȤ
    for(int i=0;i<=size();i++) if(b.contains(IntConst.valueOf(b.size(),i))) {
      IntBound b1=this.lsh(i);
      result=result==null ? b1 : result.union(b1);
    }
    return result;
  }
/** this&gt;&gt;b(ʤե)IntBound֤. */
  public IntBound rshu(IntBound b) {
    b=saturate(b,size());
    IntBound result=null;
    // 0ӥåȿޤǤγƥեȥȤϰϤᡢʻȤ
    for(int i=0;i<=size();i++) if(b.contains(IntConst.valueOf(b.size(),i))) {
      IntBound b1=this.rshu(i);
      result=result==null ? b1 : result.union(b1);
    }
    return result;
  }
/** this&gt;&gt;b(Ĥե)IntBound֤. */
  public IntBound rshs(IntBound b) {
    b=saturate(b,size());
    IntBound result=null;
    // 0ӥåȿޤǤγƥեȥȤϰϤᡢʻȤ
    for(int i=0;i<=size();i++) if(b.contains(IntConst.valueOf(b.size(),i))) {
      IntBound b1=this.rshs(i);
      result=result==null ? b1 : result.union(b1);
    }
    return result;
  }
// ꤵ줿IntBound0iޤǤ˰¤֤
  private static IntBound saturate(IntBound b,int i) {
    IntConst i1=IntConst.valueOf(b.size(),i);
    IntConst l=b.lower,u=b.upper;
    int cmp=l.compareTo(u);
    // 岼iޤǤ˰¤
    if(l.compareTo(i1)>=0) l=i1;
    if(u.compareTo(i1)>=0) {
      u=i1;
      if(cmp>0) l=IntConst.valueOf(b.size(),0); // ˰i,u,lνä硢0
    }
    return new IntBound(l,u);
  }
/** this&lt;&lt;nIntBound֤.
 * @exception IllegalArgumentException nξ */
  public IntBound lsh(int n) {
    if(n<0) throw new IllegalArgumentException(String.valueOf(n));
    if(n==0) return this;
    if(n>=size()) return new IntBound(IntConst.valueOf(size(),0));
    IntConst r=upper.sub(lower);
    IntConst l,u;
    // r(thisξ岼κ)եȸˤϤ߽Фʤ顢ϰϤˤ錄
    // ǤʤС̤˷׻
    if(r.compareTo(IntConst.valueOf(size(),1).lsh(size()-n))>=0) {
      l=IntConst.valueOf(size(),0); u=l.bnot();
    } else {
      l=lower.lsh(n); u=upper.lsh(n);
    }
    return new IntBound(l,u);
  }
/** this&gt;&gt;n(ʤե)IntBound֤.
 * @exception IllegalArgumentException nξ */
  public IntBound rshu(int n) {
    if(n<0) throw new IllegalArgumentException(String.valueOf(n));
    if(n==0) return this;
    IntConst l=lower,u=upper;
    // 岼򤽤줾쥷եȤȡ峦(ʤ)礭Ȥ
    // (1)̥ӥåȤ0ǤʤͤޤǤޤ
    // (2)峦ǲ峦1礭Ȥʤɤǡ岼Ʊˤʤ롣
    // Ȥ꤬Τǡξ0~0򥷥եȤΤȤ
    if(l.compareTo(u)>0) { l=IntConst.valueOf(size(),0); u=l.bnot(); }
    // ǤʤС̤˷׻
    return new IntBound(l.rshu(n),u.rshu(n));
  }
/** this&gt;&gt;n(Ĥե)IntBound֤.
 * @exception IllegalArgumentException nξ */
  public IntBound rshs(int n) {
    if(n<0) throw new IllegalArgumentException(String.valueOf(n));
    if(n==0) return this;
    IntConst l=lower,u=upper;
    // 岼򤽤줾쥷եȤȡ峦(Ĥ)礭Ȥ
    // (1)̥ӥåȤĥǤʤͤޤǤޤ
    // (2)峦ǲ峦1礭Ȥʤɤǡ岼Ʊˤʤ롣
    // Ȥ꤬ΤǡξĤκǾȺ򥷥եȤΤȤ
    if(l.signedCompareTo(u)>0) { l=IntConst.valueOf(size(),1).lsh(size()-1); u=l.bnot(); }
    // ǤʤС̤˷׻
    return new IntBound(l.rshs(n),u.rshs(n));
  }
/** -thisIntBound֤. */
  public IntBound neg() {
    return new IntBound(upper.neg(),lower.neg());
  }
/** ~thisIntBound֤. */
  public IntBound bnot() {
    return new IntBound(upper.bnot(),lower.bnot());
  }
/** this==bIntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tsteq(IntBound b,int s) { return cmpeq(this,b,s,1); }
/** this!=bIntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstne(IntBound b,int s) { return cmpeq(this,b,s,0); }
/** this&lt;b(ʤ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstltu(IntBound b,int s) { return cmpu(this,b,s,1); }
/** this&gt;b(ʤ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstgtu(IntBound b,int s) { return cmpu(b,this,s,1); }
/** this&lt;=b(ʤ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstleu(IntBound b,int s) { return cmpu(b,this,s,0); }
/** this&gt;=b(ʤ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstgeu(IntBound b,int s) { return cmpu(this,b,s,0); }
/** this&lt;b(Ĥ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstlts(IntBound b,int s) { return cmps(this,b,s,1); }
/** this&gt;b(Ĥ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstgts(IntBound b,int s) { return cmps(b,this,s,1); }
/** this&lt;=b(Ĥ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstles(IntBound b,int s) { return cmps(b,this,s,0); }
/** this&gt;=b(Ĥ)IntBound֤.
 * @exception IllegalArgumentException Ȼꤵ줿Υӥåȿۤʤ */
  public IntBound tstges(IntBound b,int s) { return cmps(this,b,s,0); }
// b0b1ɬʤsӥåȤeqɬۤʤʤsӥåȤ1-eq
// ʳʤsӥåȤ01ޤIntBound֤
  private static IntBound cmpeq(IntBound b0,IntBound b1,int s,int eq) {
    if(b0.size()!=b1.size()) throw new IllegalArgumentException(b0+" "+b1);
    if(b0.lower.equals(b0.upper) && b1.lower.equals(b1.upper) &&
       b0.lower.equals(b1.lower)) return new IntBound(IntConst.valueOf(s,eq));
    if(b0.intersection(b1)==null) return new IntBound(IntConst.valueOf(s,1-eq));
    return new IntBound(IntConst.valueOf(s,0),IntConst.valueOf(s,1));
  }
// b0b1ɬsӥåȤltb0ɬb1ʾʤsӥåȤ1-lt
// ʳʤsӥåȤ01ޤIntBound֤(ʤ)
  private static IntBound cmpu(IntBound b0,IntBound b1,int s,int lt) {
    if(b0.size()!=b1.size()) throw new IllegalArgumentException(b0+" "+b1);
    if(b0.lower.compareTo(b0.upper)<=0 && b1.lower.compareTo(b1.upper)<=0) {
      if(b0.upper.compareTo(b1.lower)<0) return new IntBound(IntConst.valueOf(s,lt));
      if(b0.lower.compareTo(b1.upper)>=0) return new IntBound(IntConst.valueOf(s,1-lt));
    }
    return new IntBound(IntConst.valueOf(s,0),IntConst.valueOf(s,1));
  }
// b0b1ɬsӥåȤltb0ɬb1ʾʤsӥåȤ1-lt
// ʳʤsӥåȤ01ޤIntBound֤(Ĥ)
  private static IntBound cmps(IntBound b0,IntBound b1,int s,int lt) {
    if(b0.size()!=b1.size()) throw new IllegalArgumentException(b0+" "+b1);
    if(b0.lower.signedCompareTo(b0.upper)<=0 && b1.lower.signedCompareTo(b1.upper)<=0) {
      if(b0.upper.signedCompareTo(b1.lower)<0) return new IntBound(IntConst.valueOf(s,lt));
      if(b0.lower.signedCompareTo(b1.upper)>=0) return new IntBound(IntConst.valueOf(s,1-lt));
    }
    return new IntBound(IntConst.valueOf(s,0),IntConst.valueOf(s,1));
  }
/** IntBoundꤵ줿ӥåȿ˥ĥȤIntBound֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ */
  public IntBound convzx(int s) {
    if(s==size()) return this;
    if(s<size()) throw new IllegalArgumentException(this+" "+s);
    IntConst l=lower,u=upper;
    // 岼򤽤줾쥼ĥǤ褤
    // 峦(ʤ)礭Ȥϡ̥ӥåȤ0ǤʤͤޤǤޤ
    // ξϡΥӥåȿ0~0ΥĥΤۤ褤
    if(l.compareTo(u)>0) { l=IntConst.valueOf(size(),0); u=l.bnot(); }
    return new IntBound(l.convzx(s),u.convzx(s));
  }
/** IntBoundꤵ줿ӥåȿĥȤIntBound֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ */
  public IntBound convsx(int s) {
    if(s==size()) return this;
    if(s<size()) throw new IllegalArgumentException(this+" "+s);
    IntConst l=lower,u=upper;
    // 岼򤽤줾ĥǤ褤
    // 峦(Ĥ)礭Ȥϡ̥ӥåȤĥǤʤͤޤǤޤ
    // ξϡΥӥåȿĤκǾȺĥΤۤ褤
    if(l.signedCompareTo(u)>0) { l=IntConst.valueOf(size(),1).lsh(size()-1); u=l.bnot(); }
    return new IntBound(l.convsx(s),u.convsx(s));
  }
/** IntBoundꤵ줿ӥåȿ˽̾ȤIntBound֤.
 * @exception IllegalArgumentException ꤵ줿ӥåȿΤۤ礭ޤǤʤ */
  public IntBound convit(int s) {
    if(s==size()) return this;
    if(s>size() || s<=0) throw new IllegalArgumentException(this+" "+s);
    IntConst r=upper.sub(lower);
    IntConst l,u;
    // r(thisξ岼κ)̾ǤϤ߽Фʤ顢ϰϤˤ錄
    // Ǥʤ̤˷׻
    if(r.compareTo(IntConst.valueOf(size(),1).lsh(s))>=0) {
      l=IntConst.valueOf(s,0); u=l.bnot();
    } else {
      l=lower.convit(s); u=upper.convit(s);
    }
    return new IntBound(l,u);
  }
/** ꤵ줿tfΤ0ʳʤt0ʤfͤȤȤIntBound֤.
 * @exception IllegalArgumentException tfΥӥåȿۤʤ */
  public IntBound ifthenelse(IntBound t,IntBound f) {
    if(t.size()!=f.size()) throw new IllegalArgumentException(this+" "+t+' '+f);
    if(lower.signum()==0 && lower.equals(upper)) return t;
    if(!this.contains(IntConst.valueOf(size(),0))) return f;
    return t.union(f);
  }
/** IntBoundȻꤵ줿֥Ȥɤ֤. */
  public boolean equals(Object o) {
    return o==this ||
           o instanceof IntBound &&
           lower.equals(((IntBound)o).lower) && upper.equals(((IntBound)o).upper);
  }
/** IntBoundΥϥå女ɤ֤. */
  public int hashCode() {
    return lower.hashCode()*37+upper.hashCode();
  }
/** IntBoundʸɽ֤. */
  public String toString() {
    return "("+lower.bigValue()+".."+upper.bigValue()+"):"+size();
  }

}
