/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.calendar;

import com.google.gdata.client.Query;
import com.google.gdata.data.DateTime;
import java.net.URL;
import java.util.List;

public class CalendarQuery
extends Query {
    public static final String MINIMUM_START_TIME = "start-min";
    public static final String MAXIMUM_START_TIME = "start-max";

    public CalendarQuery(URL uRL) {
        super(uRL);
    }

    public void setMinimumStartTime(DateTime dateTime) {
        List<Query.CustomParameter> list = this.getCustomParameters();
        for (Query.CustomParameter customParameter : this.getCustomParameters(MINIMUM_START_TIME)) {
            list.remove(customParameter);
        }
        if (dateTime != null) {
            list.add(new Query.CustomParameter(MINIMUM_START_TIME, dateTime.toString()));
        }
    }

    public DateTime getMinimumStartTime() {
        List<Query.CustomParameter> list = this.getCustomParameters(MINIMUM_START_TIME);
        if (list.size() == 0) {
            return null;
        }
        return DateTime.parseDateTime(list.get(0).getValue());
    }

    public void setMaximumStartTime(DateTime dateTime) {
        List<Query.CustomParameter> list = this.getCustomParameters();
        for (Query.CustomParameter customParameter : this.getCustomParameters(MAXIMUM_START_TIME)) {
            list.remove(customParameter);
        }
        if (dateTime != null) {
            list.add(new Query.CustomParameter(MAXIMUM_START_TIME, dateTime.toString()));
        }
    }

    public DateTime getMaximumStartTime() {
        List<Query.CustomParameter> list = this.getCustomParameters(MAXIMUM_START_TIME);
        if (list.size() == 0) {
            return null;
        }
        return DateTime.parseDateTime(list.get(0).getValue());
    }
}

