/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.http;

import com.google.gdata.util.AuthenticationException;
import com.google.gdata.util.common.base.StringUtil;
import com.google.gdata.util.common.util.Base64;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthSubUtil {
    private static final String DEFAULT_PROTOCOL = "https";
    private static final String DEFAULT_DOMAIN = "www.google.com";
    private static final SecureRandom RANDOM = new SecureRandom();

    public static String getRequestUrl(String string, String string2, boolean bl, boolean bl2) {
        return AuthSubUtil.getRequestUrl(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, string, string2, bl, bl2);
    }

    public static String getRequestUrl(String string, String string2, String string3, String string4, boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(string).append("://");
        stringBuffer.append(string2).append("/accounts/AuthSubRequest");
        AuthSubUtil.addParameter(stringBuffer, "next", string3);
        AuthSubUtil.addParameter(stringBuffer, "scope", string4);
        AuthSubUtil.addParameter(stringBuffer, "secure", bl ? "1" : "0");
        AuthSubUtil.addParameter(stringBuffer, "session", bl2 ? "1" : "0");
        return stringBuffer.toString();
    }

    public static String getTokenFromReply(URL uRL) {
        return AuthSubUtil.getTokenFromReply(uRL.getQuery());
    }

    public static String getTokenFromReply(String string) {
        Map<String, String> map = StringUtil.string2Map(string, "&", "=", true);
        map = StringUtil.lowercaseKeys(map);
        return map.get("token");
    }

    public static PrivateKey getPrivateKeyFromKeystore(String string, String string2, String string3, String string4) throws IOException, GeneralSecurityException {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(new FileInputStream(string), string2.toCharArray());
        return (PrivateKey)keyStore.getKey(string3, string4.toCharArray());
    }

    public static String exchangeForSessionToken(String string, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        return AuthSubUtil.exchangeForSessionToken(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, string, privateKey);
    }

    public static String exchangeForSessionToken(String string, String string2, String string3, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        String string4 = AuthSubUtil.getSessionTokenUrl(string, string2);
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string5 = AuthSubUtil.formAuthorizationHeader(string3, privateKey, uRL, "GET");
        httpURLConnection.setRequestProperty("Authorization", string5);
        if (httpURLConnection.getResponseCode() != 200) {
            throw new AuthenticationException(httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
        }
        String string6 = StringUtil.stream2String(httpURLConnection.getInputStream(), -1);
        Map<String, String> map = StringUtil.string2Map(string6, "\n", "=", true);
        map = StringUtil.lowercaseKeys(map);
        return map.get("token");
    }

    public static Map<String, String> getTokenInfo(String string, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        return AuthSubUtil.getTokenInfo(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, string, privateKey);
    }

    public static Map<String, String> getTokenInfo(String string, String string2, String string3, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        String string4 = AuthSubUtil.getTokenInfoUrl(string, string2);
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string5 = AuthSubUtil.formAuthorizationHeader(string3, privateKey, uRL, "GET");
        httpURLConnection.setRequestProperty("Authorization", string5);
        if (httpURLConnection.getResponseCode() != 200) {
            throw new AuthenticationException(httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
        }
        String string6 = StringUtil.stream2String(httpURLConnection.getInputStream(), -1);
        return StringUtil.string2Map(string6.trim(), "\n", "=", true);
    }

    public static void revokeToken(String string, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        AuthSubUtil.revokeToken(DEFAULT_PROTOCOL, DEFAULT_DOMAIN, string, privateKey);
    }

    public static void revokeToken(String string, String string2, String string3, PrivateKey privateKey) throws IOException, GeneralSecurityException, AuthenticationException {
        String string4 = AuthSubUtil.getRevokeTokenUrl(string, string2);
        URL uRL = new URL(string4);
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string5 = AuthSubUtil.formAuthorizationHeader(string3, privateKey, uRL, "GET");
        httpURLConnection.setRequestProperty("Authorization", string5);
        if (httpURLConnection.getResponseCode() != 200) {
            throw new AuthenticationException(httpURLConnection.getResponseCode() + ": " + httpURLConnection.getResponseMessage());
        }
    }

    public static String formAuthorizationHeader(String string, PrivateKey privateKey, URL uRL, String string2) throws GeneralSecurityException {
        if (privateKey == null) {
            return String.format("AuthSub token=\"%s\"", string);
        }
        long l = System.currentTimeMillis() / 1000L;
        long l2 = RANDOM.nextLong();
        String string3 = String.format("%s %s %d %s", string2, uRL.toExternalForm(), l, AuthSubUtil.unsignedLongToString(l2));
        SignatureAlgorithm signatureAlgorithm = AuthSubUtil.getSigAlg(privateKey);
        byte[] byArray = AuthSubUtil.sign(privateKey, string3, signatureAlgorithm);
        String string4 = Base64.encode(byArray);
        return String.format("AuthSub token=\"%s\" data=\"%s\" sig=\"%s\" sigalg=\"%s\"", string, string3, string4, signatureAlgorithm.getAuthSubName());
    }

    private static void addParameter(StringBuffer stringBuffer, String string, String string2) {
        string = URLEncoder.encode(string);
        string2 = URLEncoder.encode(string2);
        if (stringBuffer.indexOf("?") == -1) {
            stringBuffer.append('?');
        } else {
            switch (stringBuffer.charAt(stringBuffer.length() - 1)) {
                case '?': {
                    break;
                }
                case '&': {
                    break;
                }
                default: {
                    stringBuffer.append('&');
                }
            }
        }
        stringBuffer.append(string).append('=').append(string2);
    }

    private static byte[] sign(PrivateKey privateKey, String string, SignatureAlgorithm signatureAlgorithm) throws GeneralSecurityException {
        Signature signature = Signature.getInstance(signatureAlgorithm.getJCAName());
        signature.initSign(privateKey);
        signature.update(string.getBytes());
        return signature.sign();
    }

    private static SignatureAlgorithm getSigAlg(PrivateKey privateKey) {
        String string = privateKey.getAlgorithm();
        if ("dsa".equalsIgnoreCase(string)) {
            return SignatureAlgorithm.DSA_SHA1;
        }
        if ("rsa".equalsIgnoreCase(string)) {
            return SignatureAlgorithm.RSA_SHA1;
        }
        throw new IllegalArgumentException("Unknown algorithm in private key.");
    }

    private static String getSessionTokenUrl(String string, String string2) {
        return string + "://" + string2 + "/accounts/AuthSubSessionToken";
    }

    private static String getRevokeTokenUrl(String string, String string2) {
        return string + "://" + string2 + "/accounts/AuthSubRevokeToken";
    }

    private static String getTokenInfoUrl(String string, String string2) {
        return string + "://" + string2 + "/accounts/AuthSubTokenInfo";
    }

    private static String unsignedLongToString(long l) {
        if (l >= 0L) {
            return Long.toString(l);
        }
        int n = 20;
        char[] cArray = new char[n];
        int n2 = 10;
        int n3 = n;
        long l2 = l >>> 32;
        long l3 = l & 0xFFFFFFFFL;
        l3 += l2 % (long)n2 << 32;
        l2 /= (long)n2;
        while (l3 > 0L || l2 > 0L) {
            cArray[--n3] = Character.forDigit((int)(l3 % (long)n2), n2);
            l3 = l3 / (long)n2 + (l2 % (long)n2 << 32);
            l2 /= (long)n2;
        }
        return new String(cArray, n3, n - n3);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum SignatureAlgorithm {
        DSA_SHA1("dsa-sha1", "SHA1withDSA"),
        RSA_SHA1("rsa-sha1", "SHA1withRSA");

        private final String authSubName;
        private final String jcaName;

        private SignatureAlgorithm(String string2, String string3) {
            this.authSubName = string2;
            this.jcaName = string3;
        }

        public String toString() {
            return this.jcaName;
        }

        public String getAuthSubName() {
            return this.authSubName;
        }

        public String getJCAName() {
            return this.jcaName;
        }
    }
}

