/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.Kind;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;

public class Category {
    public static final char SCHEME_PREFIX = '{';
    public static final char SCHEME_SUFFIX = '}';
    private static final Pattern categoryPattern = Pattern.compile("(\\{([^\\}]+)\\})?(.+)");
    protected String scheme;
    protected String term;
    protected String label;
    protected String labelLang;

    public Category() {
    }

    public Category(String string) {
        Matcher matcher = categoryPattern.matcher(string);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid category: " + string);
        }
        if (matcher.group(2) != null) {
            this.scheme = matcher.group(2);
        }
        this.term = matcher.group(3);
    }

    public Category(String string, String string2) {
        this(string, string2, null);
    }

    public Category(String string, String string2, String string3) {
        this.scheme = string;
        if (string2 == null) {
            throw new NullPointerException("Invalid term. Cannot be null");
        }
        this.term = string2;
        this.label = string3;
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String string) {
        this.scheme = string;
    }

    public String getTerm() {
        return this.term;
    }

    public void setTerm(String string) {
        this.term = string;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public String getLabelLang() {
        return this.labelLang;
    }

    public void setLabelLang(String string) {
        this.labelLang = string;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.scheme != null) {
            stringBuilder.append('{');
            stringBuilder.append(this.scheme);
            stringBuilder.append('}');
        }
        stringBuilder.append(this.term);
        if (this.label != null) {
            stringBuilder.append("(");
            stringBuilder.append(this.label);
            stringBuilder.append(")");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (!(object instanceof Category)) {
            return false;
        }
        return this.toString().equals(object.toString());
    }

    public int hashCode() {
        int n = 17;
        n = 37 * n + (this.scheme != null ? this.scheme.hashCode() : 0);
        n = 37 * n + this.term.hashCode();
        n = 37 * n + (this.label != null ? this.label.hashCode() : 0);
        return n;
    }

    public void generateAtom(XmlWriter xmlWriter) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(3);
        if (this.scheme != null) {
            arrayList.add(new XmlWriter.Attribute("scheme", this.scheme));
        }
        if (this.term != null) {
            arrayList.add(new XmlWriter.Attribute("term", this.term));
        }
        if (this.label != null) {
            arrayList.add(new XmlWriter.Attribute("label", this.label));
        }
        if (this.labelLang != null) {
            arrayList.add(new XmlWriter.Attribute("xml:lang", this.labelLang));
        }
        xmlWriter.simpleElement(Namespaces.atomNs, "category", arrayList, null);
    }

    public void generateRss(XmlWriter xmlWriter) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>(3);
        if (this.scheme != null) {
            arrayList.add(new XmlWriter.Attribute("domain", this.scheme));
        }
        if (this.labelLang != null) {
            arrayList.add(new XmlWriter.Attribute("xml:lang", this.labelLang));
        }
        String string = this.term;
        if (this.term == null) {
            string = this.label;
        }
        xmlWriter.simpleElement(Namespaces.rssNs, "category", arrayList, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class AtomHandler
    extends XmlParser.ElementHandler {
        Set<Category> categorySet;
        ExtensionProfile extProfile;
        Kind.Adaptable adaptable;

        public AtomHandler() {
        }

        public AtomHandler(ExtensionProfile extensionProfile, Set<Category> set, Kind.Adaptable adaptable) {
            this.extProfile = extensionProfile;
            this.categorySet = set;
            this.adaptable = adaptable;
        }

        @Override
        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("") && string2.equals("scheme")) {
                Category.this.scheme = string3;
            } else if (string.equals("") && string2.equals("term")) {
                Category.this.term = string3;
            } else if (string.equals("") && string2.equals("label")) {
                Category.this.label = string3;
            }
        }

        @Override
        public XmlParser.ElementHandler getChildHandler(String string, String string2, Attributes attributes) {
            return null;
        }

        @Override
        public void processEndElement() throws ParseException {
            if (Category.this.term == null) {
                throw new ParseException("Category must have a 'term' attribute.");
            }
            Category.this.labelLang = this.xmlLang;
            if (this.categorySet != null) {
                this.categorySet.add(Category.this);
            }
            if (this.adaptable != null & this.extProfile.isAutoExtending() && Kind.isKindCategory(Category.this)) {
                try {
                    Kind.Adaptor adaptor = Kind.getAdaptor(Category.this.term, this.adaptable);
                    if (adaptor != null) {
                        this.extProfile.addDeclarations(adaptor);
                    }
                }
                catch (Kind.AdaptorException adaptorException) {
                    throw new ParseException("Unable to load kind adaptor", adaptorException);
                }
            }
        }
    }
}

