/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionDescription
extends ExtensionPoint
implements Comparable<ExtensionDescription> {
    private XmlWriter.Namespace namespace;
    private String localName;
    private Class<? extends Extension> extensionClass;
    private boolean required = false;
    private boolean repeatable = false;
    private boolean aggregate = false;

    public static ExtensionDescription getDefaultDescription(Class<? extends Extension> clazz) {
        Default default_ = clazz.getAnnotation(Default.class);
        if (default_ == null) {
            throw new IllegalArgumentException("No default description found for " + clazz);
        }
        return new ExtensionDescription(clazz, new XmlWriter.Namespace(default_.nsAlias(), default_.nsUri()), default_.localName(), default_.isRequired(), default_.isRepeatable(), default_.isAggregate());
    }

    public ExtensionDescription() {
    }

    public ExtensionDescription(Class<? extends Extension> clazz, XmlWriter.Namespace namespace, String string, boolean bl, boolean bl2, boolean bl3) {
        this.namespace = namespace;
        this.localName = string;
        this.extensionClass = clazz;
        this.required = bl;
        this.repeatable = bl2;
        this.aggregate = bl3;
    }

    public ExtensionDescription(Class<? extends Extension> clazz, XmlWriter.Namespace namespace, String string) {
        this(clazz, namespace, string, false, false, false);
    }

    public void setNamespace(XmlWriter.Namespace namespace) {
        this.namespace = namespace;
    }

    public final XmlWriter.Namespace getNamespace() {
        return this.namespace;
    }

    public void setLocalName(String string) {
        this.localName = string;
    }

    public final String getLocalName() {
        return this.localName;
    }

    public void setExtensionClass(Class<? extends Extension> clazz) {
        this.extensionClass = clazz;
    }

    public final Class<? extends Extension> getExtensionClass() {
        return this.extensionClass;
    }

    public void setRequired(boolean bl) {
        this.required = bl;
    }

    public final boolean isRequired() {
        return this.required;
    }

    public void setRepeatable(boolean bl) {
        this.repeatable = bl;
    }

    public final boolean isRepeatable() {
        return this.repeatable;
    }

    public void setAggregate(boolean bl) {
        this.aggregate = bl;
    }

    public final boolean isAggregate() {
        return this.aggregate;
    }

    @Override
    public int compareTo(ExtensionDescription extensionDescription) {
        int n;
        String string;
        String string2 = this.namespace.getUri();
        if (string2 == null) {
            string2 = "";
        }
        if ((string = extensionDescription.namespace.getUri()) == null) {
            string = "";
        }
        if ((n = string2.compareTo(string)) != 0) {
            return n;
        }
        return this.localName.compareTo(extensionDescription.localName);
    }

    public void generateConfig(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        arrayList.add(new XmlWriter.Attribute("namespace", this.namespace.getUri()));
        arrayList.add(new XmlWriter.Attribute("localName", this.localName));
        arrayList.add(new XmlWriter.Attribute("extensionClass", this.extensionClass.getName()));
        arrayList.add(new XmlWriter.Attribute("required", this.required));
        arrayList.add(new XmlWriter.Attribute("repeatable", this.repeatable));
        arrayList.add(new XmlWriter.Attribute("aggregate", this.aggregate));
        this.generateStartElement(xmlWriter, Namespaces.gdataConfigNs, "extensionDescription", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.gdataConfigNs, "extensionDescription");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class Handler
    extends ExtensionPoint.ExtensionHandler {
        private ClassLoader configLoader;
        private Class extensionPointClass;
        private boolean arbitraryXml;

        public Handler(ExtensionProfile extensionProfile, ClassLoader classLoader, List<XmlWriter.Namespace> list, Attributes attributes) throws ParseException, IOException {
            super(ExtensionDescription.this, extensionProfile, ExtensionDescription.class);
            this.configLoader = classLoader;
            String string = attributes.getValue("", "namespace");
            if (string == null) {
                throw new ParseException("Missing namespace");
            }
            for (XmlWriter.Namespace object2 : list) {
                if (!object2.getAlias().equals(string) && !object2.getUri().equals(string)) continue;
                ExtensionDescription.this.namespace = object2;
                break;
            }
            if (ExtensionDescription.this.namespace == null) {
                throw new ParseException("No matching NamespaceDescription for " + string);
            }
            ExtensionDescription.this.localName = attributes.getValue("", "localName");
            if (ExtensionDescription.this.localName == null) {
                throw new ParseException("Missing localName");
            }
            String string2 = attributes.getValue("", "extensionClass");
            if (string2 == null) {
                throw new ParseException("Missing extensionClass attribute");
            }
            try {
                Class<?> classNotFoundException = classLoader.loadClass(string2);
                if (!Extension.class.isAssignableFrom(classNotFoundException)) {
                    throw new ParseException("Extension classes must implement the Extension interface");
                }
                ExtensionDescription.this.extensionClass = classNotFoundException;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ParseException("Unable to load extensionClass: " + (String)string2, classNotFoundException);
            }
            Boolean bl = this.getBooleanAttribute(attributes, "required");
            ExtensionDescription.this.required = bl != null && bl != false;
            Boolean bl2 = this.getBooleanAttribute(attributes, "repeatable");
            ExtensionDescription.this.repeatable = bl2 != null && bl2 != false;
            Boolean bl3 = this.getBooleanAttribute(attributes, "aggregate");
            ExtensionDescription.this.aggregate = bl3 != null && bl3 != false;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Default {
        public String nsAlias();

        public String nsUri();

        public String localName();

        public boolean isRequired() default false;

        public boolean isRepeatable() default false;

        public boolean isAggregate() default false;
    }
}

