/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.extensions;

import com.google.gdata.data.DateTime;
import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionPoint;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.util.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class GeoPt
extends ExtensionPoint
implements Extension {
    protected String label;
    protected Float lat;
    protected Float lon;
    protected Float elev;
    protected DateTime time;

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
    }

    public Float getLat() {
        return this.lat;
    }

    public void setLat(Float f) {
        this.lat = f;
    }

    public Float getLon() {
        return this.lon;
    }

    public void setLon(Float f) {
        this.lon = f;
    }

    public Float getElev() {
        return this.elev;
    }

    public void setElev(Float f) {
        this.elev = f;
    }

    public DateTime getTime() {
        return this.time;
    }

    public void setTime(DateTime dateTime) {
        this.time = dateTime;
    }

    public static ExtensionDescription getDefaultDescription(boolean bl) {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(GeoPt.class);
        extensionDescription.setNamespace(Namespaces.gNs);
        extensionDescription.setLocalName("geoPt");
        extensionDescription.setRepeatable(bl);
        return extensionDescription;
    }

    public static ExtensionDescription getDefaultDescription() {
        return GeoPt.getDefaultDescription(true);
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.label != null) {
            arrayList.add(new XmlWriter.Attribute("label", this.label));
        }
        if (this.lat != null) {
            arrayList.add(new XmlWriter.Attribute("lat", this.lat.toString()));
        }
        if (this.lon != null) {
            arrayList.add(new XmlWriter.Attribute("lon", this.lon.toString()));
        }
        if (this.elev != null) {
            arrayList.add(new XmlWriter.Attribute("elev", this.elev.toString()));
        }
        if (this.time != null) {
            arrayList.add(new XmlWriter.Attribute("time", this.time.toString()));
        }
        this.generateStartElement(xmlWriter, Namespaces.gNs, "geoPt", arrayList, null);
        this.generateExtensions(xmlWriter, extensionProfile);
        xmlWriter.endElement(Namespaces.gNs, "geoPt");
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler(extensionProfile);
    }

    private class Handler
    extends ExtensionPoint.ExtensionHandler {
        public Handler(ExtensionProfile extensionProfile) throws ParseException, IOException {
            super(extensionProfile, GeoPt.class);
        }

        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("")) {
                if (string2.equals("label")) {
                    GeoPt.this.label = string3;
                } else {
                    if (string2.equals("lat")) {
                        try {
                            GeoPt.this.lat = Float.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Invalid geoPt/@lat.", numberFormatException);
                        }
                    }
                    if (string2.equals("lon")) {
                        try {
                            GeoPt.this.lon = Float.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Invalid geoPt/@lon.", numberFormatException);
                        }
                    }
                    if (string2.equals("elev")) {
                        try {
                            GeoPt.this.elev = Float.valueOf(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Invalid geoPt/@elev.", numberFormatException);
                        }
                    }
                    if (string2.equals("time")) {
                        try {
                            GeoPt.this.time = DateTime.parseDateTime(string3);
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new ParseException("Date/time value expected.");
                        }
                    }
                }
            }
        }

        public void processEndElement() throws ParseException {
            if (GeoPt.this.lat == null) {
                throw new ParseException("g:geoPt/@lat is required.");
            }
            if (GeoPt.this.lon == null) {
                throw new ParseException("g:geoPt/@lon is required.");
            }
            super.processEndElement();
        }
    }
}

