/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.client.spreadsheet;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;

public class FeedURLFactory {
    public static final String DEFAULT_SPREADSHEETS_URL = "http://spreadsheets.google.com";
    private static final String SPREADSHEETS_PATH = "feeds/spreadsheets/private/full";
    private static final String WORKSHEETS_PATH = "feeds/worksheets/";
    private static final String LIST_PATH = "feeds/list/";
    private static final String CELLS_PATH = "feeds/cells/";
    private URL baseUrl;
    private URL feedSpreadsheets;
    private URL feedWorksheets;
    private URL feedList;
    private URL feedCells;
    private static final FeedURLFactory instance = new FeedURLFactory();

    public static FeedURLFactory getDefault() {
        return instance;
    }

    private FeedURLFactory() {
        try {
            this.init(DEFAULT_SPREADSHEETS_URL);
        }
        catch (MalformedURLException malformedURLException) {
            throw new RuntimeException("Unexpected malformed URL", malformedURLException);
        }
    }

    public FeedURLFactory(String string) throws MalformedURLException {
        this.init(string);
    }

    private void init(String string) throws MalformedURLException {
        this.baseUrl = new URL(string);
        this.feedSpreadsheets = new URL(this.baseUrl, SPREADSHEETS_PATH);
        this.feedWorksheets = new URL(this.baseUrl, WORKSHEETS_PATH);
        this.feedList = new URL(this.baseUrl, LIST_PATH);
        this.feedCells = new URL(this.baseUrl, CELLS_PATH);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    private String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new RuntimeException("UTF-8 is not supported by the JVM", unsupportedEncodingException);
        }
    }

    public URL getSpreadsheetsFeedUrl() {
        return this.feedSpreadsheets;
    }

    public URL getWorksheetFeedUrl(String string, String string2, String string3) throws MalformedURLException {
        if (string == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        return this.makeUrl(this.feedWorksheets, this.encode(string), string2, string3);
    }

    public URL getListFeedUrl(String string, String string2, String string3, String string4) throws MalformedURLException {
        return this.makeUrl(this.feedList, string, string2, string3, string4);
    }

    public URL getCellFeedUrl(String string, String string2, String string3, String string4) throws MalformedURLException {
        return this.makeUrl(this.feedCells, string, string2, string3, string4);
    }

    private URL makeUrl(URL uRL, String string, String string2, String string3, String string4) throws MalformedURLException {
        if (string == null) {
            throw new NullPointerException("spreadsheetKey is null");
        }
        if (string2 == null) {
            throw new NullPointerException("worksheetId is null");
        }
        String string5 = this.encode(string) + "/" + this.encode(string2);
        return this.makeUrl(uRL, string5, string3, string4);
    }

    private URL makeUrl(URL uRL, String string, String string2, String string3) throws MalformedURLException {
        if (string2 == null) {
            throw new NullPointerException("visibility is null");
        }
        if (string3 == null) {
            throw new NullPointerException("projection is null");
        }
        string = string + "/" + this.encode(string2) + "/" + this.encode(string3);
        return new URL(uRL, string);
    }

    public static String getSpreadsheetKeyFromUrl(String string) throws IllegalArgumentException {
        block6: {
            try {
                URL uRL = new URL(string);
                String string2 = uRL.getQuery();
                if (string2 != null) {
                    String[] stringArray = string2.split("&");
                    int n = -1;
                    int n2 = 0;
                    String string3 = "";
                    String[] stringArray2 = stringArray;
                    int n3 = stringArray2.length;
                    for (int i = 0; i < n3; ++i) {
                        String string4 = stringArray2[i];
                        if (string4.startsWith("id=")) {
                            n = "id=".length();
                            n2 = 4;
                            string3 = string4;
                            break;
                        }
                        if (!string4.startsWith("key=")) continue;
                        n = "key=".length();
                        n2 = 2;
                        string3 = string4;
                        break;
                    }
                    if (n > -1 && (stringArray2 = string3.substring(n).split("\\.")).length == n2) {
                        return stringArray2[0] + "." + stringArray2[1];
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                String[] stringArray = string.split("\\.");
                if (stringArray.length != 4 && stringArray.length != 2) break block6;
                return stringArray[0] + "." + stringArray[1];
            }
        }
        throw new IllegalArgumentException("Uknown URL format.");
    }
}

