/*
 * Decompiled with CFR 0.152.
 */
package com.google.gdata.data.spreadsheet;

import com.google.gdata.data.Extension;
import com.google.gdata.data.ExtensionDescription;
import com.google.gdata.data.ExtensionProfile;
import com.google.gdata.data.spreadsheet.Namespaces;
import com.google.gdata.util.ParseException;
import com.google.gdata.util.XmlParser;
import com.google.gdata.util.common.xml.XmlWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.xml.sax.Attributes;

public class Cell
implements Extension {
    private int row = -1;
    private int col = -1;
    private String inputValue = null;
    private Number numericValue = null;
    private String value = null;

    public Cell() {
    }

    private Cell(int n, int n2, String string, Number number, String string2) {
        this.row = n;
        this.col = n2;
        this.inputValue = string;
        this.value = string2;
        this.numericValue = number;
    }

    public Cell(int n, int n2, String string) {
        this(n, n2, string, null, null);
    }

    public static Cell createFullCell(int n, int n2, String string, Number number, String string2) {
        return new Cell(n, n2, string, number, string2);
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }

    public String getInputValue() {
        return this.inputValue;
    }

    public Number getNumericValue() {
        return this.numericValue;
    }

    public double getDoubleValue() {
        if (this.numericValue == null) {
            return Double.NaN;
        }
        return this.numericValue.doubleValue();
    }

    public String getValue() {
        return this.value;
    }

    public Cell withNewInputValue(String string) {
        return new Cell(this.row, this.col, string, null, null);
    }

    public static ExtensionDescription getDefaultDescription(boolean bl) {
        ExtensionDescription extensionDescription = new ExtensionDescription();
        extensionDescription.setExtensionClass(Cell.class);
        extensionDescription.setNamespace(Namespaces.gSpreadNs);
        extensionDescription.setLocalName("cell");
        extensionDescription.setRepeatable(bl);
        return extensionDescription;
    }

    public void generate(XmlWriter xmlWriter, ExtensionProfile extensionProfile) throws IOException {
        ArrayList<XmlWriter.Attribute> arrayList = new ArrayList<XmlWriter.Attribute>();
        if (this.row > 0) {
            arrayList.add(new XmlWriter.Attribute("row", String.valueOf(this.row)));
        }
        if (this.col > 0) {
            arrayList.add(new XmlWriter.Attribute("col", String.valueOf(this.col)));
        }
        if (this.inputValue != null) {
            arrayList.add(new XmlWriter.Attribute("inputValue", this.inputValue));
        }
        if (this.numericValue != null) {
            arrayList.add(new XmlWriter.Attribute("numericValue", this.numericValue.toString()));
        }
        xmlWriter.simpleElement(Namespaces.gSpreadNs, "cell", arrayList, this.value);
    }

    public XmlParser.ElementHandler getHandler(ExtensionProfile extensionProfile, String string, String string2, Attributes attributes) throws ParseException, IOException {
        return new Handler();
    }

    private class Handler
    extends XmlParser.ElementHandler {
        public void processAttribute(String string, String string2, String string3) throws ParseException {
            if (string.equals("")) {
                if (string2.equals("row")) {
                    Cell.this.row = Integer.parseInt(string3);
                } else if (string2.equals("col")) {
                    Cell.this.col = Integer.parseInt(string3);
                } else if (string2.equals("inputValue")) {
                    Cell.this.inputValue = string3;
                } else if (string2.equals("numericValue")) {
                    try {
                        Cell.this.numericValue = Double.valueOf(string3);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new ParseException("Invalid numericValue.");
                    }
                }
            }
        }

        public void processEndElement() throws ParseException {
            Cell.this.value = this.value;
            if (Cell.this.value != null && Cell.this.value.equals("")) {
                Cell.this.value = null;
            }
        }
    }
}

