/*
 * Decompiled with CFR 0.152.
 */
package org.xmldb.xupdate.lexus;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xmldb.xupdate.lexus.commands.CommandConstants;

public class XUpdateQueryParser
implements ContentHandler {
    private Vector commands = null;
    private Vector attributes = null;
    private Vector characters = null;
    private HashMap namespaces = null;
    private CommandConstants consts = null;
    private boolean xupdateInsertOperation = false;
    private String lastOperation = "";

    public XUpdateQueryParser(CommandConstants commandConstants) {
        this.consts = commandConstants;
        this.commands = new Vector();
        this.attributes = new Vector();
        this.characters = new Vector();
        this.namespaces = new HashMap();
    }

    public void startDocument() {
    }

    public void endDocument() {
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int n = 0;
        while (n < attributes.getLength()) {
            hashtable.put(attributes.getLocalName(n), attributes.getValue(n));
            ++n;
        }
        if (string.equals("http://www.xmldb.org/xupdate")) {
            int n2 = this.consts.idForString(string2);
            if (n2 != 0) {
                this.xupdateInsertOperation = this.consts.isInsertOperation(n2) ? true : this.xupdateInsertOperation;
                this.commands.addElement(new Integer(n2));
                if (this.consts.isInstruction(n2) && !this.xupdateInsertOperation) {
                    throw new SAXException("instruction <" + string3 + "> is not valid for operation <" + this.lastOperation + "> !");
                }
                if (!hashtable.isEmpty()) {
                    this.commands.addElement(new Integer(200));
                    this.attributes.addElement(hashtable);
                }
            }
        } else if (this.xupdateInsertOperation) {
            this.commands.addElement(new Integer(101));
            Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
            hashtable2.put("name", string3);
            hashtable2.put("namespace", string);
            this.commands.addElement(new Integer(200));
            this.attributes.addElement(hashtable2);
            int n3 = 0;
            while (n3 < attributes.getLength()) {
                this.commands.addElement(new Integer(102));
                hashtable2 = new Hashtable();
                hashtable2.put("name", attributes.getQName(n3));
                if (attributes.getURI(n3) != null) {
                    hashtable2.put("namespace", attributes.getURI(n3));
                }
                this.commands.addElement(new Integer(200));
                this.attributes.addElement(hashtable2);
                this.commands.addElement(new Integer(300));
                this.characters.addElement(attributes.getValue(n3));
                this.commands.addElement(new Integer(-102));
                ++n3;
            }
        } else {
            throw new SAXException("no insert-operation for element <" + string3 + "> or wrong XUpdate-Namespace !");
        }
        this.lastOperation = string3;
    }

    public void endElement(String string, String string2, String string3) {
        if (string.equals("http://www.xmldb.org/xupdate")) {
            int n = this.consts.idForString(string2);
            if (n != 0) {
                this.commands.addElement(new Integer(-n));
                this.xupdateInsertOperation = this.consts.isInsertOperation(n) ? false : this.xupdateInsertOperation;
            }
        } else if (this.xupdateInsertOperation) {
            this.commands.addElement(new Integer(-101));
        }
    }

    public void startPrefixMapping(String string, String string2) {
        if (string != null && string.length() > 0) {
            this.namespaces.put(string, string2);
        } else {
            this.namespaces.put(null, string2);
        }
    }

    public void endPrefixMapping(String string) {
    }

    public void characters(char[] cArray, int n, int n2) {
        if (!this.commands.isEmpty()) {
            int n3 = (Integer)this.commands.lastElement();
            if (this.xupdateInsertOperation && n3 < 0) {
                this.commands.addElement(new Integer(104));
            }
            this.commands.addElement(new Integer(300));
            this.characters.addElement(new String(cArray, n, n2));
            if (this.xupdateInsertOperation && n3 < 0) {
                this.commands.addElement(new Integer(-104));
            }
        }
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) {
    }

    public void processingInstruction(String string, String string2) {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void skippedEntity(String string) {
    }

    public Vector[] getCachedQuery() {
        return new Vector[]{this.commands, this.attributes, this.characters};
    }

    public HashMap getNamespaceMappings() {
        return this.namespaces;
    }
}

