/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.request;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xindice.core.Collection;
import org.apache.xindice.core.Container;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.Database;
import org.apache.xindice.util.ObjectPool;
import org.apache.xindice.util.Poolable;
import org.apache.xindice.util.XindiceException;
import org.apache.xindice.xml.TextWriter;
import org.w3c.dom.Document;

public final class URIMapper
extends URLConnection
implements Poolable {
    private static final Log log = LogFactory.getLog((Class)(class$org$apache$xindice$core$request$URIMapper == null ? (class$org$apache$xindice$core$request$URIMapper = URIMapper.class$("org.apache.xindice.core.request.URIMapper")) : class$org$apache$xindice$core$request$URIMapper));
    public static final int UNKNOWN = -1;
    public static final int APPLICATION = 1;
    public static final int COLLECTION = 2;
    public static final int DOCUMENT = 3;
    public static final String DEFAULT_ENCODING = "UTF-8";
    private ObjectPool pool;
    private String uri;
    private int type;
    private byte[] buf;
    private int pos;
    private char lastChar;
    private Database db;
    private Collection collection;
    private Document document;
    private String method;
    private Container container;
    private Properties params;
    private String[] args;
    private String urlresult;
    private boolean inputstreamset;
    static /* synthetic */ Class class$org$apache$xindice$core$request$URIMapper;

    public URIMapper(URL u) {
        block2: {
            super(u);
            this.pool = null;
            this.uri = null;
            this.type = 0;
            this.buf = null;
            this.pos = 0;
            this.lastChar = '\u0000';
            this.db = null;
            this.collection = null;
            this.document = null;
            this.method = null;
            this.container = null;
            this.params = null;
            this.args = null;
            this.urlresult = null;
            this.inputstreamset = false;
            try {
                this.setURI(u.toString());
            }
            catch (Exception e) {
                if (!log.isWarnEnabled()) break block2;
                log.warn((Object)"ignored exception", (Throwable)e);
            }
        }
    }

    public URIMapper(String uri) throws XindiceException {
        super(null);
        this.pool = null;
        this.uri = null;
        this.type = 0;
        this.buf = null;
        this.pos = 0;
        this.lastChar = '\u0000';
        this.db = null;
        this.collection = null;
        this.document = null;
        this.method = null;
        this.container = null;
        this.params = null;
        this.args = null;
        this.urlresult = null;
        this.inputstreamset = false;
        this.setURI(uri);
    }

    public URIMapper() {
        super(null);
        this.pool = null;
        this.uri = null;
        this.type = 0;
        this.buf = null;
        this.pos = 0;
        this.lastChar = '\u0000';
        this.db = null;
        this.collection = null;
        this.document = null;
        this.method = null;
        this.container = null;
        this.params = null;
        this.args = null;
        this.urlresult = null;
        this.inputstreamset = false;
    }

    public void connect() {
        this.connected = true;
    }

    public InputStream getInputStream() throws IOException {
        String output = null;
        if (!this.inputstreamset) {
            try {
                switch (this.type) {
                    case 3: {
                        output = TextWriter.toString(this.getDocument());
                        break;
                    }
                    default: {
                        throw new Exception("Content type unsupported");
                    }
                }
            }
            catch (Exception e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)"ignored exception", (Throwable)e);
                }
            }
        } else {
            output = this.urlresult;
        }
        this.urlresult = output;
        this.inputstreamset = true;
        if (output == null) {
            return new ByteArrayInputStream(new byte[0]);
        }
        return new ByteArrayInputStream(output.getBytes(DEFAULT_ENCODING));
    }

    public String getContentEncoding() {
        return DEFAULT_ENCODING;
    }

    public String getContentType() {
        return new String("text/xml");
    }

    public int getContentLength() {
        if (!this.inputstreamset) {
            try {
                this.getInputStream();
            }
            catch (IOException e) {
                return 0;
            }
        }
        return this.urlresult.length();
    }

    public long getLastModified() {
        return 0L;
    }

    public void setPool(ObjectPool pool) {
        this.pool = pool;
    }

    public void reclaim() {
        this.reset();
        if (this.pool != null) {
            this.pool.putObject(this);
        }
    }

    private void reset() {
        this.type = -1;
        this.lastChar = '\u0000';
        this.method = "";
        this.db = null;
        this.collection = null;
        this.document = null;
        this.params = null;
        this.args = null;
        this.container = null;
        this.urlresult = null;
        this.inputstreamset = false;
    }

    public void setURI(String uri) throws XindiceException {
        this.uri = uri;
        this.reset();
        this.parse();
    }

    private String parseName(String delims) {
        int start = this.pos;
        while (this.pos < this.buf.length) {
            this.lastChar = (char)this.buf[this.pos++];
            if (delims.indexOf(this.lastChar) == -1) continue;
        }
        if (this.pos == this.buf.length && delims.indexOf(this.lastChar) == -1) {
            ++this.pos;
        }
        return this.pos > start ? new String(this.buf, start, this.pos - start - 1) : "";
    }

    private void parseParams() {
        if (this.lastChar == '?') {
            String name;
            this.params = new Properties();
            while ((name = this.parseName("=")).length() != 0) {
                String value = this.parseName("?&;");
                String temp = this.params.getProperty(name);
                if (temp != null) {
                    StringBuffer sb = new StringBuffer(32);
                    sb.append(temp);
                    sb.append('\u0001');
                    sb.append(value);
                    value = sb.toString();
                }
                this.params.setProperty(name, value);
            }
        } else {
            this.params = new Properties();
        }
    }

    private void parse() throws XindiceException {
        String tmp;
        this.buf = this.uri.getBytes();
        this.pos = 0;
        if (this.buf.length == 0) {
            throw new DBException(800);
        }
        if ((char)this.buf[0] != '/') {
            this.parseName(":");
            this.parseName("/");
            this.parseName("/");
            this.parseName("/:");
            if (this.lastChar == ':') {
                this.parseName("/");
            }
        } else {
            this.pos = 1;
        }
        if ((tmp = this.parseName("/")) == null) {
            return;
        }
        this.db = Database.getDatabase(tmp);
        if (this.db == null) {
            return;
        }
        this.type = 1;
        tmp = this.parseName("/(?");
        int objType = this.getParsedObjectType(this.db, tmp);
        if (objType != -1) {
            this.type = this.walkURI(this.db, tmp, objType);
        }
        if (this.lastChar == '?') {
            this.parseParams();
            return;
        }
    }

    protected int walkURI(Collection col, String name, int objType) throws XindiceException {
        switch (objType) {
            case 3: {
                this.container = col.getContainer(name);
                this.document = this.container.getDocument();
                return 3;
            }
            case 2: {
                Collection c = col.getCollection(name);
                if (c == null) break;
                this.collection = c;
                String tmp = this.parseName("/(?");
                if (!tmp.equals("")) {
                    return this.walkURI(c, tmp, this.getParsedObjectType(c, tmp));
                }
                return 2;
            }
        }
        if (log.isWarnEnabled()) {
            log.warn((Object)("invalid object type : " + objType));
        }
        return -1;
    }

    protected int getParsedObjectType(Collection col, String name) throws XindiceException {
        if (col.getCollection(name) != null) {
            return 2;
        }
        if (col.getFiler() != null && col.getContainer(name) != null) {
            return 3;
        }
        return -1;
    }

    public int getObjectType() {
        return this.type;
    }

    public Database getDatabase() {
        return this.db;
    }

    public Collection getCollection() {
        return this.collection;
    }

    public Document getDocument() {
        return this.document;
    }

    public Container getContainer() {
        return this.container;
    }

    public String getMethod() {
        return this.method;
    }

    public Properties getProperties() {
        return this.params;
    }

    public String[] getArguments() {
        return this.args;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

