/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.labnote.preferences;

import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.preferences.PreferenceConstants;
import jp.sourceforge.concierge.plugin.labnote.styledtexteditor.FormatParameter;
import jp.sourceforge.concierge.util.FileLauncher;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class LabNotePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static String numberCharacters = "0123456789";
    private ArrayList<FormatParameter> mHeadFormatParameters = null;
    private FormatParameter mNormalFormatParameter = null;
    private int mIndent = 0;
    private String mULMark = "";
    private String mOLMark = "";
    private String selLocale = null;
    private String tooltipcontent = "";
    private String cssname = null;
    private Hashtable<String, String> c2l = new Hashtable();
    private Hashtable<String, String> l2c = new Hashtable();
    private static Hashtable<String, String> csstable = new Hashtable();
    private static String[] countryNames;
    private static String[] localeNames;
    ColorRegistry colorReg = null;

    static {
        int i = 0;
        while (i < 10) {
            csstable.put("Style" + i, String.valueOf(i) + ".css");
            ++i;
        }
        countryNames = new String[]{LabNotePlugin.getString("LabNotePreferencePage.1"), LabNotePlugin.getString("LabNotePreferencePage.2"), LabNotePlugin.getString("LabNotePreferencePage.3"), LabNotePlugin.getString("LabNotePreferencePage.4"), LabNotePlugin.getString("LabNotePreferencePage.5"), LabNotePlugin.getString("LabNotePreferencePage.6"), LabNotePlugin.getString("LabNotePreferencePage.7"), LabNotePlugin.getString("LabNotePreferencePage.8"), LabNotePlugin.getString("LabNotePreferencePage.9"), LabNotePlugin.getString("LabNotePreferencePage.10"), LabNotePlugin.getString("LabNotePreferencePage.11"), LabNotePlugin.getString("LabNotePreferencePage.12"), LabNotePlugin.getString("LabNotePreferencePage.13"), LabNotePlugin.getString("LabNotePreferencePage.14")};
        localeNames = new String[]{"japanese", "usa", "canadian", "brazilian", "uk", "german", "french", "spain", "italian", "russian", "china", "indian", "south_korea", "australian"};
    }

    public LabNotePreferencePage() {
        super(LabNotePlugin.getString("LabNotePreferencePage.29"));
        this.setPreferenceStore(LabNotePlugin.getDefault().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{LabNotePlugin.getString("LabNotePreferencePage.30")});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabNotePreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    private void createHTML(String cssname) {
        String htmlfile = LabNotePlugin.getDefault().getFilePath("lib/sample.html");
        String cssfile = LabNotePlugin.getDefault().getFilePath("lib/" + cssname);
        try {
            String htmlstr = FileUtils.readFileToString((File)new File(htmlfile), (String)"UTF-8");
            String cssstr = FileUtils.readFileToString((File)new File(cssfile), (String)"UTF-8");
            cssstr = cssstr.replaceFirst("%CATEGORYCOLOR%", "#E64D46");
            htmlstr = htmlstr.replaceFirst("%CSS%", cssstr);
            String tempdir = String.valueOf(FrameworkPlugin.getLocalDatabaseDirectory()) + System.getProperty("file.separator") + ".temp";
            File tempFolder = new File(tempdir);
            if (!tempFolder.exists()) {
                tempFolder.mkdir();
            }
            File tmphtml = new File(String.valueOf(tempdir) + System.getProperty("file.separator") + "preview.html");
            FileUtils.writeStringToFile((File)tmphtml, (String)htmlstr, (String)"UTF-8");
            FileLauncher.LaunchFile((File)tmphtml);
        }
        catch (Exception exception) {
            return;
        }
    }

    private void DoSave() {
        int i = 0;
        while (i < this.mHeadFormatParameters.size()) {
            FormatParameter fp = this.mHeadFormatParameters.get(i);
            this.getPreferenceStore().setValue("fontname" + i, fp.name);
            this.getPreferenceStore().setValue("fontsize" + i, fp.size);
            this.getPreferenceStore().setValue("fontstyle" + i, fp.style);
            this.getPreferenceStore().setValue("underline" + i, fp.underline);
            this.getPreferenceStore().setValue("forecolorred" + i, fp.forecolor_red);
            this.getPreferenceStore().setValue("forecolorgreen" + i, fp.forecolor_green);
            this.getPreferenceStore().setValue("forecolorblue" + i, fp.forecolor_blue);
            this.getPreferenceStore().setValue("backcolorred" + i, fp.backcolor_red);
            this.getPreferenceStore().setValue("backcolorgreen" + i, fp.backcolor_green);
            this.getPreferenceStore().setValue("backcolorblue" + i, fp.backcolor_blue);
            ++i;
        }
        FormatParameter fp = this.mNormalFormatParameter;
        this.getPreferenceStore().setValue("fontname", fp.name);
        this.getPreferenceStore().setValue("fontsize", fp.size);
        this.getPreferenceStore().setValue("fontstyle", fp.style);
        this.getPreferenceStore().setValue("underline", fp.underline);
        this.getPreferenceStore().setValue("forecolorred", fp.forecolor_red);
        this.getPreferenceStore().setValue("forecolorgreen", fp.forecolor_green);
        this.getPreferenceStore().setValue("forecolorblue", fp.forecolor_blue);
        this.getPreferenceStore().setValue("backcolorred", fp.backcolor_red);
        this.getPreferenceStore().setValue("backcolorgreen", fp.backcolor_green);
        this.getPreferenceStore().setValue("backcolorblue", fp.backcolor_blue);
        this.getPreferenceStore().setValue("indent", this.mIndent);
        this.getPreferenceStore().setValue("mark", this.mULMark);
        this.getPreferenceStore().setValue("olmark", this.mOLMark);
        boolean value = this.getPreferenceStore().getBoolean("updatepreferencestore");
        this.getPreferenceStore().setValue("updatepreferencestore", !value);
        this.getPreferenceStore().setValue("lablocale", this.selLocale);
        this.getPreferenceStore().setValue("css", this.cssname);
        this.getPreferenceStore().setValue("tooltipcontent", this.tooltipcontent);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        Group styleComposite = new Group(composite, 0);
        styleComposite.setLayout((Layout)new GridLayout(1, false));
        styleComposite.setLayoutData((Object)new GridData(768));
        this.createEditorSettingComposite((Composite)styleComposite);
        this.createCSSSettingComposite(composite);
        this.createLocaleSettingComposite(composite);
        this.createTooltipSettingComposite(composite);
        return composite;
    }

    private void createCSSSettingComposite(Composite parent) {
        Group cssComposite = new Group(parent, 0);
        cssComposite.setLayoutData((Object)new GridData(768));
        cssComposite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label((Composite)cssComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText("HTML Style");
        Combo cssCombo = new Combo((Composite)cssComposite, 8);
        cssCombo.setLayoutData((Object)new GridData(16384));
        this.cssname = this.getPreferenceStore().getString("css");
        int i = 1;
        while (i <= 4) {
            cssCombo.add("Style" + i);
            ++i;
        }
        if (this.cssname.length() > 0) {
            cssCombo.setText(this.cssname);
        } else {
            cssCombo.select(0);
        }
        cssCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                LabNotePreferencePage.this.cssname = combo.getText();
            }
        });
        Button cssbutton = new Button((Composite)cssComposite, 0);
        cssbutton.setText("Preview");
        cssbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LabNotePreferencePage.this.createHTML((String)csstable.get(LabNotePreferencePage.this.cssname));
            }
        });
    }

    private void createLocaleSettingComposite(Composite parent) {
        Group countryComposite = new Group(parent, 0);
        countryComposite.setLayoutData((Object)new GridData(768));
        countryComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)countryComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.31"));
        Combo countryCombo = new Combo((Composite)countryComposite, 8);
        countryCombo.setLayoutData((Object)new GridData(16384));
        int i = 0;
        while (i < countryNames.length) {
            countryCombo.add(countryNames[i]);
            this.c2l.put(countryNames[i], localeNames[i]);
            this.l2c.put(localeNames[i], countryNames[i]);
            ++i;
        }
        this.selLocale = this.getPreferenceStore().getString("lablocale");
        countryCombo.setText(this.l2c.get(this.selLocale));
        countryCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                LabNotePreferencePage.this.selLocale = (String)LabNotePreferencePage.this.c2l.get(combo.getText());
            }
        });
    }

    private void createEditorSettingComposite(Composite parent) {
        this.mHeadFormatParameters = new ArrayList();
        FontData[] fontdata = parent.getDisplay().getFontList(null, true);
        ArrayList<String> fontlist = new ArrayList<String>();
        int i = 0;
        while (i < fontdata.length) {
            if (!fontlist.contains(fontdata[i].getName())) {
                fontlist.add(fontdata[i].getName());
            }
            ++i;
        }
        i = 0;
        while (i < 1) {
            Group fontComposite = new Group(parent, 0);
            fontComposite.setLayoutData((Object)new GridData(768));
            fontComposite.setLayout((Layout)new GridLayout(6, false));
            Label label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.32"));
            label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.33"));
            label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.34"));
            label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.35"));
            label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.36"));
            label = new Label((Composite)fontComposite, 0);
            label.setLayoutData((Object)new GridData(64));
            label.setText(LabNotePlugin.getString("LabNotePreferencePage.37"));
            fontComposite.setText(String.valueOf(PreferenceConstants.EDITOR_HEAD_STRING) + ":");
            FormatParameter fp = new FormatParameter(this.getPreferenceStore().getString("fontname" + i), this.getPreferenceStore().getInt("fontsize" + i), this.getPreferenceStore().getInt("fontstyle" + i), this.getPreferenceStore().getBoolean("underline" + i));
            fp.forecolor_red = this.getPreferenceStore().getInt("forecolorred" + i);
            fp.forecolor_green = this.getPreferenceStore().getInt("forecolorgreen" + i);
            fp.forecolor_blue = this.getPreferenceStore().getInt("forecolorblue" + i);
            fp.backcolor_red = this.getPreferenceStore().getInt("backcolorred" + i);
            fp.backcolor_green = this.getPreferenceStore().getInt("backcolorgreen" + i);
            fp.backcolor_blue = this.getPreferenceStore().getInt("backcolorblue" + i);
            this.mHeadFormatParameters.add(fp);
            Combo fontCombo = new Combo((Composite)fontComposite, 8);
            int j = 0;
            while (j < fontlist.size()) {
                fontCombo.add((String)fontlist.get(j));
                ++j;
            }
            int index = fontlist.indexOf(fp.name);
            if (index == -1) {
                index = 0;
            }
            fontCombo.select(index);
            fontCombo.setData((Object)fp);
            fontCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Combo combo = (Combo)e.getSource();
                    FormatParameter obj = (FormatParameter)combo.getData();
                    obj.name = combo.getText();
                }
            });
            Text sizeText = new Text((Composite)fontComposite, 2048);
            sizeText.setLayoutData((Object)new GridData(768));
            sizeText.setText(String.valueOf(fp.size));
            sizeText.setData((Object)fp);
            sizeText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text text = (Text)e.getSource();
                    FormatParameter obj = (FormatParameter)text.getData();
                    obj.size = Integer.parseInt(text.getText());
                }
            });
            sizeText.addVerifyListener(new VerifyListener(){

                public void verifyText(VerifyEvent e) {
                    e.doit = true;
                    if (e.character == '\b' || e.character == '\u007f') {
                        return;
                    }
                    if (numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                        e.doit = false;
                    }
                }
            });
            Combo styleCombo = new Combo((Composite)fontComposite, 8);
            styleCombo.add("Normal");
            styleCombo.add("Bold");
            styleCombo.add("Italic");
            styleCombo.select(fp.style);
            styleCombo.setData((Object)fp);
            styleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Combo combo = (Combo)e.getSource();
                    FormatParameter obj = (FormatParameter)combo.getData();
                    obj.style = combo.getSelectionIndex();
                }
            });
            Button underlineButton = new Button((Composite)fontComposite, 32);
            underlineButton.setLayoutData((Object)new GridData(64));
            underlineButton.setSelection(fp.underline);
            underlineButton.setData((Object)fp);
            underlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    FormatParameter obj = (FormatParameter)button.getData();
                    obj.underline = button.getSelection();
                }
            });
            Button foreColorButton = new Button((Composite)fontComposite, 8);
            foreColorButton.setLayoutData((Object)new GridData(64));
            foreColorButton.setData((Object)fp);
            foreColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    FormatParameter obj = (FormatParameter)button.getData();
                    ColorDialog cd = new ColorDialog(button.getShell());
                    cd.setText(LabNotePlugin.getString("LabNotePreferencePage.44"));
                    cd.setRGB(new RGB(obj.forecolor_red, obj.forecolor_green, obj.forecolor_blue));
                    RGB newRGB = cd.open();
                    obj.forecolor_red = newRGB.red;
                    obj.forecolor_green = newRGB.green;
                    obj.forecolor_blue = newRGB.blue;
                }
            });
            foreColorButton.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Color whiteColor;
                    Color color;
                    GC gc = event.gc;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    Button button = (Button)event.widget;
                    if (LabNotePreferencePage.this.colorReg == null) {
                        LabNotePreferencePage.this.colorReg = new ColorRegistry();
                    }
                    if ((color = LabNotePreferencePage.this.colorReg.get((whiteColor = new Color(null, 255, 255, 255)).toString())) == null) {
                        LabNotePreferencePage.this.colorReg.put(whiteColor.toString(), whiteColor.getRGB());
                    } else {
                        whiteColor.dispose();
                        whiteColor = null;
                        whiteColor = color;
                    }
                    FormatParameter obj = (FormatParameter)button.getData();
                    Color foreColor = new Color(null, obj.forecolor_red, obj.forecolor_green, obj.forecolor_blue);
                    Color color2 = LabNotePreferencePage.this.colorReg.get(foreColor.toString());
                    if (color2 == null) {
                        LabNotePreferencePage.this.colorReg.put(foreColor.toString(), foreColor.getRGB());
                    } else {
                        foreColor.dispose();
                        foreColor = null;
                        foreColor = color2;
                    }
                    gc.setBackground(whiteColor);
                    gc.fillRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                    gc.setForeground(foreColor);
                    gc.drawRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                    gc.setBackground(foreColor);
                    gc.fillRectangle(event.x + 6, event.y + 6, event.width - 11, event.height - 11);
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                }
            });
            Button backColorButton = new Button((Composite)fontComposite, 8);
            backColorButton.setLayoutData((Object)new GridData(64));
            backColorButton.setData((Object)fp);
            backColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Button button = (Button)e.getSource();
                    FormatParameter obj = (FormatParameter)button.getData();
                    ColorDialog cd = new ColorDialog(button.getShell());
                    cd.setText(LabNotePlugin.getString("LabNotePreferencePage.45"));
                    cd.setRGB(new RGB(obj.backcolor_red, obj.backcolor_green, obj.backcolor_blue));
                    RGB newRGB = cd.open();
                    obj.backcolor_red = newRGB.red;
                    obj.backcolor_green = newRGB.green;
                    obj.backcolor_blue = newRGB.blue;
                }
            });
            backColorButton.addListener(9, new Listener(){

                public void handleEvent(Event event) {
                    Color whiteColor;
                    Color color;
                    GC gc = event.gc;
                    Color foreground = gc.getForeground();
                    Color background = gc.getBackground();
                    Button button = (Button)event.widget;
                    if (LabNotePreferencePage.this.colorReg == null) {
                        LabNotePreferencePage.this.colorReg = new ColorRegistry();
                    }
                    if ((color = LabNotePreferencePage.this.colorReg.get((whiteColor = new Color(null, 255, 255, 255)).toString())) == null) {
                        LabNotePreferencePage.this.colorReg.put(whiteColor.toString(), whiteColor.getRGB());
                    } else {
                        whiteColor.dispose();
                        whiteColor = null;
                        whiteColor = color;
                    }
                    FormatParameter obj = (FormatParameter)button.getData();
                    Color backColor = new Color(null, obj.backcolor_red, obj.backcolor_green, obj.backcolor_blue);
                    Color color2 = LabNotePreferencePage.this.colorReg.get(backColor.toString());
                    if (color2 == null) {
                        LabNotePreferencePage.this.colorReg.put(backColor.toString(), backColor.getRGB());
                    } else {
                        backColor.dispose();
                        backColor = null;
                        backColor = color2;
                    }
                    gc.setBackground(whiteColor);
                    gc.fillRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                    gc.setForeground(backColor);
                    gc.drawRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                    gc.setBackground(backColor);
                    gc.fillRectangle(event.x + 6, event.y + 6, event.width - 11, event.height - 11);
                    gc.setForeground(foreground);
                    gc.setBackground(background);
                }
            });
            ++i;
        }
        Group fontComposite = new Group(parent, 0);
        fontComposite.setLayoutData((Object)new GridData(768));
        fontComposite.setLayout((Layout)new GridLayout(6, false));
        Label label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.46"));
        label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.47"));
        label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.48"));
        label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.49"));
        label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.50"));
        label = new Label((Composite)fontComposite, 0);
        label.setLayoutData((Object)new GridData(64));
        label.setText(LabNotePlugin.getString("LabNotePreferencePage.51"));
        fontComposite.setText(LabNotePlugin.getString("LabNotePreferencePage.52"));
        FormatParameter fp = new FormatParameter(this.getPreferenceStore().getString("fontname"), this.getPreferenceStore().getInt("fontsize"), this.getPreferenceStore().getInt("fontstyle"), this.getPreferenceStore().getBoolean("underline"));
        fp.forecolor_red = this.getPreferenceStore().getInt("forecolorred");
        fp.forecolor_green = this.getPreferenceStore().getInt("forecolorgreen");
        fp.forecolor_blue = this.getPreferenceStore().getInt("forecolorblue");
        fp.backcolor_red = this.getPreferenceStore().getInt("backcolorred");
        fp.backcolor_green = this.getPreferenceStore().getInt("backcolorgreen");
        fp.backcolor_blue = this.getPreferenceStore().getInt("backcolorblue");
        this.mNormalFormatParameter = fp;
        Combo fontCombo = new Combo((Composite)fontComposite, 8);
        int j = 0;
        while (j < fontlist.size()) {
            fontCombo.add((String)fontlist.get(j));
            ++j;
        }
        int index = fontlist.indexOf(fp.name);
        if (index == -1) {
            index = 0;
        }
        fontCombo.select(index);
        fontCombo.setData((Object)fp);
        fontCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                FormatParameter obj = (FormatParameter)combo.getData();
                obj.name = combo.getText();
            }
        });
        Text sizeText = new Text((Composite)fontComposite, 2048);
        sizeText.setLayoutData((Object)new GridData(768));
        sizeText.setText(String.valueOf(fp.size));
        sizeText.setData((Object)fp);
        sizeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                FormatParameter obj = (FormatParameter)text.getData();
                obj.size = Integer.parseInt(text.getText());
            }
        });
        sizeText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                if (e.character == '\b' || e.character == '\u007f') {
                    return;
                }
                if (numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                    e.doit = false;
                }
            }
        });
        Combo styleCombo = new Combo((Composite)fontComposite, 8);
        styleCombo.setEnabled(false);
        styleCombo.add("Normal");
        styleCombo.add("Bold");
        styleCombo.add("Italic");
        styleCombo.select(fp.style);
        styleCombo.setData((Object)fp);
        styleCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                FormatParameter obj = (FormatParameter)combo.getData();
                obj.style = combo.getSelectionIndex();
            }
        });
        Button underlineButton = new Button((Composite)fontComposite, 32);
        underlineButton.setLayoutData((Object)new GridData(64));
        underlineButton.setEnabled(false);
        underlineButton.setSelection(fp.underline);
        underlineButton.setData((Object)fp);
        underlineButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                FormatParameter obj = (FormatParameter)button.getData();
                obj.underline = button.getSelection();
            }
        });
        Button foreColorButton = new Button((Composite)fontComposite, 8);
        foreColorButton.setLayoutData((Object)new GridData(64));
        foreColorButton.setData((Object)fp);
        foreColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                FormatParameter obj = (FormatParameter)button.getData();
                ColorDialog cd = new ColorDialog(button.getShell());
                cd.setText(LabNotePlugin.getString("LabNotePreferencePage.56"));
                cd.setRGB(new RGB(obj.forecolor_red, obj.forecolor_green, obj.forecolor_blue));
                RGB newRGB = cd.open();
                obj.forecolor_red = newRGB.red;
                obj.forecolor_green = newRGB.green;
                obj.forecolor_blue = newRGB.blue;
            }
        });
        foreColorButton.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Color whiteColor;
                Color color;
                GC gc = event.gc;
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                Button button = (Button)event.widget;
                if (LabNotePreferencePage.this.colorReg == null) {
                    LabNotePreferencePage.this.colorReg = new ColorRegistry();
                }
                if ((color = LabNotePreferencePage.this.colorReg.get((whiteColor = new Color(null, 255, 255, 255)).toString())) == null) {
                    LabNotePreferencePage.this.colorReg.put(whiteColor.toString(), whiteColor.getRGB());
                } else {
                    whiteColor.dispose();
                    whiteColor = null;
                    whiteColor = color;
                }
                FormatParameter obj = (FormatParameter)button.getData();
                Color foreColor = new Color(null, obj.forecolor_red, obj.forecolor_green, obj.forecolor_blue);
                Color color2 = LabNotePreferencePage.this.colorReg.get(foreColor.toString());
                if (color2 == null) {
                    LabNotePreferencePage.this.colorReg.put(foreColor.toString(), foreColor.getRGB());
                } else {
                    foreColor.dispose();
                    foreColor = null;
                    foreColor = color2;
                }
                gc.setBackground(whiteColor);
                gc.fillRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                gc.setForeground(foreColor);
                gc.drawRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                gc.setBackground(foreColor);
                gc.fillRectangle(event.x + 6, event.y + 6, event.width - 11, event.height - 11);
                gc.setForeground(foreground);
                gc.setBackground(background);
            }
        });
        Button backColorButton = new Button((Composite)fontComposite, 8);
        backColorButton.setLayoutData((Object)new GridData(64));
        backColorButton.setData((Object)fp);
        backColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                FormatParameter obj = (FormatParameter)button.getData();
                ColorDialog cd = new ColorDialog(button.getShell());
                cd.setText(LabNotePlugin.getString("LabNotePreferencePage.57"));
                cd.setRGB(new RGB(obj.backcolor_red, obj.backcolor_green, obj.backcolor_blue));
                RGB newRGB = cd.open();
                obj.backcolor_red = newRGB.red;
                obj.backcolor_green = newRGB.green;
                obj.backcolor_blue = newRGB.blue;
            }
        });
        backColorButton.addListener(9, new Listener(){

            public void handleEvent(Event event) {
                Color whiteColor;
                Color color;
                GC gc = event.gc;
                Color foreground = gc.getForeground();
                Color background = gc.getBackground();
                Button button = (Button)event.widget;
                if (LabNotePreferencePage.this.colorReg == null) {
                    LabNotePreferencePage.this.colorReg = new ColorRegistry();
                }
                if ((color = LabNotePreferencePage.this.colorReg.get((whiteColor = new Color(null, 255, 255, 255)).toString())) == null) {
                    LabNotePreferencePage.this.colorReg.put(whiteColor.toString(), whiteColor.getRGB());
                } else {
                    whiteColor.dispose();
                    whiteColor = null;
                    whiteColor = color;
                }
                FormatParameter obj = (FormatParameter)button.getData();
                Color backColor = new Color(null, obj.backcolor_red, obj.backcolor_green, obj.backcolor_blue);
                Color color2 = LabNotePreferencePage.this.colorReg.get(backColor.toString());
                if (color2 == null) {
                    LabNotePreferencePage.this.colorReg.put(backColor.toString(), backColor.getRGB());
                } else {
                    backColor.dispose();
                    backColor = null;
                    backColor = color2;
                }
                gc.setBackground(whiteColor);
                gc.fillRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                gc.setForeground(backColor);
                gc.drawRectangle(event.x + 4, event.y + 4, event.width - 8, event.height - 8);
                gc.setBackground(backColor);
                gc.fillRectangle(event.x + 6, event.y + 6, event.width - 11, event.height - 11);
                gc.setForeground(foreground);
                gc.setBackground(background);
            }
        });
        Composite indentComposite = new Composite(parent, 0);
        indentComposite.setLayoutData((Object)new GridData(768));
        indentComposite.setLayout((Layout)new GridLayout(4, false));
        label = new Label(indentComposite, 0);
        label.setText("indent width:");
        Text indentText = new Text(indentComposite, 2048);
        String value = this.getPreferenceStore().getString("indent");
        this.mIndent = Integer.parseInt(value);
        indentText.setText(value);
        indentText.setLayoutData((Object)new GridData(30, -1));
        indentText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.getSource();
                LabNotePreferencePage.this.mIndent = Integer.parseInt(text.getText());
            }
        });
        indentText.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                e.doit = true;
                if (e.character == '\b' || e.character == '\u007f') {
                    return;
                }
                if (numberCharacters.indexOf(Character.toString(e.character)) == -1) {
                    e.doit = false;
                }
            }
        });
        label = new Label(indentComposite, 0);
        label.setText("Unordered list mark:");
        Combo markText = new Combo(indentComposite, 2056);
        markText.add(LabNotePlugin.getString("LabNotePreferencePage.80"));
        markText.add(LabNotePlugin.getString("LabNotePreferencePage.81"));
        markText.add(LabNotePlugin.getString("LabNotePreferencePage.82"));
        this.mULMark = this.getPreferenceStore().getString("mark");
        markText.setText(this.mULMark);
        markText.setLayoutData((Object)new GridData(100, -1));
        markText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Combo cmb = (Combo)e.getSource();
                LabNotePreferencePage.this.mULMark = cmb.getText();
            }
        });
    }

    private void createTooltipSettingComposite(Composite parent) {
        Group tooltipComposite = new Group(parent, 0);
        tooltipComposite.setLayoutData((Object)new GridData(768));
        tooltipComposite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)tooltipComposite, 0);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        label.setText("Show content on tooltip:");
        Combo tooltipCombo = new Combo((Composite)tooltipComposite, 8);
        tooltipCombo.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        tooltipCombo.add("Yes");
        tooltipCombo.add("No");
        this.tooltipcontent = this.getPreferenceStore().getString("tooltipcontent");
        tooltipCombo.setText(this.tooltipcontent);
        tooltipCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Combo combo = (Combo)e.getSource();
                LabNotePreferencePage.this.tooltipcontent = combo.getText();
            }
        });
    }

    public static String getCSSName() {
        String stylename = LabNotePlugin.getDefault().getPreferenceStore().getString("css");
        return csstable.get(stylename);
    }

    public static boolean isTooltipContentVisible() {
        String tp = LabNotePlugin.getDefault().getPreferenceStore().getString("tooltipcontent");
        return tp.equals("Yes");
    }
}

