/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.search.SearchQueryMaker;
import jp.sourceforge.concierge.plugin.ipapers.search.pubmed.PubMedCore;
import jp.sourceforge.concierge.plugin.ipapers.search.smart.SmartSearch;

public class PubMedQuery
extends SearchQueryMaker {
    private String publicationType = "";

    public PubMedQuery() {
        super(PubMedCore.IDTYPE);
    }

    @Override
    public void makeQuery(String query) {
        this.query = String.valueOf(query) + this.publicationType;
    }

    @Override
    public void makeQuery(String text, String sYear, String sMonth, String sDay, String eYear, String eMonth, String eDay) {
        StringBuffer query = new StringBuffer();
        query.append(text);
        query.append(" ");
        query.append(String.valueOf(sYear) + "/" + sMonth + "/" + sDay);
        query.append(":");
        query.append(String.valueOf(eYear) + "/" + eMonth + "/" + eDay);
        query.append("[DP]");
        this.query = String.valueOf(query.toString()) + this.publicationType;
    }

    @Override
    public void makeQuery(String journal, String volume, String firstpage) {
        StringBuffer query = new StringBuffer();
        query.append(journal);
        query.append("[TA] ");
        query.append(volume);
        query.append("[VI] ");
        query.append(firstpage);
        query.append("[PG]");
        this.query = query.toString();
    }

    @Override
    public void setPublicationType(String ptype) {
        this.publicationType = ptype;
    }

    @Override
    public void makeQuery(SmartSearch query) {
        StringBuffer s = new StringBuffer();
        Date now = new Date();
        Date time = new Date(query.getSearchTime().getTime());
        SimpleDateFormat df = new SimpleDateFormat("yyyy/MM/dd");
        ArrayList<SmartSearch.SmartQueryItem> queries = query.getQuery();
        int i = 0;
        while (i < queries.size()) {
            SmartSearch.SmartQueryItem item = queries.get(i);
            if (!(item.target == null || item.keyword == null || item.parameter == null || item.target.equalsIgnoreCase("null") || item.keyword.equalsIgnoreCase("null") || item.parameter.equalsIgnoreCase("null") || item.target.equals("") || item.keyword.equals("") || item.parameter.equals(""))) {
                s.append("(");
                if (item.keyword.equals("Author")) {
                    if (item.parameter.equals("Exclude")) {
                        s.append("NOT ");
                    }
                    s.append(item.keyword);
                    s.append("[au]");
                } else if (item.target.equals("Title")) {
                    if (item.parameter.equals("Exclude")) {
                        s.append("NOT ");
                    }
                    s.append(item.keyword);
                    s.append("[ti]");
                } else if (item.target.equals("Journal")) {
                    if (item.parameter.equals("Exclude")) {
                        s.append("NOT ");
                    }
                    s.append(item.keyword);
                    s.append("[ta]");
                } else if (item.target.equals("Keyword")) {
                    if (item.parameter.equals("Exclude")) {
                        s.append("NOT ");
                    }
                    s.append(item.keyword);
                    s.append("[tw]");
                } else if (item.target.equals("Year")) {
                    if (item.parameter.equals("Larger than")) {
                        s.append("1700:" + item.keyword);
                    } else if (item.parameter.equals("Smaller than")) {
                        s.append(item.keyword);
                    } else {
                        s.append(String.valueOf(item.keyword) + ":" + df.format(now));
                    }
                    s.append("[dp]");
                } else if (item.target.equals("Publication Type")) {
                    if (item.parameter.equals("Exclude")) {
                        s.append("NOT ");
                    }
                    s.append(item.keyword);
                    s.append("[pt]");
                }
                s.append(")");
                s.append(" ");
            }
            ++i;
        }
        s.append(" AND ");
        s.append(df.format(time));
        s.append(":");
        s.append(df.format(now));
        s.append("[edat]");
        if (IPapersPlugin.log.isDebugEnabled()) {
            IPapersPlugin.log.debug((Object)s.toString());
        }
        this.query = s.toString();
    }
}

