/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.InstallWizard2;
import org.eclipse.update.internal.ui.wizards.ResizableInstallWizardDialog;
import org.eclipse.update.ui.UpdateJob;

public class InstallWizardOperation {
    private UpdateJob job;
    private IJobChangeListener jobListener;
    private Shell shell;
    private Shell parentShell;

    public void run(Shell parent, UpdateJob task) {
        this.shell = parent;
        if (this.shell.getParent() != null && this.shell.getParent() instanceof Shell) {
            this.parentShell = (Shell)this.shell.getParent();
        }
        if (this.jobListener != null) {
            Job.getJobManager().removeJobChangeListener(this.jobListener);
        }
        if (this.job != null) {
            Job.getJobManager().cancel((Object)this.job);
        }
        this.job = task;
        this.jobListener = new UpdateJobChangeListener();
        Job.getJobManager().addJobChangeListener(this.jobListener);
        this.job.schedule();
    }

    private Shell getValidShell() {
        if (this.shell.isDisposed()) {
            return this.parentShell;
        }
        return this.shell;
    }

    private class UpdateJobChangeListener
    extends JobChangeAdapter {
        private UpdateJobChangeListener() {
        }

        public void done(IJobChangeEvent event) {
            final Shell validShell = InstallWizardOperation.this.getValidShell();
            if (event.getJob() == InstallWizardOperation.this.job) {
                Job.getJobManager().removeJobChangeListener((IJobChangeListener)this);
                Job.getJobManager().cancel((Object)InstallWizardOperation.this.job);
                if (InstallWizardOperation.this.job.getStatus() == Status.CANCEL_STATUS) {
                    return;
                }
                if (InstallWizardOperation.this.job.getStatus() != Status.OK_STATUS) {
                    InstallWizardOperation.this.getValidShell().getDisplay().syncExec(new Runnable(){

                        @Override
                        public void run() {
                            UpdateUI.log(InstallWizardOperation.this.job.getStatus(), true);
                        }
                    });
                }
                validShell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        validShell.getDisplay().beep();
                        BusyIndicator.showWhile((Display)validShell.getDisplay(), (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UpdateJobChangeListener.this.openInstallWizard2();
                            }
                        });
                    }
                });
            }
        }

        private void openInstallWizard2() {
            if (InstallWizard2.isRunning()) {
                MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_isRunningTitle, (String)UpdateUIMessages.InstallWizard_isRunningInfo);
                return;
            }
            if (InstallWizardOperation.this.job.getUpdates() == null || InstallWizardOperation.this.job.getUpdates().length == 0) {
                if (InstallWizardOperation.this.job.isUpdate()) {
                    MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroUpdates);
                } else {
                    MessageDialog.openInformation((Shell)InstallWizardOperation.this.getValidShell(), (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures, (String)UpdateUIMessages.InstallWizard_ReviewPage_zeroFeatures);
                }
                return;
            }
            InstallWizard2 wizard = new InstallWizard2(InstallWizardOperation.this.job.getSearchRequest(), InstallWizardOperation.this.job.getUpdates(), InstallWizardOperation.this.job.isUpdate());
            ResizableInstallWizardDialog dialog = new ResizableInstallWizardDialog(InstallWizardOperation.this.getValidShell(), (IWizard)wizard, UpdateUIMessages.AutomaticUpdatesJob_Updates);
            dialog.create();
            dialog.open();
        }
    }
}

