/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.update.core.ArchiveReference;
import org.eclipse.update.core.Category;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFactory;
import org.eclipse.update.core.Site;
import org.eclipse.update.core.SiteFeatureReference;
import org.eclipse.update.core.SiteFeatureReferenceModel;
import org.eclipse.update.core.URLEntry;
import org.eclipse.update.core.model.ArchiveReferenceModel;
import org.eclipse.update.core.model.CategoryModel;
import org.eclipse.update.core.model.InvalidSiteTypeException;
import org.eclipse.update.core.model.SiteModel;
import org.eclipse.update.core.model.SiteModelFactory;
import org.eclipse.update.core.model.URLEntryModel;
import org.eclipse.update.internal.core.Messages;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.internal.core.UpdateManagerUtils;
import org.eclipse.update.internal.core.connection.ConnectionFactory;
import org.eclipse.update.internal.core.connection.IResponse;

public abstract class BaseSiteFactory
extends SiteModelFactory
implements ISiteFactory {
    @Override
    public abstract ISite createSite(URL var1) throws CoreException, InvalidSiteTypeException;

    protected ResourceBundle getResourceBundle(URL url) {
        ResourceBundle bundle = null;
        try {
            url = UpdateManagerUtils.asDirectoryURL(url);
            URLClassLoader l = new URLClassLoader(new URL[]{url}, null);
            bundle = ResourceBundle.getBundle("site", Locale.getDefault(), l);
        }
        catch (MissingResourceException e) {
            UpdateCore.warn(String.valueOf(e.getLocalizedMessage()) + ":" + url.toExternalForm());
        }
        catch (MalformedURLException malformedURLException) {
            UpdateCore.warn(NLS.bind((String)Messages.BaseSiteFactory_CannotRetriveParentDirectory, (Object[])new String[]{url.toExternalForm()}));
        }
        return bundle;
    }

    @Override
    public SiteModel createSiteMapModel() {
        return new Site();
    }

    @Override
    public SiteFeatureReferenceModel createFeatureReferenceModel() {
        return new SiteFeatureReference();
    }

    @Override
    public ArchiveReferenceModel createArchiveReferenceModel() {
        return new ArchiveReference();
    }

    @Override
    public URLEntryModel createURLEntryModel() {
        return new URLEntry();
    }

    @Override
    public CategoryModel createSiteCategoryModel() {
        return new Category();
    }

    protected InputStream openStream(URL resolvedURL) throws IOException {
        IResponse response = ConnectionFactory.get(resolvedURL);
        return response.getInputStream();
    }
}

