/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.ipapers.search.pubmed;

import gov.nih.nlm.ncbi.www.soap.eutils.EFetchPubmedServiceStub;
import gov.nih.nlm.ncbi.www.soap.eutils.EUtilsServiceStub;
import java.net.URLEncoder;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.sourceforge.concierge.plugin.IPapersPlugin;
import jp.sourceforge.concierge.plugin.ipapers.CannotGetPaperInfoException;
import jp.sourceforge.concierge.plugin.ipapers.ConciergeAdapter;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfo;
import jp.sourceforge.concierge.plugin.ipapers.PaperInfoGetter;
import jp.sourceforge.concierge.plugin.ipapers.search.ArticleInfo;
import jp.sourceforge.concierge.plugin.ipapers.search.NoSearchResultsFoundException;
import org.eclipse.jface.preference.IPreferenceStore;

public class PubMedCore
extends PaperInfoGetter {
    private EUtilsServiceStub.ESearchResult searchResult = null;
    public static String IDTYPE = "pubmed";

    public PubMedCore() {
        super(IDTYPE);
    }

    public ArrayList<String> search(String query) throws NoSearchResultsFoundException, RemoteException, Exception {
        try {
            IPreferenceStore store = IPapersPlugin.getDefault().getPreferenceStore();
            StringBuffer searchquery = new StringBuffer(query);
            searchquery.append(" AND (");
            if (store.getBoolean("English")) {
                searchquery.append(" OR English[language]");
            }
            if (store.getBoolean("French")) {
                searchquery.append(" OR French[language]");
            }
            if (store.getBoolean("German")) {
                searchquery.append(" OR German[language]");
            }
            if (store.getBoolean("Italian")) {
                searchquery.append(" OR Italian[language]");
            }
            if (store.getBoolean("Japanese")) {
                searchquery.append(" OR Japanese[language]");
            }
            if (store.getBoolean("Russian")) {
                searchquery.append(" OR Russian[language]");
            }
            if (store.getBoolean("Spanish")) {
                searchquery.append(" OR Spanish[language]");
            }
            searchquery.append(")");
            Pattern pattern = Pattern.compile(" AND [(] OR");
            Matcher matcher = pattern.matcher(searchquery.toString());
            query = matcher.replaceFirst(" AND (");
            if (IPapersPlugin.log.isDebugEnabled()) {
                IPapersPlugin.log.debug((Object)query);
            }
            EUtilsServiceStub service = new EUtilsServiceStub();
            EUtilsServiceStub.ESearchRequest req = new EUtilsServiceStub.ESearchRequest();
            req.setDb("pubmed");
            req.setTerm(URLEncoder.encode(query, "UTF-8"));
            req.setRetMax(store.getString("maximul retrieved"));
            this.searchResult = service.run_eSearch(req);
            if (this.searchResult.getIdList() != null) {
                ArrayList<String> result = new ArrayList<String>();
                int i = 0;
                while (i < this.searchResult.getIdList().getId().length) {
                    result.add(this.searchResult.getIdList().getId()[i]);
                    ++i;
                }
                return result;
            }
            throw new NoSearchResultsFoundException("IDTYPE");
        }
        catch (RemoteException e) {
            if (IPapersPlugin.log.isInfoEnabled()) {
                IPapersPlugin.log.error((Object)e.getMessage());
            }
            throw e;
        }
        catch (Exception e) {
            if (IPapersPlugin.log.isInfoEnabled()) {
                IPapersPlugin.log.error((Object)e.getMessage());
            }
            throw e;
        }
    }

    public void cancel() {
        this.searchResult = null;
    }

    @Override
    public PaperInfo fetchInfo(String id) throws CannotGetPaperInfoException {
        if (IPapersPlugin.log.isInfoEnabled()) {
            IPapersPlugin.log.debug((Object)"fetch from PubMed");
        }
        try {
            EFetchPubmedServiceStub service = new EFetchPubmedServiceStub();
            EFetchPubmedServiceStub.EFetchRequest req = new EFetchPubmedServiceStub.EFetchRequest();
            req.setId(id);
            System.out.println("EFetchPubmedServiceStub PMID: " + id);
            EFetchPubmedServiceStub.EFetchResult res = service.run_eFetch(req);
            ArticleInfo info = new ArticleInfo();
            EFetchPubmedServiceStub.MedlineCitationType medlineCitationType = res.getPubmedArticleSet().getPubmedArticle()[0].getMedlineCitation();
            if (medlineCitationType.getArticle().getAuthorList() != null) {
                info.setAuthor(this.getAuthorString(medlineCitationType.getArticle().getAuthorList().getAuthor()));
            }
            if (medlineCitationType.getArticle().getArticleTitle() != null) {
                info.setTitle(medlineCitationType.getArticle().getArticleTitle());
            }
            if (medlineCitationType.getMedlineJournalInfo().getMedlineTA() != null) {
                info.setJournal(medlineCitationType.getMedlineJournalInfo().getMedlineTA());
            }
            if (medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getVolume() != null) {
                info.setVolume(medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getVolume());
            }
            if (medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getPubDate().getPubDateTypeSequence_type1() != null) {
                info.setYear(medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getPubDate().getPubDateTypeSequence_type1().getYear());
            }
            if (medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getIssue() != null) {
                info.setIssue(medlineCitationType.getArticle().getArticleTypeChoice_type0().getJournal().getJournalIssue().getIssue());
            }
            if (medlineCitationType.getArticle().getArticleTypeChoice_type1().getArticleTypeSequence_type0().getPagination().getMedlinePgn() != null) {
                info.setPages(medlineCitationType.getArticle().getArticleTypeChoice_type1().getArticleTypeSequence_type0().getPagination().getMedlinePgn());
            }
            EFetchPubmedServiceStub.ArticleIdType[] articleIdTypes = res.getPubmedArticleSet().getPubmedArticle()[0].getPubmedData().getArticleIdList().getArticleId();
            int i = 0;
            while (i < articleIdTypes.length) {
                info.putID(articleIdTypes[i].getIdType().getValue().toString(), articleIdTypes[i].getString());
                ++i;
            }
            if (ConciergeAdapter.hasPapers(id, IDTYPE).booleanValue()) {
                info.setFlag(2);
            } else {
                info.setFlag(0);
            }
            if (medlineCitationType.getArticle().getAbstract() != null && medlineCitationType.getArticle().getAbstract().getAbstractText() != null) {
                info.setAbstract(medlineCitationType.getArticle().getAbstract().getAbstractText());
            }
            return info;
        }
        catch (RemoteException remoteException) {
            throw new CannotGetPaperInfoException(id, IDTYPE);
        }
    }

    public String getAuthorString(EFetchPubmedServiceStub.AuthorType[] authorTypes) {
        StringBuffer authorString = new StringBuffer();
        int i = 0;
        while (i < authorTypes.length) {
            EFetchPubmedServiceStub.AuthorTypeSequence_type1 author;
            if (authorTypes[i] != null && authorTypes[i].getAuthorTypeChoice_type2() != null && authorTypes[i].getAuthorTypeChoice_type2().getAuthorTypeChoice_type1() != null && (author = authorTypes[i].getAuthorTypeChoice_type2().getAuthorTypeChoice_type1().getAuthorTypeSequence_type1()) != null) {
                if (authorString.length() > 0) {
                    authorString.append(", ");
                }
                authorString.append(String.valueOf(author.getLastName()) + " " + author.getInitials());
            }
            ++i;
        }
        return authorString.toString();
    }

    public String titleOfTitleAbbreviation(String TA) {
        String title;
        block7: {
            title = null;
            try {
                EUtilsServiceStub service = new EUtilsServiceStub();
                EUtilsServiceStub.ESearchRequest searchReq = new EUtilsServiceStub.ESearchRequest();
                searchReq.setDb("Journals");
                searchReq.setTerm(URLEncoder.encode(String.valueOf(TA) + "[TA]", "UTF-8"));
                EUtilsServiceStub.ESearchResult searchRes = service.run_eSearch(searchReq);
                if (searchRes.getIdList() != null && searchRes.getIdList().getId().length > 0) {
                    EUtilsServiceStub.ESummaryRequest summaryReq = new EUtilsServiceStub.ESummaryRequest();
                    summaryReq.setDb("Journals");
                    summaryReq.setId(searchRes.getIdList().getId()[0]);
                    EUtilsServiceStub.ESummaryResult summaryRes = service.run_eSummary(summaryReq);
                    if (summaryRes.getDocSum() != null && summaryRes.getDocSum().length > 0) {
                        title = summaryRes.getDocSum()[0].getItem()[0].getItemContent();
                        if (IPapersPlugin.log.isDebugEnabled()) {
                            IPapersPlugin.log.debug((Object)title);
                        }
                        Pattern pattern = Pattern.compile("([\\w ]+)");
                        Matcher m = pattern.matcher(title);
                        m.find();
                        title = m.group(0);
                    } else {
                        title = TA;
                    }
                } else {
                    title = TA;
                }
            }
            catch (Exception e) {
                if (!IPapersPlugin.log.isInfoEnabled()) break block7;
                IPapersPlugin.log.error((Object)e.getMessage());
            }
        }
        return title;
    }
}

