/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.indexing;

import org.eclipse.core.internal.indexing.Field;
import org.eclipse.core.internal.indexing.IndexedStoreObject;
import org.eclipse.core.internal.indexing.ObjectAddress;
import org.eclipse.core.internal.indexing.ObjectStore;
import org.eclipse.core.internal.indexing.ObjectStoreException;

class IndexedStoreContext
extends IndexedStoreObject {
    public static final int SIZE = 32;
    public static final int TYPE = 2;
    private static final int OpenNumberOffset = 2;
    private static final int OpenNumberLength = 4;
    private Field openNumberField;
    private int openNumber;
    private static final int ObjectDirectoryAddressOffset = 6;
    private static final int ObjectDirectoryAddressLength = 4;
    private Field objectDirectoryAddressField;
    private ObjectAddress objectDirectoryAddress;
    private static final int IndexDirectoryAddressOffset = 10;
    private static final int IndexDirectoryAddressLength = 4;
    private Field indexDirectoryAddressField;
    private ObjectAddress indexDirectoryAddress;
    private static final int ObjectNumberOffset = 14;
    private static final int ObjectNumberLength = 8;
    private Field objectNumberField;
    private long objectNumber;

    IndexedStoreContext() {
        this.indexDirectoryAddress = ObjectAddress.Null;
        this.objectDirectoryAddress = ObjectAddress.Null;
        this.openNumber = 0;
        this.objectNumber = 0L;
    }

    IndexedStoreContext(Field f, ObjectStore store, ObjectAddress address) throws ObjectStoreException {
        super(f, store, address);
    }

    protected void setFields(Field contents) {
        this.openNumberField = contents.subfield(2, 4);
        this.objectDirectoryAddressField = contents.subfield(6, 4);
        this.indexDirectoryAddressField = contents.subfield(10, 4);
        this.objectNumberField = contents.subfield(14, 8);
    }

    @Override
    protected void extractValues(Field contents) throws ObjectStoreException {
        super.extractValues(contents);
        this.setFields(contents);
        this.openNumber = this.openNumberField.getInt();
        this.objectDirectoryAddress = new ObjectAddress(this.objectDirectoryAddressField.get());
        this.indexDirectoryAddress = new ObjectAddress(this.indexDirectoryAddressField.get());
        this.objectNumber = this.objectNumberField.getLong();
        if (this.openNumber > 0) {
            this.objectNumber = (long)this.openNumber << 32;
            this.openNumber = 0;
            this.setChanged();
        }
    }

    @Override
    protected void insertValues(Field contents) {
        super.insertValues(contents);
        this.setFields(contents);
        this.openNumberField.put(this.openNumber);
        this.objectDirectoryAddressField.put(this.objectDirectoryAddress);
        this.indexDirectoryAddressField.put(this.indexDirectoryAddress);
        this.objectNumberField.put(this.objectNumber);
    }

    ObjectAddress getIndexDirectoryAddress() {
        return this.indexDirectoryAddress;
    }

    @Override
    protected int getMinimumSize() {
        return 32;
    }

    ObjectAddress getObjectDirectoryAddress() {
        return this.objectDirectoryAddress;
    }

    @Override
    protected int getRequiredType() {
        return 2;
    }

    long getNextObjectNumber() {
        ++this.objectNumber;
        this.setChanged();
        return this.objectNumber;
    }

    void setIndexDirectoryAddress(ObjectAddress address) {
        this.indexDirectoryAddress = address;
        this.setChanged();
    }

    void setObjectDirectoryAddress(ObjectAddress address) {
        this.objectDirectoryAddress = address;
        this.setChanged();
    }

    @Override
    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("Context(");
        b.append(this.objectNumber);
        b.append(",");
        b.append(this.indexDirectoryAddress);
        b.append(",");
        b.append(this.objectDirectoryAddress);
        b.append(")");
        return b.toString();
    }
}

