/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.internal.databinding.swt;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.jface.internal.databinding.provisional.swt.AbstractSWTObservableValue;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;

public class ControlObservableValue
extends AbstractSWTObservableValue {
    private final Control control;
    private final String attribute;
    private Object valueType;
    private static final Map SUPPORTED_ATTRIBUTES = new HashMap();

    static {
        SUPPORTED_ATTRIBUTES.put("enabled", Boolean.TYPE);
        SUPPORTED_ATTRIBUTES.put("visible", Boolean.TYPE);
        SUPPORTED_ATTRIBUTES.put("tooltip", String.class);
        SUPPORTED_ATTRIBUTES.put("foreground", Color.class);
        SUPPORTED_ATTRIBUTES.put("background", Color.class);
        SUPPORTED_ATTRIBUTES.put("font", Font.class);
    }

    public ControlObservableValue(Control control, String attribute) {
        super((Widget)control);
        this.control = control;
        this.attribute = attribute;
        if (!SUPPORTED_ATTRIBUTES.keySet().contains(attribute)) {
            throw new IllegalArgumentException();
        }
        this.valueType = SUPPORTED_ATTRIBUTES.get(attribute);
    }

    public void doSetValue(Object value) {
        Object oldValue = this.doGetValue();
        if (this.attribute.equals("enabled")) {
            this.control.setEnabled(((Boolean)value).booleanValue());
        } else if (this.attribute.equals("visible")) {
            this.control.setVisible(((Boolean)value).booleanValue());
        } else if (this.attribute.equals("tooltip")) {
            this.control.setToolTipText((String)value);
        } else if (this.attribute.equals("foreground")) {
            this.control.setForeground((Color)value);
        } else if (this.attribute.equals("background")) {
            this.control.setBackground((Color)value);
        } else if (this.attribute.equals("font")) {
            this.control.setFont((Font)value);
        }
        this.fireValueChange(Diffs.createValueDiff((Object)oldValue, (Object)value));
    }

    public Object doGetValue() {
        if (this.attribute.equals("enabled")) {
            return this.control.getEnabled() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.attribute.equals("visible")) {
            return this.control.getVisible() ? Boolean.TRUE : Boolean.FALSE;
        }
        if (this.attribute.equals("tooltip")) {
            return this.control.getToolTipText();
        }
        if (this.attribute.equals("foreground")) {
            return this.control.getForeground();
        }
        if (this.attribute.equals("background")) {
            return this.control.getBackground();
        }
        if (this.attribute.equals("font")) {
            return this.control.getFont();
        }
        return null;
    }

    public Object getValueType() {
        return this.valueType;
    }
}

