/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class ComboContentAssistSubjectAdapter
extends AbstractControlContentAssistSubjectAdapter {
    private Combo fCombo;
    private HashMap fModifyListeners;

    public ComboContentAssistSubjectAdapter(Combo combo) {
        Assert.isNotNull((Object)combo);
        this.fCombo = combo;
        this.fModifyListeners = new HashMap();
    }

    @Override
    public Control getControl() {
        return this.fCombo;
    }

    @Override
    public int getLineHeight() {
        return this.fCombo.getTextHeight();
    }

    @Override
    public int getCaretOffset() {
        return this.fCombo.getSelection().y;
    }

    @Override
    public Point getLocationAtOffset(int offset) {
        String comboString = this.fCombo.getText();
        GC gc = new GC((Drawable)this.fCombo);
        gc.setFont(this.fCombo.getFont());
        Point extent = gc.textExtent(comboString.substring(0, Math.min(offset, comboString.length())));
        int spaceWidth = gc.textExtent((String)" ").x;
        gc.dispose();
        int x = 2 * spaceWidth + this.fCombo.getClientArea().x + this.fCombo.getBorderWidth() + extent.x;
        return new Point(x, this.fCombo.getClientArea().y);
    }

    @Override
    public Point getWidgetSelectionRange() {
        return new Point(this.fCombo.getSelection().x, Math.abs(this.fCombo.getSelection().y - this.fCombo.getSelection().x));
    }

    @Override
    public Point getSelectedRange() {
        return new Point(this.fCombo.getSelection().x, Math.abs(this.fCombo.getSelection().y - this.fCombo.getSelection().x));
    }

    @Override
    public IDocument getDocument() {
        Object document = (IDocument)this.fCombo.getData("document");
        if (document == null) {
            document = new InternalDocument();
            this.fCombo.setData("document", document);
        }
        return document;
    }

    @Override
    public void setSelectedRange(int i, int j) {
        this.fCombo.setSelection(new Point(i, i + j));
    }

    @Override
    public void revealRange(int i, int j) {
        this.fCombo.setSelection(new Point(i, i + j));
    }

    @Override
    public boolean addSelectionListener(final SelectionListener selectionListener) {
        this.fCombo.addSelectionListener(selectionListener);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                selectionListener.widgetSelected(new SelectionEvent(e));
            }
        };
        this.fCombo.addListener(24, listener);
        this.fModifyListeners.put(selectionListener, listener);
        return true;
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fCombo.removeSelectionListener(selectionListener);
        Object listener = this.fModifyListeners.get(selectionListener);
        if (listener instanceof Listener) {
            this.fCombo.removeListener(24, (Listener)listener);
        }
    }

    private class InternalDocument
    extends Document {
        private ModifyListener fModifyListener;

        private InternalDocument() {
            super(ComboContentAssistSubjectAdapter.this.fCombo.getText());
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InternalDocument.this.set(ComboContentAssistSubjectAdapter.this.fCombo.getText());
                }
            };
            ComboContentAssistSubjectAdapter.this.fCombo.addModifyListener(this.fModifyListener);
        }

        public void replace(int pos, int length, String text) throws BadLocationException {
            super.replace(pos, length, text);
            ComboContentAssistSubjectAdapter.this.fCombo.removeModifyListener(this.fModifyListener);
            ComboContentAssistSubjectAdapter.this.fCombo.setText(this.get());
            ComboContentAssistSubjectAdapter.this.fCombo.addModifyListener(this.fModifyListener);
        }
    }
}

