/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.contentassist;

import java.util.HashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.contentassist.AbstractControlContentAssistSubjectAdapter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class TextContentAssistSubjectAdapter
extends AbstractControlContentAssistSubjectAdapter {
    private Text fText;
    private HashMap fModifyListeners = new HashMap();

    public TextContentAssistSubjectAdapter(Text text) {
        Assert.isNotNull((Object)text);
        this.fText = text;
    }

    @Override
    public Control getControl() {
        return this.fText;
    }

    @Override
    public int getLineHeight() {
        return this.fText.getLineHeight();
    }

    @Override
    public int getCaretOffset() {
        return this.fText.getCaretPosition();
    }

    @Override
    public Point getLocationAtOffset(int offset) {
        Point caretLocation = this.fText.getCaretLocation();
        caretLocation.y += 2;
        return caretLocation;
    }

    @Override
    public Point getWidgetSelectionRange() {
        return new Point(this.fText.getSelection().x, Math.abs(this.fText.getSelection().y - this.fText.getSelection().x));
    }

    @Override
    public Point getSelectedRange() {
        return new Point(this.fText.getSelection().x, Math.abs(this.fText.getSelection().y - this.fText.getSelection().x));
    }

    @Override
    public IDocument getDocument() {
        Object document = (IDocument)this.fText.getData("document");
        if (document == null) {
            document = new InternalDocument();
            this.fText.setData("document", document);
        }
        return document;
    }

    @Override
    public void setSelectedRange(int i, int j) {
        this.fText.setSelection(new Point(i, i + j));
    }

    @Override
    public void revealRange(int i, int j) {
        this.fText.setSelection(new Point(i, i + j));
    }

    @Override
    public boolean addSelectionListener(final SelectionListener selectionListener) {
        this.fText.addSelectionListener(selectionListener);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                selectionListener.widgetSelected(new SelectionEvent(e));
            }
        };
        this.fText.addListener(24, listener);
        this.fModifyListeners.put(selectionListener, listener);
        return true;
    }

    @Override
    public void removeSelectionListener(SelectionListener selectionListener) {
        this.fText.removeSelectionListener(selectionListener);
        Object listener = this.fModifyListeners.get(selectionListener);
        if (listener instanceof Listener) {
            this.fText.removeListener(24, (Listener)listener);
        }
    }

    private class InternalDocument
    extends Document {
        private ModifyListener fModifyListener;

        private InternalDocument() {
            super(TextContentAssistSubjectAdapter.this.fText.getText());
            this.fModifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InternalDocument.this.set(TextContentAssistSubjectAdapter.this.fText.getText());
                }
            };
            TextContentAssistSubjectAdapter.this.fText.addModifyListener(this.fModifyListener);
        }

        public void replace(int pos, int length, String text) throws BadLocationException {
            super.replace(pos, length, text);
            TextContentAssistSubjectAdapter.this.fText.removeModifyListener(this.fModifyListener);
            TextContentAssistSubjectAdapter.this.fText.setText(this.get());
            TextContentAssistSubjectAdapter.this.fText.addModifyListener(this.fModifyListener);
        }
    }
}

