/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.XooNIps.Preference;

import java.io.ByteArrayOutputStream;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.util.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XooNIpsPlatformData {
    public static final String TYPE = "xoonipsplatform";
    private Document mDoc = null;
    private int mStatus = 0;
    private String platformname = null;
    private String url = null;
    private String autofill = null;
    private String username = null;
    private String passwd = null;
    private String description = null;
    private String banner = null;
    private String version = null;
    public static final int STATUS_NOUPDATE = 0;
    public static final int STATUS_UPDATE = 1;
    public static final int STATUS_DELETE = 2;
    public static final int STATUS_NEW = 3;

    public XooNIpsPlatformData() {
        this.newDoc();
    }

    public XooNIpsPlatformData(Document doc) {
        if (doc != null) {
            this.mDoc = doc;
            this.initDoc();
            this.mStatus = 0;
        } else {
            this.newDoc();
        }
    }

    private void newDoc() {
        this.mDoc = DomImpl.createDocument((String)"account");
        Element root = this.mDoc.getDocumentElement();
        root.setAttribute("type", TYPE);
        this.initDoc();
        this.mStatus = 3;
    }

    private void initDoc() {
        String text;
        Node node;
        SecretKey secretkey;
        Element root = this.mDoc.getDocumentElement();
        String value = root.getAttribute("secretkey");
        if (value == null) {
            secretkey = this.newSecretKey();
            if (secretkey != null) {
                this.setSecretKey(secretkey);
            }
        } else if (value.length() == 0 && (secretkey = this.newSecretKey()) != null) {
            this.setSecretKey(secretkey);
        }
        if ((value = root.getAttribute("name")) == null) {
            value = "";
        }
        this.platformname = value;
        value = root.getAttribute("url");
        if (value == null) {
            value = "";
        }
        this.url = value;
        value = root.getAttribute("version");
        if (value == null) {
            value = "";
        }
        this.version = value;
        value = root.getAttribute("autofill");
        if (value == null) {
            value = "false";
        }
        this.autofill = value;
        NodeList nl = root.getElementsByTagName("user");
        String value2 = null;
        if (nl.getLength() > 0) {
            node = nl.item(0);
            value2 = ((Element)node).getTextContent();
        }
        if (value2 == null) {
            value2 = "";
        }
        this.username = value2;
        nl = root.getElementsByTagName("passwd");
        value2 = null;
        if (nl.getLength() > 0 && (text = DomImpl.getElementText((Element)((Element)(node = nl.item(0))))) != null && text.length() > 0) {
            SecretKey secretKey = this.getSecretKey();
            value2 = this.createDecryptStringForDB(text, secretKey);
        }
        if (value2 == null) {
            value2 = "";
        }
        this.passwd = value2;
        nl = root.getElementsByTagName("banner");
        value2 = null;
        if (nl.getLength() > 0) {
            node = nl.item(0);
            value2 = DomImpl.getElementText((Element)((Element)node));
        }
        if (value2 == null) {
            value2 = "";
        }
        this.banner = value2;
        nl = root.getElementsByTagName("description");
        value2 = null;
        if (nl.getLength() > 0) {
            node = nl.item(0);
            value2 = DomImpl.getElementText((Element)((Element)node));
        }
        if (value2 == null) {
            value2 = "";
        }
        this.description = value2;
    }

    public Document getDoc(boolean updateDoc) {
        if (updateDoc) {
            this.updateDoc();
        }
        return this.mDoc;
    }

    private void updateDoc() {
        Node node;
        Element elem;
        NodeList nl;
        Element root = this.mDoc.getDocumentElement();
        if (this.platformname != null) {
            root.setAttribute("name", this.platformname);
        }
        if (this.url != null) {
            root.setAttribute("url", this.url);
        }
        if (this.version != null) {
            root.setAttribute("version", this.version);
        }
        if (this.autofill != null) {
            root.setAttribute("autofill", this.autofill);
        }
        if (this.username != null) {
            nl = root.getElementsByTagName("user");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (this.username != null && this.username.length() > 0) {
                if (elem == null) {
                    elem = this.mDoc.createElement("user");
                    root.appendChild(elem);
                }
                DomImpl.setElementText((Element)elem, (String)this.username);
            }
        }
        if (this.passwd != null) {
            SecretKey secretKey;
            String value;
            nl = root.getElementsByTagName("passwd");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if ((value = this.createEncryptStringForDB(this.passwd, secretKey = this.getSecretKey())) != null && value.length() > 0) {
                if (elem == null) {
                    elem = this.mDoc.createElement("passwd");
                    root.appendChild(elem);
                }
                DomImpl.setElementText((Element)elem, (String)value);
            }
        }
        if (this.banner != null) {
            nl = root.getElementsByTagName("banner");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (this.banner != null && this.banner.length() > 0) {
                if (elem == null) {
                    elem = this.mDoc.createElement("banner");
                    root.appendChild(elem);
                }
                DomImpl.setElementText((Element)elem, (String)this.banner);
            }
        }
        if (this.description != null) {
            nl = root.getElementsByTagName("description");
            elem = null;
            if (nl.getLength() > 0 && (elem = (Element)nl.item(0)) != null) {
                node = elem.getFirstChild();
                while (node != null) {
                    elem.removeChild(node);
                    node = node.getNextSibling();
                }
            }
            if (this.description != null && this.description.length() > 0) {
                if (elem == null) {
                    elem = this.mDoc.createElement("description");
                    root.appendChild(elem);
                }
                DomImpl.setElementText((Element)elem, (String)this.description);
            }
        }
    }

    public int getSTATUS() {
        return this.mStatus;
    }

    public void setSTATUS(int value) {
        this.mStatus = value;
    }

    public String getPlatformName() {
        return this.platformname;
    }

    public void setPlatformName(String value) {
        if (value != null && this.platformname != null && !this.platformname.equals(value)) {
            this.platformname = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getURL() {
        return this.url;
    }

    public void setURL(String value) {
        if (value != null && this.url != null && !this.url.equals(value)) {
            this.url = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public boolean isAutoFill() {
        return this.autofill.equalsIgnoreCase("true");
    }

    public void setAutoFill(boolean value) {
        String autoFillString = "false";
        if (value) {
            autoFillString = "true";
        }
        if (autoFillString != null && this.autofill != null && !this.autofill.equals(autoFillString)) {
            this.autofill = autoFillString;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String value) {
        if (value != null && this.username != null && !this.username.equals(value)) {
            this.username = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getPasswd() {
        return this.passwd;
    }

    public void setPasswd(String value) {
        if (value != null && this.passwd != null && !this.passwd.equals(value)) {
            this.passwd = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    private SecretKey newSecretKey() {
        try {
            KeyGenerator desGen = KeyGenerator.getInstance("DES");
            SecretKey desKey = desGen.generateKey();
            return desKey;
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private byte[] encrypt(byte[] plaintext, SecretKey secretKey) {
        if (plaintext != null && secretKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(1, secretKey);
                return cipher.doFinal(plaintext);
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println(e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                System.err.println(e.getMessage());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private byte[] decrypt(byte[] ciphertext, SecretKey secretKey) {
        if (ciphertext != null && secretKey != null) {
            try {
                Cipher cipher = Cipher.getInstance("DES");
                cipher.init(2, secretKey);
                return cipher.doFinal(ciphertext);
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println(e.getMessage());
            }
            catch (NoSuchPaddingException e) {
                System.err.println(e.getMessage());
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    private String createDecryptStringForDB(String value, SecretKey secretKey) {
        byte[] decodeData;
        byte[] decryptData;
        byte[] data;
        ByteArrayOutputStream baos;
        if (value != null && (baos = Base64.decodeToByteArrayOutputStream((byte[])(data = value.getBytes()), (int)data.length)) != null && (decryptData = this.decrypt(decodeData = baos.toByteArray(), secretKey)) != null) {
            try {
                String decryptString = new String(decryptData);
                return decryptString;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                return null;
            }
        }
        return null;
    }

    private String createEncryptStringForDB(String value, SecretKey secretKey) {
        if (value != null && secretKey != null) {
            byte[] encryptData = this.encrypt(value.getBytes(), secretKey);
            String encodeStr = Base64.encode((byte[])encryptData, (int)encryptData.length);
            return encodeStr;
        }
        return null;
    }

    private SecretKey createSecretKeyFromDB(String value) {
        try {
            if (value != null && value.length() > 0) {
                ByteArrayOutputStream baos = Base64.decodeToByteArrayOutputStream((byte[])value.getBytes(), (int)value.getBytes().length);
                byte[] rawDesKey = baos.toByteArray();
                SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
                DESKeySpec desSpec = new DESKeySpec(rawDesKey);
                return desFactory.generateSecret(desSpec);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private String createSecretKeyStringForDB(SecretKey desKey) {
        try {
            SecretKeyFactory desFactory = SecretKeyFactory.getInstance("DES");
            DESKeySpec desSpec = (DESKeySpec)desFactory.getKeySpec(desKey, DESKeySpec.class);
            byte[] rawDesKey = desSpec.getKey();
            String value = Base64.encode((byte[])rawDesKey, (int)rawDesKey.length);
            return value;
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e.getMessage());
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        return null;
    }

    private void setSecretKey(SecretKey desKey) {
        try {
            String value = this.createSecretKeyStringForDB(desKey);
            if (value != null && value.length() > 0) {
                Element root = this.mDoc.getDocumentElement();
                root.setAttribute("secretkey", value);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    private SecretKey getSecretKey() {
        try {
            Element root = this.mDoc.getDocumentElement();
            String value = root.getAttribute("secretkey");
            if (value != null && value.length() > 0) {
                return this.createSecretKeyFromDB(value);
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void setVersion(String value) {
        if (value != null && this.version != null && !this.version.equals(value)) {
            this.version = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public String getVersion() {
        return this.version;
    }

    public void setBanner(String value) {
        if (value != null && this.banner != null && !this.banner.equals(value)) {
            this.banner = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }

    public void setDescription(String value) {
        if (value != null && this.description != null && !this.description.equals(value)) {
            this.description = value;
            if (this.mStatus == 0) {
                this.mStatus = 1;
            }
        }
    }
}

