/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.exportreference.preferences.customize;

import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormat;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatAuthorsElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatDomImpl;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatElementTransfer;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatEscapeSequenceElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatIdentifiersElement;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatList;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.AuthorFormatDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.ComboDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.EditDatasetListDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.SelectEscapeSequenceDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.SelectIdentifierDialog;
import jp.sourceforge.concierge.plugin.exportreference.preferences.customize.TextDialog;
import jp.sourceforge.concierge.util.SystemUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.FontRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CustomizeReferenceFormatPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Composite _parent = null;
    private TableViewer typeTableViewer = null;
    private ComboViewer datasetListCombo = null;
    private Button datasetEditButton = null;
    private CheckboxTableViewer formatListTableViewerA = null;
    private Button boldButton = null;
    private Button italicButton = null;
    private Combo fontCombo = null;
    private Spinner fontSizeSpinner = null;
    private TableViewer formatEditTableViewer = null;
    private int elementSelectIndex = -1;
    private Color rectTextElemColor;
    private Color fillTextElemColor;
    private Color rectElemColor;
    private Color fillElemColor;
    private Color rectEscElemColor;
    private Color fillEscElemColor;
    private Action addElementAction;
    private Action addStringElementAction;
    private Action deleteElementAction;
    private Action addEscapeSequenceElementAction;
    private Action boldAction;
    private Action italicAction;
    private Action underlineAction;
    private Action editElementAction;
    private FontRegistry fontReg = new FontRegistry();

    public CustomizeReferenceFormatPreferencePage() {
        super("Customize Reference Format");
    }

    public void init(IWorkbench workbench) {
    }

    public void dispose() {
        super.dispose();
    }

    public boolean performOk() {
        this.DoSave();
        return super.performOk();
    }

    protected void performDefaults() {
    }

    protected void contributeButtons(Composite parent) {
        GridLayout layout = (GridLayout)parent.getLayout();
        layout.numColumns = 1;
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        Button myApplyButton = new Button(parent, 8);
        String[] labels = JFaceResources.getStrings((String[])new String[]{"apply"});
        myApplyButton.setText(labels[0]);
        Dialog.applyDialogFont((Control)myApplyButton);
        GridData data = new GridData(256);
        Point minButtonSize = myApplyButton.computeSize(-1, -1, true);
        data.widthHint = Math.max(widthHint, minButtonSize.x);
        myApplyButton.setLayoutData((Object)data);
        myApplyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.performApply();
            }
        });
        myApplyButton.setEnabled(this.isValid());
        this.applyDialogFont(parent);
    }

    protected Control createContents(Composite parent) {
        this.noDefaultAndApplyButton();
        this._parent = parent;
        Control control = this.createSettingControl(parent);
        this.setFirstDataToControls();
        return control;
    }

    private Control createSettingControl(Composite parent) {
        SashForm sf = new SashForm(parent, 256);
        sf.setLayout((Layout)new FillLayout());
        this.createTypeTableViewer((Composite)sf);
        this.createFormatComposite((Composite)sf);
        sf.setWeights(new int[]{25, 75});
        return sf;
    }

    protected void setFirstDataToControls() {
        ArrayList al = TypeManager.getAllTypeDocuments((boolean)true, (boolean)true, (boolean)true);
        int i = 0;
        while (i < al.size()) {
            ReferenceDataFormatList referenceDataFormatList = new ReferenceDataFormatList((Document)al.get(i));
            this.typeTableViewer.add((Object)referenceDataFormatList);
            this.readDoc(referenceDataFormatList);
            ++i;
        }
        if (al.size() > 0) {
            this.typeTableViewer.getTable().deselectAll();
            this.typeTableViewer.getTable().select(0);
            ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)this.typeTableViewer.getElementAt(0);
            this.selectedTypeTableViewer(referenceDataFormatList);
        }
    }

    private void createFormatListComposite(Composite parent) {
        Composite datasetComposite = new Composite(parent, 0);
        datasetComposite.setLayout((Layout)new GridLayout(3, false));
        datasetComposite.setLayoutData((Object)new GridData(768));
        Label datasetLabel = new Label(datasetComposite, 0);
        datasetLabel.setText("Data Set");
        this.datasetListCombo = new ComboViewer(datasetComposite, 8);
        this.datasetListCombo.getControl().setLayoutData((Object)new GridData(768));
        this.datasetListCombo.setLabelProvider((IBaseLabelProvider)new DatasetComboViewLabelProvider());
        this.datasetListCombo.setContentProvider((IContentProvider)new ViewContentProvider());
        this.datasetListCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj;
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null && (obj = selection.getFirstElement()) != null && obj instanceof ReferenceDataFormat) {
                    ReferenceDataFormat format = (ReferenceDataFormat)obj;
                    ReferenceDataFormatList referenceDataFormatList = CustomizeReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                    referenceDataFormatList.setFormatListIndex(format);
                    CustomizeReferenceFormatPreferencePage.this.setFormatToFormatEditTableViewer(format);
                }
            }
        });
        this.datasetEditButton = new Button(datasetComposite, 8);
        this.datasetEditButton.setText("...");
        this.datasetEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                ReferenceDataFormatList referenceDataFormatList = CustomizeReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                ArrayList<ReferenceDataFormat> formatList = referenceDataFormatList.getFormatList();
                EditDatasetListDialog dlg = new EditDatasetListDialog(button.getShell(), formatList, referenceDataFormatList.getTypeDoc());
                if (dlg.open() == 0) {
                    ArrayList<ReferenceDataFormat> al = dlg.getFormatList();
                    int i = formatList.size() - 1;
                    while (i >= 0) {
                        ReferenceDataFormat srcObj = formatList.get(i);
                        if (!al.remove(srcObj)) {
                            formatList.remove(i);
                        }
                        --i;
                    }
                    if (al.size() > 0) {
                        formatList.addAll(al);
                        referenceDataFormatList.setFormatListIndex(formatList.size() - 1);
                        CustomizeReferenceFormatPreferencePage.this.datasetListCombo.refresh();
                        CustomizeReferenceFormatPreferencePage.this.datasetListCombo.getCombo().select(referenceDataFormatList.getFormatListIndex());
                        CustomizeReferenceFormatPreferencePage.this.setFormatToFormatEditTableViewer(formatList.get(referenceDataFormatList.getFormatListIndex()));
                    }
                }
            }
        });
    }

    private void createTypeTableViewer(Composite parent) {
        this.typeTableViewer = new TableViewer(parent, 68356);
        this.typeTableViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.typeTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.typeTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.typeTableViewer.getTable().setHeaderVisible(true);
        TableColumn tc = new TableColumn(this.typeTableViewer.getTable(), 16384, 0);
        tc.setText("Type");
        this.typeTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = CustomizeReferenceFormatPreferencePage.this.typeTableViewer.getTable().getClientArea();
                TableColumn[] col = CustomizeReferenceFormatPreferencePage.this.typeTableViewer.getTable().getColumns();
                if (col.length > 0) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.typeTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof ReferenceDataFormatList) {
                    ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)obj;
                    CustomizeReferenceFormatPreferencePage.this.selectedTypeTableViewer(referenceDataFormatList);
                }
            }
        });
    }

    private void selectedTypeTableViewer(ReferenceDataFormatList referenceDataFormatList) {
        ArrayList<ReferenceDataFormat> formatList = referenceDataFormatList.getFormatList();
        this.datasetListCombo.setInput(formatList);
        this.datasetListCombo.getCombo().select(referenceDataFormatList.getFormatListIndex());
        ReferenceDataFormat format = formatList.get(referenceDataFormatList.getFormatListIndex());
        this.setFormatToFormatEditTableViewer(format);
    }

    private ReferenceDataFormat getSelectionFormatListControl() {
        Object obj;
        ISelection selection = this.datasetListCombo.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceDataFormat) {
            return (ReferenceDataFormat)obj;
        }
        return null;
    }

    private ReferenceDataFormatList getSelectionTypeTableViewer() {
        Object obj;
        ISelection selection = this.typeTableViewer.getSelection();
        if (selection != null && (obj = ((IStructuredSelection)selection).getFirstElement()) != null && obj instanceof ReferenceDataFormatList) {
            return (ReferenceDataFormatList)obj;
        }
        return null;
    }

    private ArrayList<Object> getFormatElementListFromTableViewer() {
        ArrayList pl = (ArrayList)this.formatEditTableViewer.getInput();
        if (pl == null) {
            pl = new ArrayList();
            pl.add(new ArrayList());
            this.formatEditTableViewer.setInput(pl);
        } else if (pl.size() == 0) {
            pl.add(new ArrayList());
        }
        return (ArrayList)pl.get(0);
    }

    private void setFormatToFormatEditTableViewer(ReferenceDataFormat format) {
        this.elementSelectIndex = -1;
        if (format != null) {
            ArrayList<Object> elementList;
            this.formatEditTableViewer.getTable().setVisible(false);
            TableColumn[] cols = this.formatEditTableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].dispose();
                ++i;
            }
            ArrayList<ArrayList<Object>> pl = (ArrayList<ArrayList<Object>>)this.formatEditTableViewer.getInput();
            if (pl != null) {
                elementList = format.getElementList();
                if (pl.size() > 0) {
                    pl.set(0, elementList);
                } else {
                    pl.add(elementList);
                }
            } else {
                pl = new ArrayList<ArrayList<Object>>();
                elementList = format.getElementList();
                pl.add(elementList);
                this.formatEditTableViewer.setInput(pl);
            }
            int i2 = 0;
            while (i2 < this.getFormatElementListFromTableViewer().size()) {
                new TableColumn(this.formatEditTableViewer.getTable(), 0x1000000);
                ++i2;
            }
            String fontname = format.getFontname();
            this.fontCombo.select(0);
            if (fontname != null) {
                int i3 = 0;
                while (i3 < this.fontCombo.getItemCount()) {
                    if (this.fontCombo.getItem(i3).equalsIgnoreCase(fontname)) {
                        this.fontCombo.select(i3);
                        break;
                    }
                    ++i3;
                }
            }
            this.fontSizeSpinner.setSelection(format.getFontSize());
            this.boldButton.setEnabled(false);
            this.italicButton.setEnabled(false);
            this.formatEditTableViewer.getTable().setFont(this.newFont(null, format.getFontname(), format.getFontSize(), 0));
            TableItem ti = this.formatEditTableViewer.getTable().getItem(0);
            int i4 = 0;
            while (i4 < this.getFormatElementListFromTableViewer().size()) {
                short style = 0;
                Object cont = this.getFormatElementListFromTableViewer().get(i4);
                if (cont instanceof ReferenceDataFormatElement) {
                    if (((ReferenceDataFormatElement)cont).getBold()) {
                        style = (short)(style | 1);
                    }
                    if (((ReferenceDataFormatElement)cont).getItalic()) {
                        style = (short)(style | 2);
                    }
                }
                ti.setFont(i4, null);
                ti.setFont(i4, this.newFont(null, format.getFontname(), format.getFontSize(), style));
                ++i4;
            }
            this.setColumnWidthOnFormatEditTableViewer();
            this.formatEditTableViewer.refresh();
            this.formatEditTableViewer.getTable().setVisible(true);
        } else {
            TableColumn[] cols = this.formatEditTableViewer.getTable().getColumns();
            int i = 0;
            while (i < cols.length) {
                cols[i].dispose();
                ++i;
            }
            this.getFormatElementListFromTableViewer().clear();
            ArrayList pl = (ArrayList)this.formatEditTableViewer.getInput();
            pl.set(0, new ArrayList());
            this.fontCombo.deselectAll();
            this.fontSizeSpinner.setSelection(0);
            this.boldButton.setEnabled(false);
            this.italicButton.setEnabled(false);
            this.formatEditTableViewer.refresh();
        }
    }

    private void createFormatComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 2;
        gl.marginHeight = 2;
        composite.setLayout((Layout)gl);
        this.createFormatListComposite(composite);
        this.createFormatEditComposite(composite);
    }

    private void createFormatEditComposite(Composite parent) {
        Composite formatEditComposite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(2, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        formatEditComposite.setLayout((Layout)gl);
        formatEditComposite.setLayoutData((Object)new GridData(1808));
        this.createFormatEditTableViewer(formatEditComposite);
        Composite actionComposite = new Composite(formatEditComposite, 0);
        GridLayout gl2 = new GridLayout(1, false);
        gl2.marginWidth = 0;
        gl2.marginHeight = 0;
        actionComposite.setLayout((Layout)gl2);
        actionComposite.setLayoutData((Object)new GridData(1040));
        Button editElementButton = new Button(actionComposite, 8);
        editElementButton.setText("Edit");
        editElementButton.setLayoutData((Object)new GridData(768));
        editElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.editElementAction.run();
            }
        });
        Button addElementButton = new Button(actionComposite, 8);
        addElementButton.setText("Add Element");
        addElementButton.setLayoutData((Object)new GridData(768));
        addElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.addElementAction.run();
            }
        });
        Button addTextElementButton = new Button(actionComposite, 8);
        addTextElementButton.setText("Add Text");
        addTextElementButton.setLayoutData((Object)new GridData(768));
        addTextElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.addStringElementAction.run();
            }
        });
        Button addEscapeSequenceElementButton = new Button(actionComposite, 8);
        addEscapeSequenceElementButton.setText("Add CR/TAB");
        addEscapeSequenceElementButton.setLayoutData((Object)new GridData(768));
        addEscapeSequenceElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.addEscapeSequenceElementAction.run();
            }
        });
        Button deleteElementButton = new Button(actionComposite, 8);
        deleteElementButton.setText("Delete");
        deleteElementButton.setLayoutData((Object)new GridData(768));
        deleteElementButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CustomizeReferenceFormatPreferencePage.this.deleteElementAction.run();
            }
        });
        Group fg3 = new Group(actionComposite, 0);
        GridLayout gl3 = new GridLayout(1, false);
        fg3.setLayout((Layout)gl3);
        fg3.setLayoutData((Object)new GridData(1808));
        this.boldButton = new Button((Composite)fg3, 32);
        this.boldButton.setLayoutData((Object)new GridData(768));
        this.boldButton.setText("Bold");
        this.boldButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                    CustomizeReferenceFormatPreferencePage.this.boldAction.setChecked(((Button)e.getSource()).getSelection());
                    CustomizeReferenceFormatPreferencePage.this.boldAction.run();
                }
            }
        });
        this.boldButton.setEnabled(false);
        this.boldButton.setSelection(false);
        this.italicButton = new Button((Composite)fg3, 32);
        this.italicButton.setLayoutData((Object)new GridData(768));
        this.italicButton.setText("Italic");
        this.italicButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                    CustomizeReferenceFormatPreferencePage.this.italicAction.setChecked(((Button)e.getSource()).getSelection());
                    CustomizeReferenceFormatPreferencePage.this.italicAction.run();
                }
            }
        });
        this.italicButton.setEnabled(false);
        this.italicButton.setSelection(false);
    }

    private void createFormatEditTableViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gl = new GridLayout(1, false);
        gl.marginWidth = 0;
        gl.marginHeight = 0;
        composite.setLayout((Layout)gl);
        composite.setLayoutData((Object)new GridData(1808));
        this.formatEditTableViewer = new TableViewer(composite, 16845572);
        GridData gd = new GridData(1808);
        gd.widthHint = 320;
        this.formatEditTableViewer.getControl().setLayoutData((Object)gd);
        this.formatEditTableViewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.formatEditTableViewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.formatEditTableViewer.getTable().setFont(this.newFont(null, ReferenceDataFormat.getDefaultFontName(), 12, 0));
        ArrayList pl = new ArrayList();
        ArrayList formatArray = new ArrayList();
        pl.add(formatArray);
        this.formatEditTableViewer.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
            }
        });
        this.formatEditTableViewer.getTable().addListener(3, new Listener(){

            public void handleEvent(Event event) {
                CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = -1;
                Point pt = new Point(event.x, event.y);
                TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                if (ti != null) {
                    int i = 0;
                    while (i < CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount()) {
                        Rectangle rect = ti.getBounds(i);
                        if (rect.contains(pt)) {
                            CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = i;
                            break;
                        }
                        ++i;
                    }
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                    CustomizeReferenceFormatPreferencePage.this.deleteElementAction.setEnabled(true);
                    Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                    if (cont instanceof ReferenceDataFormatElement) {
                        CustomizeReferenceFormatPreferencePage.this.boldAction.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.boldAction.setChecked(((ReferenceDataFormatElement)cont).getBold());
                        CustomizeReferenceFormatPreferencePage.this.italicAction.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.italicAction.setChecked(((ReferenceDataFormatElement)cont).getItalic());
                        CustomizeReferenceFormatPreferencePage.this.underlineAction.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.underlineAction.setChecked(((ReferenceDataFormatElement)cont).getUnderline());
                        CustomizeReferenceFormatPreferencePage.this.boldButton.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.boldButton.setSelection(((ReferenceDataFormatElement)cont).getBold());
                        CustomizeReferenceFormatPreferencePage.this.italicButton.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.italicButton.setSelection(((ReferenceDataFormatElement)cont).getItalic());
                        if (cont instanceof ReferenceDataFormatIdentifiersElement) {
                            CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(true);
                        } else if (cont instanceof ReferenceDataFormatAuthorsElement) {
                            CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(true);
                        } else if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                            CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(true);
                        } else {
                            CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(false);
                        }
                    } else {
                        CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(true);
                        CustomizeReferenceFormatPreferencePage.this.boldAction.setEnabled(false);
                        CustomizeReferenceFormatPreferencePage.this.boldAction.setChecked(false);
                        CustomizeReferenceFormatPreferencePage.this.italicAction.setEnabled(false);
                        CustomizeReferenceFormatPreferencePage.this.italicAction.setChecked(false);
                        CustomizeReferenceFormatPreferencePage.this.underlineAction.setEnabled(false);
                        CustomizeReferenceFormatPreferencePage.this.underlineAction.setChecked(false);
                        CustomizeReferenceFormatPreferencePage.this.boldButton.setEnabled(false);
                        CustomizeReferenceFormatPreferencePage.this.boldButton.setSelection(false);
                        CustomizeReferenceFormatPreferencePage.this.italicButton.setEnabled(false);
                        CustomizeReferenceFormatPreferencePage.this.italicButton.setSelection(false);
                    }
                } else {
                    CustomizeReferenceFormatPreferencePage.this.editElementAction.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.deleteElementAction.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.boldAction.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.boldAction.setChecked(false);
                    CustomizeReferenceFormatPreferencePage.this.italicAction.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.italicAction.setChecked(false);
                    CustomizeReferenceFormatPreferencePage.this.underlineAction.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.underlineAction.setChecked(false);
                    CustomizeReferenceFormatPreferencePage.this.boldButton.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.boldButton.setSelection(false);
                    CustomizeReferenceFormatPreferencePage.this.italicButton.setEnabled(false);
                    CustomizeReferenceFormatPreferencePage.this.italicButton.setSelection(false);
                }
            }
        });
        this.formatEditTableViewer.getTable().addListener(40, new Listener(){

            public void handleEvent(Event event) {
                if ((event.detail & 2) != 0) {
                    event.detail &= 0xFFFFFFFD;
                }
            }
        });
        this.rectTextElemColor = new Color(null, 164, 189, 236);
        this.fillTextElemColor = new Color(null, 222, 231, 248);
        this.rectElemColor = new Color(null, 129, 184, 127);
        this.fillElemColor = new Color(null, 212, 255, 191);
        this.rectEscElemColor = new Color(null, 255, 29, 0);
        this.fillEscElemColor = new Color(null, 255, 107, 102);
        this.formatEditTableViewer.getTable().addListener(42, new Listener(){

            public void handleEvent(Event event) {
                Object cont;
                GC gc = event.gc;
                Color oldForeground = gc.getForeground();
                Color oldBackground = gc.getBackground();
                Color fillColor = CustomizeReferenceFormatPreferencePage.this.fillTextElemColor;
                Color rectColor = CustomizeReferenceFormatPreferencePage.this.rectTextElemColor;
                ArrayList obj = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer();
                if (obj instanceof ArrayList) {
                    cont = obj.get(event.index);
                    if (cont instanceof ReferenceDataFormatElement) {
                        fillColor = CustomizeReferenceFormatPreferencePage.this.fillElemColor;
                        rectColor = CustomizeReferenceFormatPreferencePage.this.rectElemColor;
                    } else if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                        fillColor = CustomizeReferenceFormatPreferencePage.this.fillEscElemColor;
                        rectColor = CustomizeReferenceFormatPreferencePage.this.rectEscElemColor;
                    }
                }
                if (SystemUtil.GetOSType() == 1) {
                    if (event.index == CustomizeReferenceFormatPreferencePage.this.elementSelectIndex) {
                        gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                        gc.fillRectangle(event.x - 2, event.y, event.width + 4, event.height);
                        gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                        gc.fillRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                        gc.setForeground(rectColor);
                        gc.drawRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                    } else {
                        gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                        gc.fillRectangle(event.x - 2, event.y, event.width + 4, event.height);
                        gc.setBackground(fillColor);
                        gc.fillRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                        gc.setForeground(rectColor);
                        gc.drawRoundRectangle(event.x - 2, event.y + 1, event.width + 4, event.height - 2, 10, 10);
                    }
                } else if (event.index == CustomizeReferenceFormatPreferencePage.this.elementSelectIndex) {
                    gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                    gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                    gc.fillRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                    gc.setForeground(rectColor);
                    gc.drawRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                } else {
                    gc.setBackground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(1));
                    gc.fillRectangle(event.x, event.y, event.width, event.height);
                    gc.setBackground(fillColor);
                    gc.fillRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                    gc.setForeground(rectColor);
                    gc.drawRoundRectangle(event.x + 1, event.y + 1, event.width - 2, event.height - 2, 10, 10);
                }
                gc.setForeground(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getDisplay().getSystemColor(2));
                if (obj instanceof ArrayList) {
                    cont = obj.get(event.index);
                    if (cont instanceof String) {
                        String text = (String)cont;
                        Point size = gc.textExtent(text);
                        int offsetY = Math.max(0, event.height - size.y);
                        int offsetX = Math.max(0, (event.width - size.x) / 2);
                        gc.drawText(text, event.x + offsetX, event.y + offsetY, true);
                    } else if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                        String text = ((ReferenceDataFormatEscapeSequenceElement)cont).getViewString();
                        Point size = gc.textExtent(text);
                        int offsetY = Math.max(0, event.height - size.y);
                        int offsetX = Math.max(0, (event.width - size.x) / 2);
                        gc.drawText(text, event.x + offsetX, event.y + offsetY, true);
                    } else if (cont instanceof ReferenceDataFormatElement) {
                        String text = ((ReferenceDataFormatElement)cont).getViewString();
                        Point size = gc.textExtent(text);
                        int offsetY = Math.max(0, event.height - size.y);
                        int offsetX = Math.max(0, (event.width - size.x) / 2);
                        gc.drawText(text, event.x + offsetX, event.y + offsetY, true);
                    }
                }
                gc.setForeground(oldForeground);
                gc.setBackground(oldBackground);
            }
        });
        int i = 0;
        while (i < formatArray.size()) {
            new TableColumn(this.formatEditTableViewer.getTable(), 0x1000000);
            ++i;
        }
        this.formatEditTableViewer.setInput(pl);
        TableItem ti = this.formatEditTableViewer.getTable().getItem(0);
        int i2 = 0;
        while (i2 < this.getFormatElementListFromTableViewer().size()) {
            ti.setFont(i2, null);
            ti.setFont(i2, this.newFont(null, ReferenceDataFormat.getDefaultFontName(), 12, 0));
            ++i2;
        }
        ReferenceDataFormatElementTransfer rftiTransfer = ReferenceDataFormatElementTransfer.getInstance();
        Transfer[] transferTypes = null;
        transferTypes = new Transfer[]{rftiTransfer};
        this.formatEditTableViewer.addDragSupport(18, transferTypes, (DragSourceListener)new DragFormatItemTableAdapter());
        this.formatEditTableViewer.addDropSupport(18, transferTypes, (DropTargetListener)new DropFormatItemTableAdapter());
        Group fg = new Group(composite, 0);
        fg.setLayoutData((Object)new GridData(768));
        fg.setLayout((Layout)new GridLayout(2, false));
        this.fontCombo = new Combo((Composite)fg, 8);
        FontData[] fontdata = this.fontCombo.getDisplay().getFontList(null, true);
        ArrayList<String> fontlist = new ArrayList<String>();
        int i3 = 0;
        while (i3 < fontdata.length) {
            if (!fontlist.contains(fontdata[i3].getName())) {
                fontlist.add(fontdata[i3].getName());
            }
            ++i3;
        }
        int j = 0;
        while (j < fontlist.size()) {
            this.fontCombo.add((String)fontlist.get(j));
            ++j;
        }
        this.fontCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                if (format != null) {
                    format.setFontname(((Combo)e.getSource()).getText());
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().setFont(CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0));
                    TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                    int i = 0;
                    while (i < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                        Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(i);
                        short style = 0;
                        if (cont instanceof ReferenceDataFormatElement) {
                            if (((ReferenceDataFormatElement)cont).getBold()) {
                                style = (short)(style | 1);
                            }
                            if (((ReferenceDataFormatElement)cont).getItalic()) {
                                style = (short)(style | 2);
                            }
                        }
                        ti.setFont(i, null);
                        ti.setFont(i, CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), style));
                        ++i;
                    }
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                }
            }
        });
        this.fontSizeSpinner = new Spinner((Composite)fg, 2048);
        this.fontSizeSpinner.setMinimum(8);
        this.fontSizeSpinner.setMaximum(64);
        this.fontSizeSpinner.setSelection(12);
        this.fontSizeSpinner.setIncrement(1);
        this.fontSizeSpinner.setPageIncrement(4);
        this.fontSizeSpinner.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                if (format != null) {
                    format.setFontSize(((Spinner)e.getSource()).getSelection());
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().setFont(CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0));
                    TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                    int i = 0;
                    while (i < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                        short style = 0;
                        Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(i);
                        if (cont instanceof ReferenceDataFormatElement) {
                            if (((ReferenceDataFormatElement)cont).getBold()) {
                                style = (short)(style | 1);
                            }
                            if (((ReferenceDataFormatElement)cont).getItalic()) {
                                style = (short)(style | 2);
                            }
                        }
                        ti.setFont(i, null);
                        ti.setFont(i, CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), style));
                        ++i;
                    }
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                }
            }
        });
        this.makeActions();
        this.hookContextMenu();
        this.hookDoubleClickAction();
    }

    private void setColumnWidthOnFormatEditTableViewer() {
        GC gc = new GC((Drawable)this.formatEditTableViewer.getTable().getDisplay());
        ReferenceDataFormat format = this.getSelectionFormatListControl();
        int offsetX = 16;
        if (SystemUtil.GetOSType() == 1) {
            offsetX = 8;
        }
        TableColumn[] col = this.formatEditTableViewer.getTable().getColumns();
        int i = 0;
        while (i < col.length) {
            Point pt;
            Object cont = this.getFormatElementListFromTableViewer().get(i);
            if (cont instanceof String) {
                Font font = this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                gc.setFont(font);
                pt = gc.textExtent((String)cont);
                int width = pt.x + offsetX;
                col[i].setWidth(width);
                gc.setFont(null);
            } else if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                Font font = this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                gc.setFont(font);
                pt = gc.textExtent(((ReferenceDataFormatEscapeSequenceElement)cont).getViewString());
                int width = pt.x + offsetX;
                col[i].setWidth(width);
                gc.setFont(null);
            } else if (cont instanceof ReferenceDataFormatElement) {
                short style = 0;
                if (((ReferenceDataFormatElement)cont).getBold()) {
                    style = (short)(style | 1);
                }
                if (((ReferenceDataFormatElement)cont).getItalic()) {
                    style = (short)(style | 2);
                }
                Font font = this.newFont(null, format.getFontname(), format.getFontSize(), style);
                gc.setFont(font);
                Point pt2 = gc.textExtent(((ReferenceDataFormatElement)cont).getViewString());
                int width = pt2.x + offsetX;
                col[i].setWidth(width);
                gc.setFont(null);
            } else {
                col[i].setWidth(100);
            }
            ++i;
        }
        gc.dispose();
        gc = null;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                CustomizeReferenceFormatPreferencePage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.formatEditTableViewer.getControl());
        this.formatEditTableViewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.addElementAction);
        manager.add((IAction)this.addStringElementAction);
        manager.add((IAction)this.addEscapeSequenceElementAction);
        if (this.elementSelectIndex >= 0 && this.elementSelectIndex < this.getFormatElementListFromTableViewer().size()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.editElementAction);
            manager.add((IAction)this.deleteElementAction);
            Object cont = this.getFormatElementListFromTableViewer().get(this.elementSelectIndex);
            if (cont instanceof ReferenceDataFormatElement) {
                manager.add((IContributionItem)new Separator());
                manager.add((IAction)this.boldAction);
                manager.add((IAction)this.italicAction);
            }
        }
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void makeActions() {
        this.addElementAction = new Action(){

            public void run() {
                Element typeelem;
                ReferenceDataFormatList referenceDataFormatList = CustomizeReferenceFormatPreferencePage.this.getSelectionTypeTableViewer();
                ArrayList<Element> typeElems = referenceDataFormatList.getTypeElements();
                String[] typeitems = new String[typeElems.size()];
                int j = 0;
                while (j < typeElems.size()) {
                    typeelem = typeElems.get(j);
                    typeitems[j] = TypeDomImpl.getElementName((Element)typeelem);
                    ++j;
                }
                ComboDialog dlg = new ComboDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), typeitems, 0);
                if (dlg.open() == 0) {
                    typeelem = typeElems.get(dlg.getValue());
                    String parser = TypeDomImpl.getParser((Element)typeelem);
                    TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                    ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                    if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                        if (parser.equals("authors")) {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new ReferenceDataFormatAuthorsElement(typeitems[dlg.getValue()]));
                        } else if (parser.equals("identifiers")) {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new ReferenceDataFormatIdentifiersElement(typeitems[dlg.getValue()]));
                        } else {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new ReferenceDataFormatElement(typeitems[dlg.getValue()]));
                        }
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        int i = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 2;
                        while (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex <= i) {
                            Font font = ti.getFont(i);
                            ti.setFont(i + 1, null);
                            ti.setFont(i + 1, font);
                            --i;
                        }
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    } else {
                        if (parser.equals("authors")) {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(new ReferenceDataFormatAuthorsElement(typeitems[dlg.getValue()]));
                        } else if (parser.equals("identifiers")) {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(new ReferenceDataFormatIdentifiersElement(typeitems[dlg.getValue()]));
                        } else {
                            CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(new ReferenceDataFormatElement(typeitems[dlg.getValue()]));
                        }
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 1;
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    }
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.addElementAction.setText("Add Element");
        this.addElementAction.setToolTipText("Add Concierge Type Element");
        this.addElementAction.setEnabled(true);
        this.addEscapeSequenceElementAction = new Action(){

            public void run() {
                SelectEscapeSequenceDialog dlg = new SelectEscapeSequenceDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), null);
                if (dlg.open() == 0) {
                    TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                    ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                    if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                        CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new ReferenceDataFormatEscapeSequenceElement(dlg.getEscapeSequence()));
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        int i = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 2;
                        while (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex <= i) {
                            Font font = ti.getFont(i);
                            ti.setFont(i + 1, null);
                            ti.setFont(i + 1, font);
                            --i;
                        }
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    } else {
                        CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(new ReferenceDataFormatEscapeSequenceElement(dlg.getEscapeSequence()));
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 1;
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    }
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.addEscapeSequenceElementAction.setText("Add EscapeSequence");
        this.addEscapeSequenceElementAction.setToolTipText("Add EscapeSequence");
        this.addEscapeSequenceElementAction.setEnabled(true);
        this.addStringElementAction = new Action(){

            public void run() {
                TextDialog dlg = new TextDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), "");
                if (dlg.open() == 0) {
                    TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                    ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                    if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                        CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new String(dlg.getValue()));
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        int i = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 2;
                        while (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex <= i) {
                            Font font = ti.getFont(i);
                            ti.setFont(i + 1, null);
                            ti.setFont(i + 1, font);
                            --i;
                        }
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    } else {
                        CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().add(new String(dlg.getValue()));
                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                        CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size() - 1;
                        Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), 0);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                        ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    }
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.addStringElementAction.setText("Add Text");
        this.addStringElementAction.setToolTipText("Add Text");
        this.addStringElementAction.setEnabled(true);
        this.deleteElementAction = new Action(){

            public void run() {
                TableColumn tc;
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount() && (tc = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumn(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex)) != null) {
                    tc.dispose();
                }
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().size()) {
                    CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().remove(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                }
                CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = -1;
            }
        };
        this.deleteElementAction.setText("Delete");
        this.deleteElementAction.setToolTipText("Delete");
        this.deleteElementAction.setEnabled(false);
        this.italicAction = new Action(){

            public void run() {
                TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                if (cont instanceof ReferenceDataFormatElement) {
                    ((ReferenceDataFormatElement)cont).setItalic(CustomizeReferenceFormatPreferencePage.this.italicAction.isChecked());
                    ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                    short style = 0;
                    if (((ReferenceDataFormatElement)cont).getBold()) {
                        style = (short)(style | 1);
                    }
                    if (CustomizeReferenceFormatPreferencePage.this.italicAction.isChecked()) {
                        style = (short)(style | 2);
                    }
                    Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), style);
                    ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                    ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.italicAction.setText("Italic");
        this.italicAction.setToolTipText("Italic");
        this.italicAction.setEnabled(false);
        this.italicAction.setChecked(false);
        this.boldAction = new Action(){

            public void run() {
                TableItem ti = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                if (cont instanceof ReferenceDataFormatElement) {
                    ((ReferenceDataFormatElement)cont).setBold(CustomizeReferenceFormatPreferencePage.this.boldAction.isChecked());
                    ReferenceDataFormat format = CustomizeReferenceFormatPreferencePage.this.getSelectionFormatListControl();
                    short style = 0;
                    if (CustomizeReferenceFormatPreferencePage.this.boldAction.isChecked()) {
                        style = (short)(style | 1);
                    }
                    if (((ReferenceDataFormatElement)cont).getItalic()) {
                        style = (short)(style | 2);
                    }
                    Font font = CustomizeReferenceFormatPreferencePage.this.newFont(null, format.getFontname(), format.getFontSize(), style);
                    ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, null);
                    ti.setFont(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, font);
                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.boldAction.setText("Bold");
        this.boldAction.setToolTipText("Bold");
        this.boldAction.setEnabled(false);
        this.boldAction.setChecked(false);
        this.underlineAction = new Action(){

            public void run() {
                Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                if (cont instanceof ReferenceDataFormatElement) {
                    ((ReferenceDataFormatElement)cont).setUnderline(CustomizeReferenceFormatPreferencePage.this.underlineAction.isChecked());
                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                }
            }
        };
        this.underlineAction.setText("Underline");
        this.underlineAction.setToolTipText("Underline");
        this.underlineAction.setEnabled(false);
        this.underlineAction.setChecked(false);
        this.editElementAction = new Action(){

            public void run() {
                ISelection selection = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getSelection();
                Object obj = ((IStructuredSelection)selection).getFirstElement();
                if (obj != null && obj instanceof ArrayList) {
                    Object cont = ((ArrayList)obj).get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                    if (cont instanceof String) {
                        TextDialog dlg = new TextDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), (String)cont);
                        if (dlg.open() == 0) {
                            ArrayList al = (ArrayList)obj;
                            al.set(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex, new String(dlg.getValue()));
                            CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                            CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                        }
                    } else if (cont instanceof ReferenceDataFormatAuthorsElement) {
                        ReferenceDataFormatAuthorsElement data = (ReferenceDataFormatAuthorsElement)cont;
                        AuthorFormatDialog dlg = new AuthorFormatDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), data);
                        if (dlg.open() == 0) {
                            data.setFirstAuthor(dlg.getFirstAuthor());
                            data.setConnectionString(dlg.getConnectionString());
                            data.setSecondAuthor(dlg.getSecondAuthor());
                            data.setConnectionLastString(dlg.getConnectionLastString());
                            data.setLastAuthor(dlg.getLastAuthor());
                        }
                    } else if (cont instanceof ReferenceDataFormatIdentifiersElement) {
                        ReferenceDataFormatIdentifiersElement data = (ReferenceDataFormatIdentifiersElement)cont;
                        SelectIdentifierDialog dlg = new SelectIdentifierDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), data.getIdentifier());
                        if (dlg.open() == 0) {
                            data.setIdentifier(dlg.getIdentifier());
                        }
                    } else if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                        ReferenceDataFormatEscapeSequenceElement data = (ReferenceDataFormatEscapeSequenceElement)cont;
                        SelectEscapeSequenceDialog dlg = new SelectEscapeSequenceDialog(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getShell(), data.getEscapeSequence());
                        if (dlg.open() == 0) {
                            data.setEscapeSequence(dlg.getEscapeSequence());
                            CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                            CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                        }
                    } else {
                        boolean cfr_ignored_0 = cont instanceof ReferenceDataFormatElement;
                    }
                }
            }
        };
        this.editElementAction.setText("Edit");
        this.editElementAction.setToolTipText("Edit");
        this.editElementAction.setEnabled(false);
    }

    private void hookDoubleClickAction() {
        this.formatEditTableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CustomizeReferenceFormatPreferencePage.this.editElementAction.run();
            }
        });
    }

    private void DoSave() {
        this.deleteReferenceDataFormat();
        this.saveReferenceFormat();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)this.typeTableViewer.getElementAt(i);
            ArrayList<ReferenceDataFormat> al = referenceDataFormatList.getFormatList();
            ReferenceDataFormat format = al.get(referenceDataFormatList.getFormatListIndex());
            ReferenceDataFormatDomImpl.setCurrentFormat(referenceDataFormatList.getTypeName(), format);
            ++i;
        }
    }

    private void deleteReferenceDataFormat() {
        String xpath = new String();
        xpath = String.valueOf(xpath) + "/referencedataformat";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(2, (Object)docs, "exportmappingdata"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.exportreference.preferences.customize.CustomizeReferenceFormatPreferencePage");
            reqs = null;
        }
        docs = null;
    }

    private void saveReferenceFormat() {
        ArrayList<Document> docs = new ArrayList<Document>();
        int i = 0;
        while (i < this.typeTableViewer.getTable().getItemCount()) {
            ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)this.typeTableViewer.getElementAt(i);
            Document doc = this.writeNewDoc(referenceDataFormatList);
            if (doc != null) {
                docs.add(doc);
            }
            ++i;
        }
        if (docs.size() > 0) {
            ArrayList<Request> reqs = new ArrayList<Request>();
            reqs.add(new Request(1, docs, "exportmappingdata"));
            FrameworkPlugin.updateDocuments(reqs, (Object)"jp.sourceforge.concierge.plugin.exportreference.preferences.customize.CustomizeReferenceFormatPreferencePage");
        }
    }

    private Document writeNewDoc(ReferenceDataFormatList referenceDataFormatList) {
        Document doc = null;
        try {
            doc = DomImpl.createDocument((String)"referencedataformat");
            Element root_elem = doc.getDocumentElement();
            root_elem.setAttribute("typeid", String.valueOf(DomImpl.getID((Document)referenceDataFormatList.getTypeDoc())));
            root_elem.setAttribute("select", String.valueOf(referenceDataFormatList.getFormatListIndex()));
            ArrayList<ReferenceDataFormat> formatList = referenceDataFormatList.getFormatList();
            int j = 0;
            while (j < formatList.size()) {
                ReferenceDataFormat format = formatList.get(j);
                Element formatElem = doc.createElement("format");
                root_elem.appendChild(formatElem);
                formatElem.setAttribute("formatname", format.getName());
                formatElem.setAttribute("fontname", format.getFontname());
                formatElem.setAttribute("fontsize", String.valueOf(format.getFontSize()));
                ArrayList<Object> elementList = format.getElementList();
                int k = 0;
                while (k < elementList.size()) {
                    Element elementElem;
                    Object data;
                    Object obj = elementList.get(k);
                    if (obj instanceof ReferenceDataFormatElement) {
                        data = (ReferenceDataFormatElement)obj;
                        elementElem = doc.createElement("element");
                        formatElem.appendChild(elementElem);
                        if (obj instanceof ReferenceDataFormatAuthorsElement) {
                            elementElem.setAttribute("class", "ReferenceDataFormatAuthorsElement");
                        } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                            elementElem.setAttribute("class", "ReferenceDataFormatIdentifiersElement");
                        } else {
                            elementElem.setAttribute("class", "ReferenceDataFormatElement");
                        }
                        elementElem.setAttribute("name", ((ReferenceDataFormatElement)data).toString());
                        elementElem.setAttribute("bold", String.valueOf(((ReferenceDataFormatElement)data).getBold()));
                        elementElem.setAttribute("italic", String.valueOf(((ReferenceDataFormatElement)data).getItalic()));
                        elementElem.setAttribute("underline", String.valueOf(((ReferenceDataFormatElement)data).getUnderline()));
                        if (obj instanceof ReferenceDataFormatAuthorsElement) {
                            Element elem = doc.createElement("firstauthor");
                            String str = ((ReferenceDataFormatAuthorsElement)obj).getFirstAuthor();
                            elem.appendChild(doc.createTextNode(str));
                            elementElem.appendChild(elem);
                            elem = doc.createElement("connectionstring");
                            str = ((ReferenceDataFormatAuthorsElement)obj).getConnectionString();
                            elem.appendChild(doc.createTextNode(str));
                            elementElem.appendChild(elem);
                            elem = doc.createElement("secondauthor");
                            str = ((ReferenceDataFormatAuthorsElement)obj).getSecondAuthor();
                            elem.appendChild(doc.createTextNode(str));
                            elementElem.appendChild(elem);
                            elem = doc.createElement("connectionlaststring");
                            str = ((ReferenceDataFormatAuthorsElement)obj).getConnectionLastString();
                            elem.appendChild(doc.createTextNode(str));
                            elementElem.appendChild(elem);
                            elem = doc.createElement("lastauthor");
                            str = ((ReferenceDataFormatAuthorsElement)obj).getLastAuthor();
                            elem.appendChild(doc.createTextNode(str));
                            elementElem.appendChild(elem);
                        } else if (obj instanceof ReferenceDataFormatIdentifiersElement) {
                            String identifier = ((ReferenceDataFormatIdentifiersElement)obj).getIdentifier();
                            elementElem.setAttribute("identifier", identifier);
                        }
                    } else if (obj instanceof ReferenceDataFormatEscapeSequenceElement) {
                        Element elementElem2 = doc.createElement("item");
                        formatElem.appendChild(elementElem2);
                        elementElem2.setAttribute("class", "ReferenceDataFormatEscapeSequenceElement");
                        String escapesequence = ((ReferenceDataFormatEscapeSequenceElement)obj).getEscapeSequence();
                        elementElem2.setAttribute("escapesequence", escapesequence);
                    } else if (obj instanceof String) {
                        data = (String)obj;
                        elementElem = doc.createElement("item");
                        formatElem.appendChild(elementElem);
                        elementElem.setAttribute("class", "String");
                        elementElem.setAttribute("name", (String)data);
                    }
                    ++k;
                }
                ++j;
            }
        }
        catch (Exception exception) {
            doc = null;
        }
        return doc;
    }

    private void readDoc(ReferenceDataFormatList referenceDataFormatList) {
        ArrayList<ReferenceDataFormat> formatList;
        String xpath = "/referencedataformat[@typeid='" + DomImpl.getID((Document)referenceDataFormatList.getTypeDoc()) + "']";
        System.out.println("xpath = " + xpath);
        Request req = new Request(4, (Object)xpath, "exportmappingdata");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)req);
        System.out.println("Result size = " + docs.size());
        if (docs.size() > 0) {
            Document doc = (Document)docs.get(0);
            Element rootElem = doc.getDocumentElement();
            String selectString = rootElem.getAttribute("select");
            if (selectString == null || selectString.length() == 0) {
                selectString = "0";
            }
            referenceDataFormatList.setFormatListIndex(Integer.valueOf(selectString));
            Node formatNode = rootElem.getFirstChild();
            while (formatNode != null) {
                if (formatNode.getNodeType() == 1) {
                    ReferenceDataFormat format = new ReferenceDataFormat(((Element)formatNode).getAttribute("formatname"));
                    referenceDataFormatList.addFormatData(format);
                    format.setFontname(((Element)formatNode).getAttribute("fontname"));
                    String fontsize = ((Element)formatNode).getAttribute("fontsize");
                    format.setFontSize(Integer.valueOf(fontsize));
                    Node elementNode = formatNode.getFirstChild();
                    while (elementNode != null) {
                        if (elementNode.getNodeType() == 1) {
                            String name;
                            String classname = ((Element)elementNode).getAttribute("class");
                            if (classname.equalsIgnoreCase("ReferenceDataFormatElement")) {
                                name = ((Element)elementNode).getAttribute("name");
                                ReferenceDataFormatElement referenceDataFormatElement = new ReferenceDataFormatElement(name);
                                format.addElement(referenceDataFormatElement);
                                referenceDataFormatElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                referenceDataFormatElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                referenceDataFormatElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                            } else if (classname.startsWith("ReferenceDataFormatAuthorsElement")) {
                                name = ((Element)elementNode).getAttribute("name");
                                ReferenceDataFormatAuthorsElement referenceDataFormatAuthorsElement = new ReferenceDataFormatAuthorsElement(name);
                                format.addElement(referenceDataFormatAuthorsElement);
                                referenceDataFormatAuthorsElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                referenceDataFormatAuthorsElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                referenceDataFormatAuthorsElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                                Node node = elementNode.getFirstChild();
                                while (node != null) {
                                    if (node.getNodeType() == 1) {
                                        Node textnode;
                                        String buf;
                                        if (node.getNodeName().equals("firstauthor")) {
                                            buf = "";
                                            textnode = node.getFirstChild();
                                            while (textnode != null) {
                                                if (textnode.getNodeType() == 3) {
                                                    buf = String.valueOf(buf) + textnode.getNodeValue();
                                                }
                                                textnode = textnode.getNextSibling();
                                            }
                                            referenceDataFormatAuthorsElement.setFirstAuthor(buf);
                                        } else if (node.getNodeName().equals("secondauthor")) {
                                            buf = "";
                                            textnode = node.getFirstChild();
                                            while (textnode != null) {
                                                if (textnode.getNodeType() == 3) {
                                                    buf = String.valueOf(buf) + textnode.getNodeValue();
                                                }
                                                textnode = textnode.getNextSibling();
                                            }
                                            referenceDataFormatAuthorsElement.setSecondAuthor(buf);
                                        } else if (node.getNodeName().equals("lastauthor")) {
                                            buf = "";
                                            textnode = node.getFirstChild();
                                            while (textnode != null) {
                                                if (textnode.getNodeType() == 3) {
                                                    buf = String.valueOf(buf) + textnode.getNodeValue();
                                                }
                                                textnode = textnode.getNextSibling();
                                            }
                                            referenceDataFormatAuthorsElement.setLastAuthor(buf);
                                        } else if (node.getNodeName().equals("connectionstring")) {
                                            buf = "";
                                            textnode = node.getFirstChild();
                                            while (textnode != null) {
                                                if (textnode.getNodeType() == 3) {
                                                    buf = String.valueOf(buf) + textnode.getNodeValue();
                                                }
                                                textnode = textnode.getNextSibling();
                                            }
                                            referenceDataFormatAuthorsElement.setConnectionString(buf);
                                        } else if (node.getNodeName().equals("connectionlaststring")) {
                                            buf = "";
                                            textnode = node.getFirstChild();
                                            while (textnode != null) {
                                                if (textnode.getNodeType() == 3) {
                                                    buf = String.valueOf(buf) + textnode.getNodeValue();
                                                }
                                                textnode = textnode.getNextSibling();
                                            }
                                            referenceDataFormatAuthorsElement.setConnectionLastString(buf);
                                        }
                                    }
                                    node = node.getNextSibling();
                                }
                            } else if (classname.startsWith("ReferenceDataFormatIdentifiersElement")) {
                                name = ((Element)elementNode).getAttribute("name");
                                ReferenceDataFormatIdentifiersElement referenceDataFormatIdentifiersElement = new ReferenceDataFormatIdentifiersElement(name);
                                format.addElement(referenceDataFormatIdentifiersElement);
                                referenceDataFormatIdentifiersElement.setBold(((Element)elementNode).getAttribute("bold").equals("true"));
                                referenceDataFormatIdentifiersElement.setItalic(((Element)elementNode).getAttribute("italic").equals("true"));
                                referenceDataFormatIdentifiersElement.setUnderline(((Element)elementNode).getAttribute("underline").equals("true"));
                                String identifier = ((Element)elementNode).getAttribute("identifier");
                                referenceDataFormatIdentifiersElement.setIdentifier(identifier);
                            } else if (classname.startsWith("ReferenceDataFormatEscapeSequenceElement")) {
                                String escapesequence = ((Element)elementNode).getAttribute("escapesequence");
                                ReferenceDataFormatEscapeSequenceElement referenceDataFormatEscapeSequenceElement = new ReferenceDataFormatEscapeSequenceElement(escapesequence);
                                format.addElement(referenceDataFormatEscapeSequenceElement);
                            } else if (classname.equalsIgnoreCase("String")) {
                                name = ((Element)elementNode).getAttribute("name");
                                format.addElement(new String(name));
                            }
                        }
                        elementNode = elementNode.getNextSibling();
                    }
                }
                formatNode = formatNode.getNextSibling();
            }
        }
        if ((formatList = referenceDataFormatList.getFormatList()).size() == 0) {
            ReferenceDataFormat format = ReferenceDataFormatList.newReferenceDataFormat("Default", referenceDataFormatList.getTypeDoc());
            referenceDataFormatList.addFormatData(format);
            referenceDataFormatList.setFormatListIndex(format);
        }
    }

    private Font newFont(Device device, String name, int height, int styl) {
        Font font = new Font(device, name, height, styl);
        FontData fd = font.getFontData()[0];
        if (this.fontReg.hasValueFor(fd.toString())) {
            font.dispose();
            font = this.fontReg.get(fd.toString());
        } else {
            this.fontReg.put(fd.toString(), font.getFontData());
        }
        return font;
    }

    class DatasetComboViewLabelProvider
    extends LabelProvider {
        DatasetComboViewLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ReferenceDataFormat) {
                ReferenceDataFormat format = (ReferenceDataFormat)element;
                return format.getName();
            }
            return element.toString();
        }
    }

    private class DragFormatItemTableAdapter
    extends DragSourceAdapter {
        private boolean isTableDrop = false;

        private DragFormatItemTableAdapter() {
        }

        public void dragSetData(DragSourceEvent e) {
            if (ReferenceDataFormatElementTransfer.getInstance().isSupportedType(e.dataType)) {
                if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex != -1) {
                    System.out.println("Drag:" + CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                    Integer integer = new Integer(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                    e.data = integer;
                }
            } else if (TextTransfer.getInstance().isSupportedType(e.dataType)) {
                Object cont = CustomizeReferenceFormatPreferencePage.this.getFormatElementListFromTableViewer().get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                if (cont instanceof String) {
                    e.data = (String)cont;
                } else if (cont instanceof ReferenceDataFormatElement) {
                    e.data = ((ReferenceDataFormatElement)cont).toString();
                }
            }
            this.isTableDrop = true;
        }

        public void dragStart(DragSourceEvent e) {
            this.isTableDrop = false;
        }

        public void dragFinished(DragSourceEvent e) {
            if (!this.isTableDrop) {
                CustomizeReferenceFormatPreferencePage.this.deleteElementAction.run();
            }
        }
    }

    private class DropFormatItemTableAdapter
    extends DropTargetAdapter {
        private DropFormatItemTableAdapter() {
        }

        public void drop(DropTargetEvent e) {
            TableItem ti;
            if (ReferenceDataFormatElementTransfer.getInstance().isSupportedType(e.currentDataType)) {
                TableItem ti2 = CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getItem(0);
                if (ti2 != null) {
                    Point mousePt = new Point(e.x, e.y);
                    Integer integer = (Integer)e.data;
                    if (integer != null) {
                        Point pt;
                        int dragIndex = integer;
                        System.out.println("Drag::" + dragIndex);
                        ArrayList al = (ArrayList)ti2.getData();
                        int i = 0;
                        while (i < CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount()) {
                            Rectangle rect = ti2.getBounds(i);
                            pt = ti2.getParent().toDisplay(rect.x, rect.y);
                            rect.x = pt.x;
                            rect.y = pt.y;
                            if (rect.x <= mousePt.x && mousePt.x <= rect.x + rect.width) {
                                if (dragIndex != i) {
                                    if (dragIndex >= 0 && dragIndex < al.size()) {
                                        Object dragObj = al.get(dragIndex);
                                        if (dragIndex < i) {
                                            int dropIndex = i;
                                            Font dragFont = ti2.getFont(dragIndex);
                                            ti2.setFont(dragIndex, null);
                                            al.remove(dragIndex);
                                            al.add(dropIndex, dragObj);
                                            int j = dragIndex + 1;
                                            while (j <= dropIndex) {
                                                Font j1Font = ti2.getFont(j);
                                                ti2.setFont(j - 1, j1Font);
                                                ++j;
                                            }
                                            ti2.setFont(dropIndex, dragFont);
                                            CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = dropIndex;
                                        } else if (i < dragIndex) {
                                            int dropIndex = i;
                                            Font dragFont = ti2.getFont(dragIndex);
                                            ti2.setFont(dragIndex, null);
                                            al.remove(dragIndex);
                                            al.add(dropIndex, dragObj);
                                            Font iFont = ti2.getFont(i);
                                            int j = dropIndex + 1;
                                            while (j <= dragIndex) {
                                                Font i1Font = ti2.getFont(j);
                                                ti2.setFont(j, iFont);
                                                iFont = i1Font;
                                                ++j;
                                            }
                                            ti2.setFont(dropIndex, dragFont);
                                            CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = dropIndex;
                                        }
                                    } else {
                                        Object dragObj = null;
                                        al.add(i, dragObj);
                                        new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                                        CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = i;
                                    }
                                    CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                                    CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                                }
                                return;
                            }
                            ++i;
                        }
                        Rectangle rect = new Rectangle(0, 0, 0, 0);
                        if (CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount() > 0) {
                            rect = ti2.getBounds(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount() - 1);
                        }
                        pt = ti2.getParent().toDisplay(rect.x + rect.width, rect.y + rect.height);
                        int x = pt.x;
                        Rectangle area = ti2.getParent().getClientArea();
                        pt = ti2.getParent().toDisplay(area.x + area.width, area.y + area.height);
                        int width = pt.x - x;
                        if (x <= mousePt.x && mousePt.x <= x + width) {
                            if (dragIndex != al.size() - 1) {
                                if (dragIndex >= 0 && dragIndex < al.size()) {
                                    int dropIndex = al.size() - 1;
                                    Font dragFont = ti2.getFont(dragIndex);
                                    ti2.setFont(dragIndex, dragFont);
                                    Object dragObj = al.get(dragIndex);
                                    al.add(dragObj);
                                    al.remove(dragIndex);
                                    int j = dragIndex + 1;
                                    while (j <= dropIndex) {
                                        Font j1Font = ti2.getFont(j);
                                        ti2.setFont(j - 1, j1Font);
                                        ++j;
                                    }
                                    ti2.setFont(dropIndex, dragFont);
                                    CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = dropIndex;
                                } else {
                                    Object dragObj = null;
                                    al.add(dragObj);
                                    new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                                    CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = al.size() - 1;
                                }
                                CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                                CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                            }
                            return;
                        }
                    }
                }
            } else if (TextTransfer.getInstance().isSupportedType(e.currentDataType) && (ti = (TableItem)e.item) != null) {
                Point mousePt = new Point(e.x, e.y);
                ArrayList al = (ArrayList)ti.getData();
                int i = 0;
                while (i < CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount()) {
                    Rectangle rect = ti.getBounds(i);
                    Point pt = ti.getParent().toDisplay(rect.x, rect.y);
                    rect.x = pt.x;
                    rect.y = pt.y;
                    if (rect.x <= mousePt.x && mousePt.x <= rect.x + rect.width) {
                        if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex != i) {
                            Object dragObj = al.get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                            if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < i) {
                                al.remove(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                                al.add(i, dragObj);
                                CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = i;
                            } else if (i < CustomizeReferenceFormatPreferencePage.this.elementSelectIndex) {
                                al.remove(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                                al.add(i, dragObj);
                                CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = i;
                            }
                            CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                            CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                        }
                        return;
                    }
                    ++i;
                }
                Rectangle rect = new Rectangle(0, 0, 0, 0);
                if (CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount() > 0) {
                    rect = ti.getBounds(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable().getColumnCount() - 1);
                }
                Point pt = ti.getParent().toDisplay(rect.x + rect.width, rect.y + rect.height);
                int x = pt.x;
                Rectangle area = ti.getParent().getClientArea();
                pt = ti.getParent().toDisplay(area.x + area.width, area.y + area.height);
                int width = pt.x - x;
                if (x <= mousePt.x && mousePt.x <= x + width) {
                    if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex != al.size() - 1) {
                        if (CustomizeReferenceFormatPreferencePage.this.elementSelectIndex >= 0 && CustomizeReferenceFormatPreferencePage.this.elementSelectIndex < al.size()) {
                            Object dragObj = al.get(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                            al.add(dragObj);
                            al.remove(CustomizeReferenceFormatPreferencePage.this.elementSelectIndex);
                            CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = al.size() - 1;
                        } else {
                            Object dragObj = null;
                            al.add(dragObj);
                            new TableColumn(CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.getTable(), 0x1000000);
                            CustomizeReferenceFormatPreferencePage.this.elementSelectIndex = al.size() - 1;
                        }
                        CustomizeReferenceFormatPreferencePage.this.setColumnWidthOnFormatEditTableViewer();
                        CustomizeReferenceFormatPreferencePage.this.formatEditTableViewer.refresh();
                    }
                    return;
                }
            }
        }

        public void dragOver(DropTargetEvent e) {
            e.feedback |= 8;
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITableColorProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            ArrayList al;
            if (obj instanceof ReferenceDataFormatList) {
                ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)obj;
                if (index == 0) {
                    return referenceDataFormatList.getTypeName();
                }
            } else if (obj instanceof ReferenceDataFormat) {
                ReferenceDataFormat format = (ReferenceDataFormat)obj;
                if (index == 0) {
                    return format.getName();
                }
            } else if (obj instanceof ReferenceDataFormatElement) {
                ReferenceDataFormatElement foit = (ReferenceDataFormatElement)obj;
                if (index == 0) {
                    return foit.toString();
                }
            } else if (obj instanceof ArrayList && (al = (ArrayList)obj).size() > 0) {
                Object cont = al.get(index);
                if (cont instanceof String) {
                    return (String)cont;
                }
                if (cont instanceof ReferenceDataFormatElement) {
                    return ((ReferenceDataFormatElement)cont).getViewString();
                }
                if (cont instanceof ReferenceDataFormatEscapeSequenceElement) {
                    return ((ReferenceDataFormatEscapeSequenceElement)cont).getViewString();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            if (obj instanceof ReferenceDataFormatList) {
                ReferenceDataFormatList referenceDataFormatList = (ReferenceDataFormatList)obj;
                if (index == 0) {
                    return TypeDomImpl.getImage((Document)referenceDataFormatList.getTypeDoc(), (Device)CustomizeReferenceFormatPreferencePage.this._parent.getShell().getDisplay());
                }
            }
            return null;
        }

        public Image getImage(Object obj) {
            return null;
        }

        public Color getBackground(Object element, int columnIndex) {
            return null;
        }

        public Color getForeground(Object element, int columnIndex) {
            return null;
        }
    }
}

