/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.exportreference.preferences.customize;

import java.util.ArrayList;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormat;
import jp.sourceforge.concierge.plugin.customize.ReferenceDataFormatList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.w3c.dom.Document;

public class EditDatasetListDialog
extends Dialog {
    private TableViewer datasetTableView = null;
    private ArrayList<ReferenceDataFormat> formatList = new ArrayList();
    Document typeDoc = null;

    public EditDatasetListDialog(Shell parentShell, ArrayList<ReferenceDataFormat> al, Document typeDoc) {
        super(parentShell);
        if (al != null) {
            this.formatList.addAll(al);
        }
        this.typeDoc = typeDoc;
    }

    protected Point getInitialSize() {
        return new Point(480, 320);
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText("Edit Data Set");
        parent.setLayout((Layout)new GridLayout(1, false));
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Composite upperComposite = new Composite(composite, 0);
        upperComposite.setLayout((Layout)new GridLayout(2, false));
        upperComposite.setLayoutData((Object)new GridData(1808));
        this.datasetTableView = new TableViewer(upperComposite, 66308);
        this.datasetTableView.getTable().setLayoutData((Object)new GridData(1808));
        this.datasetTableView.setContentProvider((IContentProvider)new DatasetTableViewContentProvider());
        this.datasetTableView.setLabelProvider((IBaseLabelProvider)new DatasetTableViewLabelProvider());
        this.datasetTableView.getTable().setLinesVisible(true);
        this.datasetTableView.getTable().setHeaderVisible(true);
        TableColumn tc1 = new TableColumn(this.datasetTableView.getTable(), 16384, 0);
        tc1.setText("Name");
        this.datasetTableView.getControl().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Table table = (Table)e.getSource();
                Rectangle r = table.getClientArea();
                TableColumn[] col = table.getColumns();
                if (col.length == 1) {
                    col[0].setWidth(r.width);
                }
            }
        });
        this.datasetTableView.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
            }
        });
        this.datasetTableView.setInput(this.formatList);
        Composite actionComposite = new Composite(upperComposite, 0);
        actionComposite.setLayout((Layout)new GridLayout(1, false));
        actionComposite.setLayoutData((Object)new GridData(1040));
        Button newButton = new Button(actionComposite, 0);
        newButton.setText("New");
        newButton.setLayoutData((Object)new GridData(768));
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button button = (Button)e.getSource();
                InputDialog dlg = new InputDialog(button.getShell(), "Input Format Name", "Format Name:", "", new IInputValidator(){

                    public String isValid(String newText) {
                        if (newText.length() == 0) {
                            return "Please input Format Name.";
                        }
                        return null;
                    }
                });
                if (dlg.open() == 0) {
                    ReferenceDataFormat data = ReferenceDataFormatList.newReferenceDataFormat(dlg.getValue(), EditDatasetListDialog.this.typeDoc);
                    EditDatasetListDialog.this.formatList.add(data);
                    EditDatasetListDialog.this.datasetTableView.refresh();
                }
            }
        });
        Button delButton = new Button(actionComposite, 0);
        delButton.setText("Delete");
        delButton.setLayoutData((Object)new GridData(768));
        delButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)EditDatasetListDialog.this.datasetTableView.getSelection();
                if (selection == null) {
                    return;
                }
                Object obj = selection.getFirstElement();
                if (obj != null && obj instanceof ReferenceDataFormat) {
                    ReferenceDataFormat data = (ReferenceDataFormat)obj;
                    EditDatasetListDialog.this.formatList.remove(data);
                    EditDatasetListDialog.this.datasetTableView.refresh();
                }
            }
        });
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void buttonPressed(int buttonId) {
        this.setReturnCode(buttonId);
        this.close();
        super.buttonPressed(buttonId);
    }

    public ArrayList<ReferenceDataFormat> getFormatList() {
        return this.formatList;
    }

    class DatasetTableViewContentProvider
    implements IStructuredContentProvider {
        DatasetTableViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public Object[] getElements(Object parent) {
            return ((ArrayList)parent).toArray();
        }
    }

    class DatasetTableViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        DatasetTableViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            if (obj instanceof ReferenceDataFormat) {
                ReferenceDataFormat data = (ReferenceDataFormat)obj;
                if (index == 0) {
                    return data.getName();
                }
            }
            return null;
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

