/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEventKey;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ImageList;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ToolBar
extends Composite {
    ToolItem lastFocus;
    ImageList imageList;

    public ToolBar(Composite parent, int style) {
        super(parent, ToolBar.checkStyle(style));
        this.style = (style & 0x200) != 0 ? (this.style |= 0x200) : (this.style |= 0x100);
        int orientation = (style & 0x200) != 0 ? 1 : 0;
        OS.gtk_toolbar_set_orientation(this.handle, orientation);
    }

    static int checkStyle(int style) {
        if ((style & 0x40) != 0) {
            style &= 0xFFFFFFBF;
        }
        return style & 0xFFFFFCFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    void createHandle(int index) {
        this.state |= 0x10008;
        this.fixedHandle = OS.g_object_new(this.display.gtk_fixed_get_type(), 0L);
        if (this.fixedHandle == 0L) {
            this.error(2);
        }
        OS.gtk_fixed_set_has_window(this.fixedHandle, true);
        this.handle = OS.gtk_toolbar_new();
        if (this.handle == 0L) {
            this.error(2);
        }
        OS.gtk_container_add(this.fixedHandle, this.handle);
        if ((this.style & 0x800000) != 0) {
            byte[] swt_toolbar_flat = Converter.wcsToMbcs(null, "swt-toolbar-flat", true);
            OS.gtk_widget_set_name(this.handle, swt_toolbar_flat);
        }
    }

    @Override
    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        if (wHint != -1 && wHint < 0) {
            wHint = 0;
        }
        if (hHint != -1 && hHint < 0) {
            hHint = 0;
        }
        return this.computeNativeSize(this.handle, wHint, hHint, changed);
    }

    @Override
    long eventHandle() {
        return this.fixedHandle;
    }

    @Override
    long enterExitHandle() {
        return this.handle;
    }

    @Override
    void fixChildren(Shell newShell, Shell oldShell, Decorations newDecorations, Decorations oldDecorations, Menu[] menus) {
        super.fixChildren(newShell, oldShell, newDecorations, oldDecorations, menus);
        ToolItem[] items = this.getItems();
        if (this.toolTipText == null) {
            int i = 0;
            while (i < items.length) {
                ToolItem item = items[i];
                if (item.toolTipText != null) {
                    item.setToolTipText(oldShell, null);
                    item.setToolTipText(newShell, item.toolTipText);
                }
                ++i;
            }
        }
    }

    @Override
    boolean forceFocus(long focusHandle) {
        if (this.lastFocus != null && this.lastFocus.setFocus()) {
            return true;
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.setFocus()) {
                return true;
            }
            ++i;
        }
        return super.forceFocus(focusHandle);
    }

    public ToolItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.getItemCount()) {
            this.error(6);
        }
        return this.getItems()[index];
    }

    public ToolItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getBounds().contains(point)) {
                return items[i];
            }
            ++i;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return 0;
        }
        int itemCount = OS.g_list_length(list);
        OS.g_list_free(list);
        return itemCount;
    }

    public ToolItem[] getItems() {
        this.checkWidget();
        long list = OS.gtk_container_get_children(this.handle);
        if (list == 0L) {
            return new ToolItem[0];
        }
        int count = OS.g_list_length(list);
        ToolItem[] result = new ToolItem[count];
        int i = 0;
        while (i < count) {
            long data = OS.g_list_nth_data(list, i);
            Widget widget = this.display.getWidget(data);
            result[i] = (ToolItem)widget;
            ++i;
        }
        OS.g_list_free(list);
        return result;
    }

    public int getRowCount() {
        this.checkWidget();
        return 1;
    }

    @Override
    long gtk_key_press_event(long widget, long eventPtr) {
        if (!this.hasFocus()) {
            return 0L;
        }
        long result = super.gtk_key_press_event(widget, eventPtr);
        if (result != 0L) {
            return result;
        }
        ToolItem[] items = this.getItems();
        int length = items.length;
        int index = 0;
        while (index < length) {
            if (items[index].hasFocus()) break;
            ++index;
        }
        GdkEventKey gdkEvent = new GdkEventKey();
        OS.memmove(gdkEvent, eventPtr, (long)GdkEventKey.sizeof);
        boolean next = false;
        switch (gdkEvent.keyval) {
            case 65361: 
            case 65362: {
                next = false;
                break;
            }
            case 65364: {
                if (index >= 0 && index < length) {
                    ToolItem item = items[index];
                    if ((item.style & 4) != 0) {
                        Event event = new Event();
                        event.detail = 4;
                        long topHandle = item.topHandle();
                        event.x = OS.GTK_WIDGET_X(topHandle);
                        event.y = OS.GTK_WIDGET_Y(topHandle) + OS.GTK_WIDGET_HEIGHT(topHandle);
                        if ((this.style & 0x8000000) != 0) {
                            event.x = this.getClientWidth() - OS.GTK_WIDGET_WIDTH(topHandle) - event.x;
                        }
                        item.postEvent(13, event);
                        return result;
                    }
                }
            }
            case 65363: {
                next = true;
                break;
            }
            default: {
                return result;
            }
        }
        if ((this.style & 0x8000000) != 0) {
            next = !next;
        }
        int start = index;
        int offset = next ? 1 : -1;
        while ((index = (index + offset + length) % length) != start) {
            ToolItem item = items[index];
            if (!item.setFocus()) continue;
            return result;
        }
        return result;
    }

    @Override
    boolean hasFocus() {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.hasFocus()) {
                return true;
            }
            ++i;
        }
        return super.hasFocus();
    }

    public int indexOf(ToolItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            if (item == items[i]) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    boolean mnemonicHit(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicHit(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    boolean mnemonicMatch(char key) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            long labelHandle = items[i].labelHandle;
            if (labelHandle != 0L && this.mnemonicMatch(labelHandle, key)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void relayout() {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null) {
                item.resizeControl();
            }
            ++i;
        }
    }

    @Override
    void releaseChildren(boolean destroy) {
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        if (this.imageList != null) {
            this.imageList.dispose();
        }
        this.imageList = null;
    }

    @Override
    void removeControl(Control control) {
        super.removeControl(control);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            ToolItem item = items[i];
            if (item.control == control) {
                item.setControl(null);
            }
            ++i;
        }
    }

    @Override
    int setBounds(int x, int y, int width, int height, boolean move, boolean resize) {
        int result = super.setBounds(x, y, width, height, move, resize);
        if ((result & 0x100) != 0) {
            this.relayout();
        }
        return result;
    }

    @Override
    void setFontDescription(long font) {
        super.setFontDescription(font);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setFontDescription(font);
            ++i;
        }
        this.relayout();
    }

    @Override
    void setForegroundColor(GdkColor color) {
        super.setForegroundColor(color);
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            items[i].setForegroundColor(color);
            ++i;
        }
    }

    @Override
    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        Shell shell = this._getShell();
        ToolItem[] items = this.getItems();
        int i = 0;
        while (i < items.length) {
            String newString = string != null ? null : items[i].toolTipText;
            shell.setToolTipText(items[i].handle, newString);
            ++i;
        }
    }
}

