/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.databinding.observable.IStaleListener;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.IValueChangeListener;
import org.eclipse.core.internal.databinding.BindingMessages;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public final class AggregateValidationStatus
implements IObservableValue {
    private IObservableValue implementation;
    public static final int MERGED = 1;
    public static final int MAX_SEVERITY = 2;

    public AggregateValidationStatus(DataBindingContext dbc, int strategy) {
        this(dbc.getValidationRealm(), dbc.getValidationStatusProviders(), strategy);
    }

    public AggregateValidationStatus(IObservableCollection validationStatusProviders, int strategy) {
        this(Realm.getDefault(), validationStatusProviders, strategy);
    }

    public AggregateValidationStatus(Realm realm, final IObservableCollection validationStatusProviders, int strategy) {
        this.implementation = strategy == 1 ? new ComputedValue(realm, IStatus.class){

            @Override
            protected Object calculate() {
                return AggregateValidationStatus.getStatusMerged(validationStatusProviders);
            }
        } : new ComputedValue(realm, IStatus.class){

            @Override
            protected Object calculate() {
                return AggregateValidationStatus.getStatusMaxSeverity(validationStatusProviders);
            }
        };
    }

    @Override
    public void addChangeListener(IChangeListener listener) {
        this.implementation.addChangeListener(listener);
    }

    @Override
    public void addStaleListener(IStaleListener listener) {
        this.implementation.addStaleListener(listener);
    }

    @Override
    public void addValueChangeListener(IValueChangeListener listener) {
        this.implementation.addValueChangeListener(listener);
    }

    @Override
    public void dispose() {
        this.implementation.dispose();
    }

    @Override
    public Realm getRealm() {
        return this.implementation.getRealm();
    }

    @Override
    public Object getValue() {
        return this.implementation.getValue();
    }

    @Override
    public Object getValueType() {
        return this.implementation.getValueType();
    }

    @Override
    public boolean isStale() {
        return this.implementation.isStale();
    }

    @Override
    public void removeChangeListener(IChangeListener listener) {
        this.implementation.removeChangeListener(listener);
    }

    @Override
    public void removeStaleListener(IStaleListener listener) {
        this.implementation.removeStaleListener(listener);
    }

    @Override
    public void removeValueChangeListener(IValueChangeListener listener) {
        this.implementation.removeValueChangeListener(listener);
    }

    @Override
    public void setValue(Object value) {
        this.implementation.setValue(value);
    }

    public static IStatus getStatusMerged(Collection validationStatusProviders) {
        ArrayList<IStatus> statuses = new ArrayList<IStatus>();
        for (ValidationStatusProvider validationStatusProvider : validationStatusProviders) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.isOK()) continue;
            statuses.add(status);
        }
        if (statuses.size() == 1) {
            return (IStatus)statuses.get(0);
        }
        if (!statuses.isEmpty()) {
            MultiStatus result = new MultiStatus("org.eclipse.core.databinding", 0, BindingMessages.getString("MultipleProblems"), null);
            for (IStatus status : statuses) {
                result.merge(status);
            }
            return result;
        }
        return Status.OK_STATUS;
    }

    public static IStatus getStatusMaxSeverity(Collection validationStatusProviders) {
        int maxSeverity = 0;
        IStatus maxStatus = Status.OK_STATUS;
        for (ValidationStatusProvider validationStatusProvider : validationStatusProviders) {
            IStatus status = (IStatus)validationStatusProvider.getValidationStatus().getValue();
            if (status.getSeverity() <= maxSeverity) continue;
            maxSeverity = status.getSeverity();
            maxStatus = status;
        }
        return maxStatus;
    }
}

