/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.index;

import java.util.ArrayList;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.AbstractIndexProvider;
import org.eclipse.help.IIndexContribution;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.index.IndexContribution;
import org.eclipse.help.internal.index.IndexFile;
import org.eclipse.help.internal.index.IndexFileParser;

public class IndexFileProvider
extends AbstractIndexProvider {
    public static final String EXTENSION_POINT_ID_INDEX = "org.eclipse.help.index";
    public static final String ELEMENT_NAME_INDEX = "index";
    public static final String ATTRIBUTE_NAME_FILE = "file";

    @Override
    public IIndexContribution[] getIndexContributions(String locale) {
        ArrayList<IndexContribution> contributions = new ArrayList<IndexContribution>();
        IndexFile[] indexFiles = this.getIndexFiles(locale);
        IndexFileParser parser = new IndexFileParser();
        int i = 0;
        while (i < indexFiles.length) {
            try {
                IndexContribution toc = parser.parse(indexFiles[i]);
                contributions.add(toc);
            }
            catch (Throwable t) {
                String msg = "Error reading help keyword index file /\"" + indexFiles[i].getPluginId() + '/' + indexFiles[i].getFile() + "\" (skipping file)";
                HelpPlugin.logError(msg, t);
            }
            ++i;
        }
        return contributions.toArray(new IIndexContribution[contributions.size()]);
    }

    private IndexFile[] getIndexFiles(String locale) {
        ArrayList<IndexFile> indexFiles = new ArrayList<IndexFile>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(EXTENSION_POINT_ID_INDEX);
        int i = 0;
        while (i < elements.length) {
            IConfigurationElement elem = elements[i];
            String pluginId = elem.getContributor().getName();
            if (elem.getName().equals(ELEMENT_NAME_INDEX)) {
                String file = elem.getAttribute(ATTRIBUTE_NAME_FILE);
                IndexFile indexFile = new IndexFile(pluginId, file, locale);
                indexFiles.add(indexFile);
            }
            ++i;
        }
        return indexFiles.toArray(new IndexFile[indexFiles.size()]);
    }
}

