/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.io.File;
import java.util.ArrayList;
import java.util.Calendar;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.EditorManager;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.editor.LabNoteEditorDelegate;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.plugin.LabNotePlugin;
import jp.sourceforge.concierge.plugin.labnote.CalendarItem;
import jp.sourceforge.concierge.plugin.labnote.CalendarTitle;
import jp.sourceforge.concierge.plugin.labnote.CalendarTitleListener;
import jp.sourceforge.concierge.plugin.labnote.Category;
import jp.sourceforge.concierge.plugin.labnote.CategoryChangedEvent;
import jp.sourceforge.concierge.plugin.labnote.CategoryChangedListener;
import jp.sourceforge.concierge.plugin.labnote.CategoryViewer;
import jp.sourceforge.concierge.plugin.labnote.LabNoteDocumentImpl;
import jp.sourceforge.concierge.util.CalendarUtil;
import jp.sourceforge.concierge.util.GraphicUtil;
import jp.sourceforge.concierge.util.Holiday;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.w3c.dom.Document;

public class LabNote
extends ConciergeViewPart {
    private Cursor handcursor;
    private Composite dlistbase;
    private Composite datelist;
    private CategoryViewer category;
    private CalendarTitle dtitle;
    private ImageHyperlink addcatbtn;
    private ImageHyperlink delcatbtn;
    private int caldate;
    private ImageDescriptor addimg = LabNotePlugin.getImageDescriptor("icons/catplus.png");
    private ImageDescriptor delimg = LabNotePlugin.getImageDescriptor("icons/catminus.png");
    private ArrayList<CalendarItem> dateitems = new ArrayList();
    private Holiday holidayCache = new Holiday();
    private LabNoteMenuManager mmanager = null;
    private MouseMoveListener movelistener = null;
    private IPropertyChangeListener propertyChangeListener = null;

    private void setPropertyChangeListener() {
        this.removePropertyChangeListener();
        this.propertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                String key = event.getProperty();
                if (key.equals("lablocale")) {
                    if (event.getOldValue().equals(event.getNewValue())) {
                        return;
                    }
                    LabNote.this.refreshholiday((String)event.getNewValue());
                }
            }
        };
        LabNotePlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    public void removePropertyChangeListener() {
        if (this.propertyChangeListener != null) {
            LabNotePlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
    }

    private void refreshholiday(String newlocale) {
        int cy = this.dtitle.getCurrentYear();
        this.holidayCache.initHolidaysByYear(cy - 5, cy + 5, newlocale);
        int i = 0;
        while (i < this.dateitems.size()) {
            int d;
            int m;
            CalendarItem ci;
            int y = (ci = this.dateitems.get(i)).getYear();
            ci.setHoliday(this.holidayCache.isHoliday(y, m = ci.getMonth(), d = ci.getDay()) || i % 7 == 0);
            ci.setNameOfDay(this.holidayCache.getHolidayName(y, m, d));
            ++i;
        }
    }

    private void setdateitem(int year, int month, int date) {
        ArrayList<Document> docs;
        CalendarItem di;
        int dofw = CalendarUtil.getDayOfWeek((int)year, (int)month, (int)1) - 1;
        int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
        int pyear = year;
        int pmonth = month - 1;
        if (pmonth == 0) {
            pyear = year - 1;
            pmonth = 12;
        }
        int nyear = year;
        int nmonth = month + 1;
        if (nmonth > 12) {
            nyear = year + 1;
            nmonth = 1;
        }
        int pnofd = CalendarUtil.getNumberOfDays((int)pyear, (int)pmonth);
        int i = 0;
        int j = pnofd - dofw + 1;
        while (i < dofw) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(pyear, pmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(pyear, pmonth, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(pyear, pmonth, j));
            di.clearAll();
            docs = LabNotePlugin.getDocuments(pyear, pmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        i = dofw;
        j = 1;
        while (i < dofw + nofd) {
            di = this.dateitems.get(i);
            di.setDate(year, month, j);
            di.setHoliday(this.holidayCache.isHoliday(year, month, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(year, month, j));
            if (j == date) {
                di.select();
            } else {
                di.deselect();
            }
            di.clearAll();
            docs = LabNotePlugin.getDocuments(year, month, j);
            di.setDocuments(docs);
            di.setEnabled(true);
            ++i;
            ++j;
        }
        i = dofw + nofd;
        j = 1;
        while (i < 42) {
            di = this.dateitems.get(i);
            di.deselect();
            di.setDate(nyear, nmonth, j);
            di.setHoliday(this.holidayCache.isHoliday(nyear, nmonth, j) || i % 7 == 0);
            di.setNameOfDay(this.holidayCache.getHolidayName(nyear, nmonth, j));
            di.clearAll();
            docs = LabNotePlugin.getDocuments(nyear, nmonth, j);
            di.setDocuments(docs);
            di.setEnabled(false);
            ++i;
            ++j;
        }
        this.datelist.layout();
    }

    private void resizeCalItem(Control[] calitems, Point parentsize) {
        int nw = (parentsize.x - 1) / 7;
        int nh = (parentsize.y - 1) / 6;
        int x = 0;
        while (x < 7) {
            int y = 0;
            while (y < 6) {
                Composite comp = (Composite)calitems[x + y * 7];
                int px = nw * x + 1;
                int py = nh * y + 1;
                int w = x == 6 ? parentsize.x - nw * 6 - 2 : nw - 1;
                int h = y == 5 ? parentsize.y - nh * 5 - 2 : nh - 1;
                comp.setBounds(px, py, w, h);
                ++y;
            }
            ++x;
        }
    }

    public LabNote() {
        this.setPropertyChangeListener();
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(1, true));
        this.movelistener = new MouseMoveListener(){
            private Point prev = null;

            public void mouseMove(MouseEvent arg0) {
                Rectangle db = LabNote.this.dlistbase.getParent().getBounds();
                Point csz = LabNote.this.dlistbase.computeSize(-1, -1);
                if (db.width > csz.x && db.height > csz.y) {
                    this.prev = null;
                    Point dsz = new Point(db.width, db.height);
                    LabNote.this.dlistbase.setSize(dsz);
                    Control[] chld = LabNote.this.datelist.getChildren();
                    Point sz = LabNote.this.datelist.getSize();
                    LabNote.this.resizeCalItem(chld, sz);
                    return;
                }
                if ((arg0.stateMask & SWT.BUTTON_MASK) == 0) {
                    if (this.prev == null) {
                        return;
                    }
                    this.prev = null;
                    LabNote.this.dlistbase.setSize(db.width > csz.x ? db.width : csz.x, db.height > csz.y ? db.height : csz.y);
                    Control[] chld = LabNote.this.datelist.getChildren();
                    Point sz = LabNote.this.datelist.getSize();
                    LabNote.this.resizeCalItem(chld, sz);
                    LabNote.this.getSite().getShell().setCursor(null);
                    return;
                }
                if (this.prev == null) {
                    this.prev = new Point(arg0.x, arg0.y);
                    LabNote.this.getSite().getShell().setCursor(LabNote.this.handcursor);
                    return;
                }
                Point diff = new Point(arg0.x - this.prev.x, arg0.y - this.prev.y);
                Point dlp = LabNote.this.dlistbase.getLocation();
                diff.x += dlp.x;
                diff.y += dlp.y;
                if (diff.x < db.width - csz.x) {
                    diff.x = db.width - csz.x;
                }
                if (diff.x > 0) {
                    diff.x = 0;
                }
                if (diff.y < db.height - csz.y) {
                    diff.y = db.height - csz.y;
                }
                if (diff.y > 0) {
                    diff.y = 0;
                }
                LabNote.this.dlistbase.setLocation(diff);
            }
        };
        this.handcursor = new Cursor((Device)parent.getDisplay(), 21);
        Composite maincomp = new Composite(parent, 0);
        GridLayout glmn = new GridLayout(1, true);
        glmn.marginHeight = 0;
        glmn.marginWidth = 0;
        glmn.verticalSpacing = 0;
        glmn.horizontalSpacing = 0;
        maincomp.setLayout((Layout)glmn);
        maincomp.setLayoutData((Object)new GridData(1808));
        SashForm sf = new SashForm(maincomp, 65792);
        sf.setLayoutData((Object)new GridData(1808));
        sf.SASH_WIDTH = 2;
        Composite calarea = new Composite((Composite)sf, 2048);
        GridLayout glca = new GridLayout(1, true);
        glca.marginHeight = 0;
        glca.marginWidth = 0;
        glca.verticalSpacing = 0;
        glca.horizontalSpacing = 0;
        calarea.setLayout((Layout)glca);
        GraphicUtil.setBackground((Control)calarea, (int)1);
        Composite harea = new Composite(calarea, 0);
        GridLayout glha = new GridLayout(2, true);
        glha.marginHeight = 0;
        glha.marginWidth = 0;
        glha.verticalSpacing = 0;
        glha.horizontalSpacing = 0;
        harea.setLayout((Layout)glha);
        harea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)harea, (int)1);
        Label label = new Label(harea, 4);
        label.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)label, (int)1);
        label.setText(LabNotePlugin.getString("LabNote.2"));
        Composite cmdarea = new Composite(harea, 0);
        FormLayout flcma = new FormLayout();
        flcma.marginHeight = 0;
        flcma.marginWidth = 0;
        cmdarea.setLayout((Layout)flcma);
        cmdarea.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)cmdarea, (int)1);
        this.delcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData dbfd = new FormData();
        dbfd.right = new FormAttachment(95, 0);
        this.delcatbtn.setLayoutData((Object)dbfd);
        GraphicUtil.setBackground((Control)this.delcatbtn, (int)1);
        this.delcatbtn.setImage(this.delimg.createImage());
        this.delcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                if (!LabNotePlugin.showConfirm(LabNote.this.delcatbtn.getShell(), LabNotePlugin.getString("LabNote.3"))) {
                    return;
                }
                LabNote.this.category.deleteCategory();
                int i = 0;
                while (i < LabNote.this.dateitems.size()) {
                    CalendarItem ci = (CalendarItem)LabNote.this.dateitems.get(i);
                    ci.update();
                    ++i;
                }
            }
        });
        this.addcatbtn = new ImageHyperlink(cmdarea, 0x800000);
        FormData abfd = new FormData();
        abfd.right = new FormAttachment((Control)this.delcatbtn, -5);
        this.addcatbtn.setLayoutData((Object)abfd);
        this.addcatbtn.setImage(this.addimg.createImage());
        GraphicUtil.setBackground((Control)this.addcatbtn, (int)1);
        this.addcatbtn.addHyperlinkListener(new IHyperlinkListener(){

            public void linkEntered(HyperlinkEvent e) {
            }

            public void linkExited(HyperlinkEvent e) {
            }

            public void linkActivated(HyperlinkEvent e) {
                LabNote.this.category.addCategory();
            }
        });
        this.category = new CategoryViewer(calarea);
        this.category.addCheckListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                Category cg = (Category)e.getElement();
                int i = 0;
                while (i < LabNote.this.dateitems.size()) {
                    CalendarItem ci = (CalendarItem)LabNote.this.dateitems.get(i);
                    ci.noteVisibleByCategory(cg.name, e.getChecked());
                    ++i;
                }
            }
        });
        this.category.addCategoryChangedListener(new CategoryChangedListener(){

            @Override
            public void categoryChanged(CategoryChangedEvent e) {
                if (e.type == CategoryChangedEvent.ADD_EVENT) {
                    return;
                }
                ArrayList<Document> upddocs = LabNotePlugin.updateLabNoteDocuments(e.oldname, e.newname);
                if (upddocs == null) {
                    return;
                }
                int i = 0;
                while (i < LabNote.this.dateitems.size()) {
                    CalendarItem ci = (CalendarItem)LabNote.this.dateitems.get(i);
                    ci.update(upddocs);
                    ++i;
                }
            }
        });
        Calendar cd = Calendar.getInstance();
        int calyear = cd.get(1);
        int calmonth = cd.get(2) + 1;
        this.caldate = cd.get(5);
        String locale = LabNotePlugin.getDefault().getPreferenceStore().getString("lablocale");
        this.holidayCache.initHolidaysByYear(calyear - 5, calyear + 5, locale);
        Composite datearea = new Composite((Composite)sf, 2048);
        GraphicUtil.setBackground((Control)datearea, (int)1);
        sf.setWeights(new int[]{25, 75});
        this.dlistbase = new Composite(datearea, 0);
        GridLayout glda = new GridLayout(1, true);
        glda.marginHeight = 10;
        glda.marginWidth = 10;
        glda.verticalSpacing = 0;
        glda.horizontalSpacing = 0;
        this.dlistbase.setLayout((Layout)glda);
        GraphicUtil.setBackground((Control)this.dlistbase, (int)1);
        Composite tt = new Composite(this.dlistbase, 0);
        tt.setLayoutData((Object)new GridData(768));
        GraphicUtil.setBackground((Control)tt, (int)1);
        this.dtitle = new CalendarTitle(tt, calyear, calmonth);
        this.dtitle.setListener(new CalendarTitleListener(){

            @Override
            public void calendarChanged(int year, int month) {
                int nofd = CalendarUtil.getNumberOfDays((int)year, (int)month);
                if (LabNote.this.caldate > nofd) {
                    LabNote.this.caldate = nofd;
                }
                LabNote.this.setdateitem(year, month, LabNote.this.caldate);
            }
        });
        this.dtitle.addMouseMoveListener(this.movelistener);
        this.datelist = new Composite(this.dlistbase, 0);
        GridData dlgd = new GridData(1808);
        dlgd.minimumHeight = 240;
        dlgd.minimumWidth = 490;
        this.datelist.setLayoutData((Object)dlgd);
        GraphicUtil.setBackground((Control)this.datelist, (int)15);
        this.datelist.addMouseMoveListener(this.movelistener);
        datearea.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Point sz = ((Composite)e.widget).getSize();
                LabNote.this.dlistbase.setBounds(new Rectangle(0, 0, sz.x, sz.y));
                Control[] chld = LabNote.this.datelist.getChildren();
                sz = LabNote.this.datelist.getSize();
                LabNote.this.resizeCalItem(chld, sz);
            }
        });
        LabNoteEditorDelegate ed = new LabNoteEditorDelegate();
        ed.setModifyListener(new IEditorEventListener(){

            public void run(EditorEvent e) {
            }
        });
        int i = 0;
        while (i < 42) {
            Composite comp = new Composite(this.datelist, 0);
            comp.addMouseMoveListener(this.movelistener);
            GraphicUtil.setBackground((Control)comp, (int)1);
            CalendarItem di = new CalendarItem(comp, calyear, calmonth, i);
            this.dateitems.add(di);
            di.addMouseMoveListener(this.movelistener);
            di.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    Document doc = LabNoteDocumentImpl.createDocument(di.getYear(), di.getMonth(), di.getDay());
                    EditorManager.openEditor((Document)doc, (boolean)true, (Object)"jp.sourceforge.concierge.plugin.labnote");
                }

                public void mouseDown(MouseEvent e) {
                    int i = 0;
                    while (i < 42) {
                        CalendarItem it = (CalendarItem)LabNote.this.dateitems.get(i);
                        it.deselect();
                        ++i;
                    }
                    CalendarItem c = (CalendarItem)e.data;
                    c.select();
                    Document doc = c.getSelectedNoteDocument();
                    if (doc != null) {
                        if (e.button != 1 || (e.stateMask & 0x40000) != 0 && e.button == 1) {
                            c.showTooltip(false);
                            Control ctrl = c.getSelectedNoteControl();
                            ((LabNote)LabNote.this).mmanager.document = doc;
                            ((LabNote)LabNote.this).mmanager.calitem = c;
                            Menu m = LabNote.this.mmanager.createContextMenu(ctrl);
                            ctrl.setMenu(m);
                        }
                        return;
                    }
                    LabNote.this.caldate = c.getDay();
                    String xpath = LabNotePlugin.getXPath(c.getYear(), c.getMonth(), c.getDay());
                    IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                    try {
                        ConciergeViewPart tabulator = (ConciergeViewPart)page.showView("jp.sourceforge.concierge.plugin.tabulator", "LabNote", 3);
                        if (tabulator == null) {
                            return;
                        }
                        tabulator.setPartProperty("TITLE", "LabNote (" + c.getDay() + "/" + c.getMonth() + "/" + c.getYear() + ")");
                        tabulator.setDocuments(xpath);
                        page.activate((IWorkbenchPart)tabulator);
                    }
                    catch (Exception exception) {
                        return;
                    }
                }
            });
            ++i;
        }
        this.resizeCalItem(this.datelist.getChildren(), this.datelist.getSize());
        this.setdateitem(calyear, calmonth, this.caldate);
        this.hookContextMenu();
        FrameworkPlugin.addDatabaseListener((String)"data", (ICCGUpdateListener)new CCGUpdateThread((Control)maincomp, new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                int i = 0;
                while (i < ev.documents.size()) {
                    Document doc = (Document)ev.documents.get(i);
                    String type = DataDomImpl.getDefaultType((Document)doc);
                    if (type.equals("Note")) {
                        block0 : switch (ev.type) {
                            case DEL_DOCUMENT: {
                                int j = 0;
                                while (j < LabNote.this.dateitems.size()) {
                                    CalendarItem ci = (CalendarItem)LabNote.this.dateitems.get(j);
                                    if (LabNoteDocumentImpl.equalsByDate(doc, ci.getYear(), ci.getMonth(), ci.getDay())) {
                                        ci.deleteNoteItem(doc);
                                        break;
                                    }
                                    ++j;
                                }
                                EditorManager.deleteEditor((Document)doc);
                                String path = DataDomImpl.getFilePath((Document)doc);
                                Document cdoc = DomImpl.loadDocument((String)path);
                                ArrayList<String> imgs = LabNoteDocumentImpl.getAllImagePath(cdoc);
                                LabNotePlugin.removeImageFiles(imgs);
                                new File(path).delete();
                                break;
                            }
                            case ADD_DOCUMENT: {
                                CalendarItem ci;
                                int j = 0;
                                while (j < LabNote.this.dateitems.size()) {
                                    ci = (CalendarItem)LabNote.this.dateitems.get(j);
                                    if (LabNoteDocumentImpl.equalsByDate(doc, ci.getYear(), ci.getMonth(), ci.getDay())) {
                                        ci.createItem(doc, LabNote.this.category.getSelectedCategory());
                                        break block0;
                                    }
                                    ++j;
                                }
                                break;
                            }
                            case UPD_DOCUMENT: {
                                CalendarItem ci;
                                int j = 0;
                                while (j < LabNote.this.dateitems.size()) {
                                    ci = (CalendarItem)LabNote.this.dateitems.get(j);
                                    if (LabNoteDocumentImpl.equalsByDate(doc, ci.getYear(), ci.getMonth(), ci.getDay())) {
                                        ArrayList<Document> ndocs = new ArrayList<Document>();
                                        ndocs.add(doc);
                                        ci.update(ndocs);
                                        break block0;
                                    }
                                    ++j;
                                }
                                break;
                            }
                        }
                    }
                    ++i;
                }
                EditorManager.updateEditor((CCGUpdateEvent)ev);
            }
        }));
        FrameworkPlugin.addDatabaseListener((String)"ccgconfig", (ICCGUpdateListener)new CCGUpdateThread((Control)maincomp, new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                EditorManager.updateEditor((CCGUpdateEvent)ev);
            }
        }));
    }

    private void fillContextMenu(IMenuManager manager) {
        Action openA = new Action(){

            public void run() {
                ((LabNote)LabNote.this).mmanager.calitem.openNoteItem(((LabNote)LabNote.this).mmanager.document);
            }
        };
        openA.setText(LabNotePlugin.getString("LabNote.12"));
        Action deleteA = new Action(){

            public void run() {
                if (!MessageDialog.openConfirm((Shell)LabNote.this.datelist.getShell(), (String)LabNotePlugin.getString("LabNote.13"), (String)LabNotePlugin.getString("LabNote.14"))) {
                    return;
                }
                LabNotePlugin.getDefault().deleteDocument(((LabNote)LabNote.this).mmanager.document, true, null);
            }
        };
        deleteA.setText(LabNotePlugin.getString("LabNote.15"));
        manager.add((IAction)openA);
        manager.add((IAction)deleteA);
    }

    private void hookContextMenu() {
        this.mmanager = new LabNoteMenuManager("#PopupMenu");
        this.mmanager.setRemoveAllWhenShown(true);
        this.mmanager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LabNote.this.fillContextMenu(manager);
            }
        });
    }

    public void setFocus() {
        this.datelist.setFocus();
    }

    public void dispose() {
        if (this.handcursor != null && !this.handcursor.isDisposed()) {
            this.handcursor.dispose();
        }
    }

    private class LabNoteMenuManager
    extends MenuManager {
        public Document document;
        public CalendarItem calitem;

        public LabNoteMenuManager(String id) {
            super(id);
            this.document = null;
            this.calitem = null;
        }
    }
}

