/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import com.ibm.icu.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.Parameterization;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.views.IViewDescriptor;
import org.eclipse.ui.views.IViewRegistry;

public class ShowViewMenu
extends ContributionItem {
    public static final String SHOW_VIEW_ID = "org.eclipse.ui.views.showView";
    public static final String VIEW_ID_PARM = "org.eclipse.ui.views.showView.viewId";
    private static final String PARAMETER_MAKE_FAST = "org.eclipse.ui.views.showView.makeFast";
    private IWorkbenchWindow window;
    private static final String NO_TARGETS_MSG = WorkbenchMessages.Workbench_showInNoTargets;
    private Comparator actionComparator = new Comparator(){

        public int compare(Object o1, Object o2) {
            if (collator == null) {
                ShowViewMenu.collator = Collator.getInstance();
            }
            CommandContributionItemParameter a1 = (CommandContributionItemParameter)o1;
            CommandContributionItemParameter a2 = (CommandContributionItemParameter)o2;
            return collator.compare(a1.label, a2.label);
        }
    };
    private Action showDlgAction;
    private Map actions = new HashMap(21);
    private Map openedViews = new HashMap();
    protected boolean dirty = true;
    private IMenuListener menuListener = new IMenuListener(){

        public void menuAboutToShow(IMenuManager manager) {
            manager.markDirty();
            ShowViewMenu.this.dirty = true;
        }
    };
    private boolean makeFast;
    private static Collator collator;

    public ShowViewMenu(IWorkbenchWindow window, String id) {
        this(window, id, false);
    }

    public ShowViewMenu(IWorkbenchWindow window, String id, boolean makeFast) {
        super(id);
        this.window = window;
        this.makeFast = makeFast;
        final IHandlerService handlerService = (IHandlerService)window.getService(IHandlerService.class);
        ICommandService commandService = (ICommandService)window.getService(ICommandService.class);
        final ParameterizedCommand cmd = this.getCommand(commandService, makeFast);
        this.showDlgAction = new Action(WorkbenchMessages.ShowView_title){

            public void run() {
                try {
                    handlerService.executeCommand(cmd, null);
                }
                catch (ExecutionException executionException) {
                }
                catch (NotDefinedException notDefinedException) {
                }
                catch (NotEnabledException notEnabledException) {
                }
                catch (NotHandledException notHandledException) {}
            }
        };
        window.getWorkbench().getHelpSystem().setHelp((IAction)this.showDlgAction, "org.eclipse.ui.show_view_other_action_context");
        ((WorkbenchWindow)window).addSubmenu(1);
        this.showDlgAction.setActionDefinitionId(SHOW_VIEW_ID);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isDynamic() {
        return true;
    }

    private void fillMenu(IMenuManager innerMgr) {
        innerMgr.removeAll();
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return;
        }
        if (page.getPerspective() == null) {
            return;
        }
        List viewIds = Arrays.asList(page.getShowViewShortcuts());
        viewIds = this.addOpenedViews(page, viewIds);
        ArrayList<CommandContributionItemParameter> actions = new ArrayList<CommandContributionItemParameter>(viewIds.size());
        for (String id : viewIds) {
            CommandContributionItemParameter item;
            if (id.equals("org.eclipse.ui.internal.introview") || (item = this.getItem(id)) == null) continue;
            actions.add(item);
        }
        Collections.sort(actions, this.actionComparator);
        Iterator i = actions.iterator();
        while (i.hasNext()) {
            CommandContributionItem item = new CommandContributionItem((CommandContributionItemParameter)i.next());
            if (WorkbenchActivityHelper.filterItem((Object)item)) {
                item.dispose();
                continue;
            }
            innerMgr.add((IContributionItem)item);
        }
        innerMgr.add((IContributionItem)new Separator());
        innerMgr.add((IAction)this.showDlgAction);
    }

    private CommandContributionItemParameter getItem(String viewId) {
        IViewRegistry reg = WorkbenchPlugin.getDefault().getViewRegistry();
        IViewDescriptor desc = reg.find(viewId);
        if (desc == null) {
            return null;
        }
        String label = desc.getLabel();
        CommandContributionItemParameter parms = new CommandContributionItemParameter(this.window, viewId, SHOW_VIEW_ID, 8);
        parms.label = label;
        parms.icon = desc.getImageDescriptor();
        parms.parameters = new HashMap();
        parms.parameters.put(VIEW_ID_PARM, viewId);
        if (this.makeFast) {
            parms.parameters.put(PARAMETER_MAKE_FAST, "true");
        }
        return parms;
    }

    private List addOpenedViews(IWorkbenchPage page, List actions) {
        Object element;
        ArrayList views = this.getParts(page);
        ArrayList result = new ArrayList(views.size() + actions.size());
        int i = 0;
        while (i < actions.size()) {
            element = actions.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        i = 0;
        while (i < views.size()) {
            element = views.get(i);
            if (result.indexOf(element) < 0) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private ArrayList getParts(IWorkbenchPage page) {
        ArrayList parts = (ArrayList)this.openedViews.get(page);
        if (parts == null) {
            parts = new ArrayList();
            this.openedViews.put(page, parts);
        }
        return parts;
    }

    public void fill(Menu menu, int index) {
        if (this.getParent() instanceof MenuManager) {
            ((MenuManager)this.getParent()).addMenuListener(this.menuListener);
        }
        if (!this.dirty) {
            return;
        }
        MenuManager manager = new MenuManager();
        this.fillMenu((IMenuManager)manager);
        IContributionItem[] items = manager.getItems();
        if (items.length == 0) {
            MenuItem item = new MenuItem(menu, 0, index++);
            item.setText(NO_TARGETS_MSG);
            item.setEnabled(false);
        } else {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
        this.dirty = false;
    }

    protected void removeAction(String viewId) {
        this.actions.remove(viewId);
    }

    private ParameterizedCommand getCommand(ICommandService commandService, boolean makeFast) {
        Command c = commandService.getCommand(SHOW_VIEW_ID);
        Parameterization[] parms = null;
        if (makeFast) {
            try {
                IParameter parmDef = c.getParameter(PARAMETER_MAKE_FAST);
                parms = new Parameterization[]{new Parameterization(parmDef, "true")};
            }
            catch (NotDefinedException notDefinedException) {}
        }
        return new ParameterizedCommand(c, parms);
    }
}

