/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.statushandlers;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.statushandlers.AbstractStatusHandler;
import org.eclipse.ui.statushandlers.StatusAdapter;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.statushandlers.WorkbenchStatusDialogManager;

public class WorkbenchErrorHandler
extends AbstractStatusHandler {
    private WorkbenchStatusDialogManager statusDialog;

    void setStatusDialog(WorkbenchStatusDialogManager dialog) {
        this.statusDialog = dialog;
    }

    @Override
    public void handle(final StatusAdapter statusAdapter, int style) {
        if ((style & 2) == 2 || (style & 4) == 4) {
            boolean modal;
            if (statusAdapter.getStatus().getSeverity() == 0 || statusAdapter.getStatus().getSeverity() == 8) {
                IStatus status = statusAdapter.getStatus();
                statusAdapter.setStatus((IStatus)new Status(1, status.getPlugin(), status.getMessage(), status.getException()));
            }
            boolean bl = modal = (style & 4) == 4;
            if (Display.getCurrent() != null) {
                this.getStatusDialogManager().addStatusAdapter(statusAdapter, modal);
            } else {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!PlatformUI.isWorkbenchRunning()) {
                            WorkbenchPlugin.log(statusAdapter.getStatus());
                            return;
                        }
                        WorkbenchErrorHandler.this.getStatusDialogManager().addStatusAdapter(statusAdapter, modal);
                    }
                });
            }
        }
        if ((style & 1) == 1) {
            StatusManager.getManager().addLoggedStatus(statusAdapter.getStatus());
            WorkbenchPlugin.getDefault().getLog().log(statusAdapter.getStatus());
        }
    }

    private WorkbenchStatusDialogManager getStatusDialogManager() {
        if (this.statusDialog == null) {
            this.initStatusDialogManager();
        }
        return this.statusDialog;
    }

    protected void configureStatusDialog(WorkbenchStatusDialogManager statusDialog) {
    }

    private void initStatusDialogManager() {
        this.statusDialog = new WorkbenchStatusDialogManager(null);
        this.configureStatusDialog(this.statusDialog);
    }
}

