/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.DomImpl;
import jp.sourceforge.concierge.util.XPathString;
import org.w3c.dom.Document;

public class ProjectUtils {
    public static ArrayList<Document> getProjects() {
        String xpath = "/mdata/data[" + XPathString.getAttributeEqualsPredicate((String)"name", (String)"Project") + "]";
        Request r = new Request(4, (Object)xpath, "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
        ArrayList<Document> ndocs = new ArrayList<Document>();
        int i = 0;
        while (i < docs.size()) {
            String p = DataDomImpl.getFilePath((Document)((Document)docs.get(i)));
            File fp = new File(p);
            if (fp.isDirectory()) {
                ndocs.add((Document)docs.get(i));
            }
            ++i;
        }
        Collections.sort(ndocs, new Comparator<Document>(){

            @Override
            public int compare(Document o1, Document o2) {
                String p1 = DataDomImpl.getFileName((Document)o1);
                String p2 = DataDomImpl.getFileName((Document)o2);
                return p1.compareTo(p2);
            }
        });
        return ndocs;
    }

    public static ArrayList<Document> getProjectFiles(Document pdoc) {
        String ppath = DataDomImpl.getFilePath((Document)pdoc);
        String xpath = "/mdata[" + XPathString.getAttributeStartsWithPredicate((String)"filepath", (String)ppath) + "]";
        Request r = new Request(4, (Object)xpath, "data");
        ArrayList docs = FrameworkPlugin.getDocumentsOfQuery((Request)r);
        long pdid = DomImpl.getID((Document)pdoc);
        int i = 0;
        while (i < docs.size()) {
            long did = DomImpl.getID((Document)((Document)docs.get(i)));
            if (did == pdid) {
                docs.remove(i);
                break;
            }
            ++i;
        }
        Collections.sort(docs, new Comparator<Document>(){

            @Override
            public int compare(Document o1, Document o2) {
                String p1 = DataDomImpl.getFileName((Document)o1);
                String p2 = DataDomImpl.getFileName((Document)o2);
                return p1.compareTo(p2);
            }
        });
        return docs;
    }
}

