/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser;

import java.util.ArrayList;
import java.util.Hashtable;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IConciergeDialogArea;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.mdocument.TypeDomImpl;
import jp.sourceforge.concierge.mdocument.TypeManager;
import jp.sourceforge.concierge.parser.ITypeParser;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectDialogArea
implements IConciergeDialogArea {
    private static final int TEXTWIDTHHINT = 100;
    private Hashtable<String, Text> ttable = new Hashtable();
    private Document document;
    private IEditorEventListener elistener;
    private Group group1 = null;

    private void setTextAndButton(Composite parent, String lt) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text t = new Text(parent, 2048);
        GridData tgd = new GridData(4, 0x1000000, true, false);
        tgd.widthHint = 100;
        tgd.horizontalSpan = 2;
        t.setLayoutData((Object)tgd);
        this.ttable.put(lt, t);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectDialogArea.this.elistener != null) {
                    ProjectDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ProjectDialogArea.this.document));
                }
            }
        });
        Button btn = new Button(parent, 0);
        btn.setText("Reference");
        btn.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        btn.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FileDialog fd = new FileDialog(ProjectDialogArea.this.group1.getShell(), 4096);
                String path = DataDomImpl.getFilePath((Document)ProjectDialogArea.this.document);
                fd.setFilterPath(path);
                fd.setText("Select project file");
                String pfile = fd.open();
                if (pfile == null) {
                    return;
                }
                ((Text)ProjectDialogArea.this.ttable.get(lt)).setText(pfile);
            }
        });
    }

    private void setLabelAndText(Composite parent, String lt, boolean tmulti) {
        Label l = new Label(parent, 0);
        l.setText(lt);
        l.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        int mlt = tmulti ? 2 : 4;
        Text t = new Text(parent, mlt | 0x800);
        GridData tgd = tmulti ? new GridData(4, 4, true, true) : new GridData(4, 0x1000000, true, true);
        tgd.widthHint = 100;
        tgd.horizontalSpan = 3;
        t.setLayoutData((Object)tgd);
        this.ttable.put(lt, t);
        t.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (ProjectDialogArea.this.elistener != null) {
                    ProjectDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ProjectDialogArea.this.document));
                }
            }
        });
    }

    public Control createDialogArea(Composite parent) {
        this.ttable.clear();
        parent.setLayout((Layout)new GridLayout(1, false));
        this.group1 = new Group(parent, 16);
        this.group1.setLayout((Layout)new GridLayout(4, false));
        this.group1.setLayoutData((Object)new GridData(4, 128, true, true));
        this.group1.setText("Project Information");
        this.setLabelAndText((Composite)this.group1, "ProjectName", false);
        this.setTextAndButton((Composite)this.group1, "ProjectFile");
        this.setLabelAndText((Composite)this.group1, "Language", false);
        this.setLabelAndText((Composite)this.group1, "Platform", false);
        this.setLabelAndText((Composite)this.group1, "DevelopmentTools", false);
        this.setLabelAndText((Composite)this.group1, "Hardware", false);
        this.refresh();
        return parent;
    }

    public void refresh() {
        if (this.document == null) {
            return;
        }
        Element te = DataDomImpl.getDataOfType((Document)this.document, (String)"Project");
        if (te == null) {
            return;
        }
        ArrayList elems = DataDomImpl.getAllParsersElements((Element)te);
        int i = 0;
        while (i < elems.size()) {
            Element e = (Element)elems.get(i);
            String en = DataDomImpl.getTagName((Element)e);
            String pn = DataDomImpl.getParserName((Element)e);
            ITypeParser parser = FrameworkPlugin.getParser((String)pn);
            Text txt = this.ttable.get(en);
            if (txt != null) {
                txt.setText(parser.getSingleText(e));
                txt.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        if (ProjectDialogArea.this.elistener != null) {
                            ProjectDialogArea.this.elistener.run(new EditorEvent(1, e.widget, (Object)ProjectDialogArea.this.document));
                        }
                    }
                });
            }
            ++i;
        }
    }

    public void setDocument(Document doc) {
        this.document = doc;
    }

    public void setDocumentChangeListener(IEditorEventListener listener) {
        this.elistener = listener;
    }

    public Document saveDocument() {
        if (this.document == null) {
            return null;
        }
        Document schema = TypeManager.getTypeDocument((String)"Project");
        Element data = DataDomImpl.getDataOfType((Document)this.document, (String)"Project");
        if (data == null) {
            data = DataDomImpl.addDataOfType((Document)this.document, (Document)schema);
        }
        ArrayList metas = DataDomImpl.getAllParsersElements((Element)data);
        int i = 0;
        while (i < metas.size()) {
            Element meta = (Element)metas.get(i);
            String tname = DataDomImpl.getTagName((Element)meta);
            Text text = this.ttable.get(tname);
            Element schm = TypeDomImpl.getElement((Document)schema, (String)tname);
            String pname = TypeDomImpl.getParser((Element)schm);
            ITypeParser parser = FrameworkPlugin.getParser((String)pname);
            parser.putToElement(meta, text.getText());
            ++i;
        }
        return this.document;
    }

    public String getType() {
        return "Project";
    }

    public void setEnabled(boolean enabled) {
        Color lc = null;
        lc = enabled ? this.group1.getDisplay().getSystemColor(2) : this.group1.getDisplay().getSystemColor(15);
        Control[] ctrls = this.group1.getChildren();
        int i = 0;
        while (i < ctrls.length) {
            if (ctrls[i] instanceof Label) {
                ctrls[i].setForeground(lc);
            }
            ctrls[i].setEnabled(enabled);
            ++i;
        }
        this.group1.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this.group1.isEnabled();
    }

    public void fillout() {
    }

    public void dispose() {
    }

    public boolean isDisposed() {
        return this.group1.isDisposed();
    }
}

