/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin.projectbrowser.actions;

import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.framework.Request;
import jp.sourceforge.concierge.mdocument.DataDomImpl;
import jp.sourceforge.concierge.plugin.projectbrowser.ProjectUtils;
import jp.sourceforge.concierge.plugin.projectbrowser.actions.ProjectBrowserAction;
import jp.sourceforge.concierge.widget.FileNameInputDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.w3c.dom.Document;

public class RenameAction
extends ProjectBrowserAction {
    public RenameAction(TableViewer pv, TableViewer cv) {
        super(pv, cv);
    }

    public void run() {
        block9: {
            ArrayList<Document> docs = this.getSelection();
            if (docs.size() == 0) {
                return;
            }
            String path = DataDomImpl.getFilePath((Document)docs.get(0));
            File oldf = new File(path);
            if (!oldf.exists()) {
                return;
            }
            FileNameInputDialog fid = new FileNameInputDialog(this.projectview.getControl().getShell(), "Rename file", "Enter new filename");
            fid.setValue(path);
            if (fid.open() != 0) {
                return;
            }
            try {
                String newpath = fid.getValue();
                File newf = new File(newpath);
                if (!oldf.renameTo(newf)) {
                    return;
                }
                ArrayList<Document> rdocs = new ArrayList<Document>();
                if (this.getSelectionViewer().equals(this.projectview)) {
                    ArrayList<Document> cdocs = ProjectUtils.getProjectFiles(docs.get(0));
                    int i = 0;
                    while (i < cdocs.size()) {
                        String cpath = DataDomImpl.getFilePath((Document)cdocs.get(i));
                        if (cpath.startsWith(path)) {
                            cpath = cpath.replaceFirst(path, newpath);
                            DataDomImpl.setFilePath((Document)cdocs.get(i), (String)cpath);
                        }
                        ++i;
                    }
                    rdocs.addAll(cdocs);
                }
                DataDomImpl.setFilePath((Document)docs.get(0), (String)newpath);
                rdocs.add(docs.get(0));
                FrameworkPlugin.updateDocuments((Request)new Request(3, rdocs, "data"), (Object)"jp.sourceforge.concierge.plugin.projectbrowser");
            }
            catch (Throwable t) {
                if (t.getMessage() == null) break block9;
                System.err.println(t.getMessage());
            }
        }
    }
}

