/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.baseadaptor.bundlefile;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.bundlefile.ZipBundleFile;

public class ZipBundleEntry
extends BundleEntry {
    protected ZipEntry zipEntry;
    protected BundleFile bundleFile;

    ZipBundleEntry(ZipEntry zipEntry, BundleFile bundleFile) {
        this.zipEntry = zipEntry;
        this.bundleFile = bundleFile;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (!ZipBundleFile.mruList.isEnabled()) {
            return ((ZipBundleFile)this.bundleFile).getZipFile().getInputStream(this.zipEntry);
        }
        ZipBundleFile zipBundleFile = (ZipBundleFile)this.bundleFile;
        zipBundleFile.incrementReference();
        ZipBundleEntryInputStream result = null;
        try {
            ZipBundleEntryInputStream zipBundleEntryInputStream = result = new ZipBundleEntryInputStream(zipBundleFile.getZipFile().getInputStream(this.zipEntry));
            return zipBundleEntryInputStream;
        }
        finally {
            if (result == null) {
                zipBundleFile.decrementReference();
            }
        }
    }

    @Override
    public long getSize() {
        return this.zipEntry.getSize();
    }

    @Override
    public String getName() {
        return this.zipEntry.getName();
    }

    @Override
    public long getTime() {
        return this.zipEntry.getTime();
    }

    @Override
    public URL getLocalURL() {
        try {
            return new URL("jar:file:" + this.bundleFile.basefile.getAbsolutePath() + "!/" + this.zipEntry.getName());
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    @Override
    public URL getFileURL() {
        try {
            File file = this.bundleFile.getFile(this.zipEntry.getName(), false);
            if (file != null) {
                return file.toURL();
            }
        }
        catch (MalformedURLException malformedURLException) {}
        return null;
    }

    private class ZipBundleEntryInputStream
    extends InputStream {
        private final InputStream stream;
        private boolean closed = false;

        public ZipBundleEntryInputStream(InputStream stream) {
            this.stream = stream;
        }

        @Override
        public int available() throws IOException {
            return this.stream.available();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            try {
                this.stream.close();
            }
            catch (Throwable throwable) {
                ZipBundleEntryInputStream zipBundleEntryInputStream = this;
                synchronized (zipBundleEntryInputStream) {
                    if (this.closed) {
                        return;
                    }
                    this.closed = true;
                }
                ((ZipBundleFile)ZipBundleEntry.this.bundleFile).decrementReference();
                throw throwable;
            }
            ZipBundleEntryInputStream zipBundleEntryInputStream = this;
            synchronized (zipBundleEntryInputStream) {
                if (this.closed) {
                    return;
                }
                this.closed = true;
            }
            ((ZipBundleFile)ZipBundleEntry.this.bundleFile).decrementReference();
        }

        @Override
        public void mark(int var0) {
            this.stream.mark(var0);
        }

        @Override
        public boolean markSupported() {
            return this.stream.markSupported();
        }

        @Override
        public int read() throws IOException {
            return this.stream.read();
        }

        @Override
        public int read(byte[] var0, int var1, int var2) throws IOException {
            return this.stream.read(var0, var1, var2);
        }

        @Override
        public int read(byte[] var0) throws IOException {
            return this.stream.read(var0);
        }

        @Override
        public void reset() throws IOException {
            this.stream.reset();
        }

        @Override
        public long skip(long var0) throws IOException {
            return this.stream.skip(var0);
        }
    }
}

