/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.databinding.observable.map;

import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.map.AbstractObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.ISetChangeListener;
import org.eclipse.core.databinding.observable.set.SetChangeEvent;

public abstract class ComputedObservableMap
extends AbstractObservableMap {
    private final IObservableSet keySet;
    private ISetChangeListener setChangeListener = new ISetChangeListener(){

        @Override
        public void handleSetChange(SetChangeEvent event) {
            HashSet addedKeys = new HashSet(event.diff.getAdditions());
            HashSet removedKeys = new HashSet(event.diff.getRemovals());
            HashMap oldValues = new HashMap();
            HashMap newValues = new HashMap();
            for (Object removedKey : removedKeys) {
                Object oldValue = ComputedObservableMap.this.doGet(removedKey);
                ComputedObservableMap.this.unhookListener(removedKey);
                if (oldValue == null) continue;
                oldValues.put(removedKey, oldValue);
            }
            for (Object addedKey : addedKeys) {
                ComputedObservableMap.this.hookListener(addedKey);
                Object newValue = ComputedObservableMap.this.doGet(addedKey);
                newValues.put(addedKey, newValue);
            }
            ComputedObservableMap.this.fireMapChange(Diffs.createMapDiff(addedKeys, removedKeys, Collections.EMPTY_SET, oldValues, newValues));
        }
    };
    private Set entrySet = new EntrySet();

    public ComputedObservableMap(IObservableSet keySet) {
        super(keySet.getRealm());
        this.keySet = keySet;
        this.keySet.addSetChangeListener(this.setChangeListener);
    }

    protected void init() {
        for (Object key : this.keySet) {
            this.hookListener(key);
        }
    }

    protected final void fireSingleChange(Object key, Object oldValue, Object newValue) {
        this.fireMapChange(Diffs.createMapDiffSingleChange(key, oldValue, newValue));
    }

    @Override
    public Set entrySet() {
        return this.entrySet;
    }

    @Override
    public Set keySet() {
        return this.keySet;
    }

    @Override
    public final Object get(Object key) {
        return this.doGet(key);
    }

    @Override
    public final Object put(Object key, Object value) {
        return this.doPut(key, value);
    }

    protected abstract void unhookListener(Object var1);

    protected abstract void hookListener(Object var1);

    protected abstract Object doGet(Object var1);

    protected abstract Object doPut(Object var1, Object var2);

    private class EntrySet
    extends AbstractSet {
        private EntrySet() {
        }

        @Override
        public Iterator iterator() {
            final Iterator keyIterator = ComputedObservableMap.this.keySet.iterator();
            return new Iterator(){

                @Override
                public boolean hasNext() {
                    return keyIterator.hasNext();
                }

                public Object next() {
                    final Object key = keyIterator.next();
                    return new Map.Entry(){

                        public Object getKey() {
                            return key;
                        }

                        public Object getValue() {
                            return ComputedObservableMap.this.get(this.getKey());
                        }

                        public Object setValue(Object value) {
                            return ComputedObservableMap.this.put(this.getKey(), value);
                        }
                    };
                }

                @Override
                public void remove() {
                    keyIterator.remove();
                }
            };
        }

        @Override
        public int size() {
            return ComputedObservableMap.this.keySet.size();
        }
    }
}

