/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.internal.AnimationFeedbackBase;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.util.PrefUtil;

public class AnimationEngine
extends Job {
    public static final int TICK_TIMER = 1;
    public static final int unlimitedDuration = -1;
    private boolean enableAnimations;
    private Display display;
    private AnimationFeedbackBase feedbackRenderer;
    private long startTime;
    private long curTime;
    private long prevTime;
    private int timingStyle = 1;
    private long frameCount;
    private int duration;
    private long stepCount;
    public static final int FRAME_COUNT = 2;
    private boolean stopAnimating = false;
    private long sleepAmount;
    private Runnable animationStep = new Runnable(){

        @Override
        public void run() {
            AnimationEngine.this.prevTime = AnimationEngine.this.curTime;
            AnimationEngine.this.curTime = System.currentTimeMillis();
            if (AnimationEngine.this.isUpdateStep()) {
                AnimationEngine.this.updateDisplay();
                AnimationEngine animationEngine = AnimationEngine.this;
                animationEngine.frameCount = animationEngine.frameCount + 1L;
            }
            AnimationEngine animationEngine = AnimationEngine.this;
            animationEngine.stepCount = animationEngine.stepCount + 1L;
        }
    };

    public AnimationEngine(AnimationFeedbackBase animationFeedback, int durationIn) {
        this(animationFeedback, durationIn, 0L);
    }

    public AnimationEngine(AnimationFeedbackBase animationFeedback, int durationIn, long sleepAmountIn) {
        super(WorkbenchMessages.RectangleAnimation_Animating_Rectangle);
        this.sleepAmount = sleepAmountIn;
        this.feedbackRenderer = animationFeedback;
        this.duration = durationIn;
        IPreferenceStore preferenceStore = PrefUtil.getAPIPreferenceStore();
        this.enableAnimations = preferenceStore.getBoolean("ENABLE_ANIMATIONS");
        if (!this.enableAnimations) {
            return;
        }
        this.stopAnimating = false;
        this.display = this.feedbackRenderer.getAnimationShell().getDisplay();
        this.setSystem(true);
        this.feedbackRenderer.initialize(this);
        this.stepCount = 0L;
        this.curTime = this.startTime = System.currentTimeMillis();
    }

    public AnimationFeedbackBase getFeedback() {
        return this.feedbackRenderer;
    }

    protected void updateDisplay() {
        this.feedbackRenderer.renderStep(this);
    }

    protected boolean isUpdateStep() {
        if (this.duration == -1) {
            return true;
        }
        switch (this.timingStyle) {
            case 1: {
                return this.prevTime != this.curTime;
            }
            case 2: {
                return true;
            }
        }
        return false;
    }

    private boolean done() {
        return this.amount() >= 1.0;
    }

    public double amount() {
        if (this.duration == -1) {
            return 0.0;
        }
        double amount = 0.0;
        switch (this.timingStyle) {
            case 1: {
                amount = (double)(this.curTime - this.startTime) / (double)this.duration;
                break;
            }
            case 2: {
                amount = (double)this.frameCount / (double)this.duration;
            }
        }
        if (amount > 1.0) {
            amount = 1.0;
        }
        return amount;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (!this.enableAnimations) {
            return Status.OK_STATUS;
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                AnimationEngine.this.stopAnimating = !AnimationEngine.this.feedbackRenderer.jobInit(AnimationEngine.this);
            }
        });
        this.curTime = this.startTime = System.currentTimeMillis();
        while (!this.done() && !this.stopAnimating) {
            this.display.syncExec(this.animationStep);
            try {
                Thread.sleep(this.sleepAmount);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.display.syncExec(new Runnable(){

            @Override
            public void run() {
                AnimationEngine.this.feedbackRenderer.dispose();
            }
        });
        return Status.OK_STATUS;
    }

    public void cancelAnimation() {
        this.stopAnimating = true;
    }

    public long getFrameCount() {
        return this.frameCount;
    }
}

