/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.core;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.JarEntry;
import org.eclipse.update.core.ContentReference;
import org.eclipse.update.core.JarContentReference;

public class JarEntryContentReference
extends ContentReference {
    private JarContentReference jarContentReference;
    private JarEntry entry;

    public JarEntryContentReference(String id, JarContentReference jarContentReference, JarEntry entry) {
        super(id, (File)null);
        this.jarContentReference = jarContentReference;
        this.entry = entry;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.jarContentReference.asJarFile().getInputStream(this.entry);
    }

    @Override
    public long getInputSize() {
        return this.entry.getSize();
    }

    @Override
    public boolean isLocalReference() {
        return this.jarContentReference.isLocalReference();
    }

    @Override
    public URL asURL() throws IOException {
        String fileName = this.jarContentReference.asFile().getAbsolutePath().replace(File.separatorChar, '/');
        return new URL("jar:file:" + fileName + "!/" + this.entry.getName());
    }

    @Override
    public String toString() {
        URL url;
        try {
            url = this.asURL();
        }
        catch (IOException iOException) {
            url = null;
        }
        if (url != null) {
            return url.toExternalForm();
        }
        return String.valueOf(this.getClass().getName()) + "@" + this.hashCode();
    }
}

