/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.editor;

import jp.sourceforge.concierge.editor.EditorDelegate;
import jp.sourceforge.concierge.editor.EditorEvent;
import jp.sourceforge.concierge.editor.IEditorEventListener;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Document;

public class DialogStyleEditor
extends Dialog {
    private int width = 480;
    private int height = 640;
    private EditorDelegate delegate = null;
    private IEditorEventListener extlistener = null;

    protected Control createDialogArea(Composite parent) {
        Control c = this.delegate.createEditorArea(parent);
        this.getShell().setText(this.delegate.getTitle());
        return c;
    }

    protected void initializeBounds() {
        this.getShell().setSize(this.width, this.height);
    }

    protected void handleShellCloseEvent() {
        boolean stored = this.delegate.close();
        this.setReturnCode(stored ? 0 : 1);
        super.close();
    }

    protected Control createButtonBar(Composite parent) {
        return null;
    }

    protected void createButtonsForButtonBar(Composite parent) {
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.delegate.doSave();
        } else if (buttonId == 12) {
            boolean stored = this.delegate.close();
            this.setReturnCode(stored ? 0 : 1);
            FrameworkPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell().setFocus();
            super.close();
            return;
        }
    }

    public DialogStyleEditor(Shell parent, int style, EditorDelegate ed) {
        super(new Shell(parent, style));
        if ((style & 0xCF8) != 0) {
            this.setShellStyle(style);
        }
        this.delegate = ed;
        this.delegate.setModifyListener(new IEditorEventListener(){

            @Override
            public void run(EditorEvent e) {
                if (e.event == 1) {
                    DialogStyleEditor.this.getShell().setText("* " + DialogStyleEditor.this.delegate.getTitle());
                } else if (e.event == 0) {
                    DialogStyleEditor.this.getShell().setText(DialogStyleEditor.this.delegate.getTitle());
                }
                if (DialogStyleEditor.this.extlistener != null) {
                    DialogStyleEditor.this.extlistener.run(e);
                }
            }
        });
    }

    public void setModifyListener(IEditorEventListener listener) {
        this.extlistener = listener;
    }

    public void setDocument(Document doc, boolean newdoc, Object sender) {
        this.delegate.setDocument(doc, newdoc, sender);
        Shell s = this.getShell();
        if (s != null && !s.isDisposed()) {
            s.setText(this.delegate.getTitle());
        }
    }

    public Document getDocument() {
        return this.delegate.getDocument();
    }

    public void update(CCGUpdateEvent parameter) {
        this.delegate.update(parameter);
    }

    public void update(Document doc) {
        this.delegate.update(doc);
    }

    public void setInitialSize(int width, int height) {
        this.width = width;
        this.height = height;
    }
}

