/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.concierge.plugin;

import java.util.ArrayList;
import jp.sourceforge.concierge.event.CCGUpdateEvent;
import jp.sourceforge.concierge.event.CCGUpdateThread;
import jp.sourceforge.concierge.event.ICCGUpdateListener;
import jp.sourceforge.concierge.framework.ConciergeViewPart;
import jp.sourceforge.concierge.framework.FrameworkPlugin;
import jp.sourceforge.concierge.plugin.SearcherPlugin;
import jp.sourceforge.concierge.plugin.SmartIndexerPlugin;
import jp.sourceforge.concierge.plugin.searcher.data.Configure;
import jp.sourceforge.concierge.plugin.smartindexer.InternalBinder;
import jp.sourceforge.concierge.plugin.smartindexer.InternalSearcher;
import jp.sourceforge.concierge.plugin.smartindexer.SmartIndexerUtils;
import jp.sourceforge.concierge.util.DataDomTransfer;
import jp.sourceforge.concierge.util.GraphicUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.PlatformUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SmartIndexer
extends ConciergeViewPart {
    private static final int ICONHEIGHT = 80;
    public final String strCreateMenu = "Create";
    public final String strOpenMenu = "Open";
    public final String strEditMenu = "Edit";
    public final String strDeleteMenu = "Delete";
    public final String strDeleteAllMenu = "Delete All";
    public final String strStartMenu = "Search";
    public final String strCopyMenu = "Copy";
    public final String NEW_FOLDER_NAME = "Untitled";
    private static final int BACK_COLOR = 1;
    private ScrolledComposite scrComp = null;
    private Composite base = null;
    private Action createAction = null;
    private Action editSearchAction = null;
    private Action deleteAction = null;
    private Action searchAction = null;
    private Action copyAction = null;
    private ArrayList<InternalBinder> folderIconList = new ArrayList();

    public void createPartControl(Composite parent) {
        this.makeActions();
        this.scrComp = new ScrolledComposite(parent, 2560);
        this.scrComp.setLayout((Layout)new FillLayout());
        this.scrComp.setExpandHorizontal(true);
        GraphicUtil.setBackground((Control)this.scrComp, (int)1);
        this.scrComp.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = SmartIndexer.this.scrComp.getClientArea();
                SmartIndexer.this.base.setSize(SmartIndexer.this.base.computeSize(r.width, -1));
            }
        });
        this.base = new Composite((Composite)this.scrComp, 0);
        RowLayout rl = new RowLayout(256);
        rl.wrap = true;
        this.base.setLayout((Layout)rl);
        GraphicUtil.setBackground((Control)this.base, (int)1);
        this.scrComp.setContent((Control)this.base);
        this.loadConfig();
        FrameworkPlugin.addDatabaseListener((String)"ccgconfig", (ICCGUpdateListener)new CCGUpdateThread((Control)this.base, new ICCGUpdateListener(){

            public void updated(CCGUpdateEvent ev) {
                if (ev.sender.equals(SmartIndexerPlugin.getDefault().getBundle().getSymbolicName())) {
                    return;
                }
                if (!ev.collection.equals("ccgconfig")) {
                    return;
                }
                if (!ev.success.booleanValue()) {
                    return;
                }
                SmartIndexer.this.loadConfig();
            }
        }));
    }

    private void setSearchFolderIconAction(InternalSearcher icon) {
        icon.setOpenAction(new OpenSearchAction(icon));
        icon.setSelectAction(new SelectAction(icon));
        icon.setDeleteAction(new DeleteAction(icon));
        icon.setCopyAction(new CopyAction(icon));
        icon.setUpdateDataAction(new UpdateDataAction(icon));
    }

    private void loadConfig() {
        if (this.base.isDisposed()) {
            return;
        }
        ArrayList typeDocList = SearcherPlugin.getConfigList();
        if (typeDocList != null) {
            this.folderIconList.clear();
            Control[] ctrls = this.base.getChildren();
            int i = 0;
            while (i < ctrls.length) {
                ctrls[i].dispose();
                ++i;
            }
            int size = typeDocList.size();
            int i2 = 0;
            while (i2 < size) {
                InternalBinder icon;
                Element elem = (Element)typeDocList.get(i2);
                Configure.InfoType type = Configure.getInfoType((Element)elem);
                if (type == Configure.InfoType.BINDER) {
                    icon = new InternalBinder(this.base, this, elem);
                    icon.setLayoutData(new RowData(80, 80));
                    this.setFolderIconAction(icon);
                    this.folderIconList.add(icon);
                } else if (type == Configure.InfoType.SEARCH) {
                    icon = new InternalSearcher(this.base, this, elem);
                    icon.setLayoutData(new RowData(80, 80));
                    this.setSearchFolderIconAction((InternalSearcher)icon);
                    this.folderIconList.add(icon);
                }
                ++i2;
            }
            this.update();
        }
    }

    private void addSearchFolderIcon(Element elem0, boolean showDialog, boolean sendToFram) {
        Element elem = elem0;
        if (elem == null) {
            elem = SearcherPlugin.createInfo((String)"Untitled", (Configure.InfoType)Configure.InfoType.SEARCH);
        }
        InternalSearcher icon = new InternalSearcher(this.base, this, elem);
        icon.setLayoutData(new RowData(80, 80));
        this.setSearchFolderIconAction(icon);
        if (showDialog && !icon.editInfo()) {
            icon.dispose();
            return;
        }
        this.folderIconList.add(icon);
        if (sendToFram) {
            String sender = SmartIndexerPlugin.getDefault().getBundle().getSymbolicName();
            SearcherPlugin.addInfo((Element)elem, (Object)sender);
        }
        this.update();
    }

    private void setFolderIconAction(InternalBinder icon) {
        icon.setSelectAction(new SelectAction(icon));
        icon.setDeleteAction(new DeleteAction(icon));
        icon.setCopyAction(new CopyAction(icon));
        icon.setOpenAction(new OpenAction(icon));
        icon.setUpdateDataAction(new UpdateDataAction(icon));
        DropTarget target = new DropTarget(icon.getImageControl(), 3);
        target.setTransfer(new Transfer[]{FileTransfer.getInstance(), LocalSelectionTransfer.getTransfer(), DataDomTransfer.getInstance()});
        target.addDropListener((DropTargetListener)new FolderDropListener(icon));
    }

    private void addFolderIcon(Element elem0, boolean showDialog) {
        Element elem = elem0;
        if (elem == null) {
            elem = SearcherPlugin.createInfo((String)"Untitled", (Configure.InfoType)Configure.InfoType.BINDER);
        }
        InternalBinder icon = new InternalBinder(this.base, this, elem);
        icon.setLayoutData(new RowData(80, 80));
        this.setFolderIconAction(icon);
        if (showDialog && !icon.editInfo()) {
            icon.dispose();
            return;
        }
        this.folderIconList.add(icon);
        String sender = SmartIndexerPlugin.getDefault().getBundle().getSymbolicName();
        SearcherPlugin.addInfo((Element)elem, (Object)sender);
        this.update();
    }

    public void update() {
        int size = this.folderIconList.size();
        int i = 0;
        while (i < size) {
            InternalBinder comp = this.folderIconList.get(i);
            comp.setNameLabelText();
            ++i;
        }
        Rectangle r = this.scrComp.getClientArea();
        this.base.setSize(this.base.computeSize(r.width, -1));
        this.base.layout();
    }

    private void makeActions() {
        this.createAction = new CreateNewFolderAction();
        this.createAction.setToolTipText("Create");
        this.createAction.setImageDescriptor(SmartIndexerPlugin.getImageDescriptor("icons/newfolder.gif"));
        IActionBars bars = this.getViewSite().getActionBars();
        bars.getToolBarManager().add((IAction)this.createAction);
        this.editSearchAction = new Action(){

            public void run() {
                int i = 0;
                while (i < SmartIndexer.this.folderIconList.size()) {
                    InternalBinder icon = (InternalBinder)((Object)SmartIndexer.this.folderIconList.get(i));
                    if (icon.isSelected()) {
                        InternalBinder sicon = icon;
                        sicon.editInfo();
                    }
                    ++i;
                }
            }
        };
        this.editSearchAction.setToolTipText("Edit");
        this.editSearchAction.setImageDescriptor(SmartIndexerPlugin.getImageDescriptor("icons/editmetadata.png"));
        bars.getToolBarManager().add((IAction)this.editSearchAction);
        this.copyAction = new Action(){

            public void run() {
                int i = 0;
                while (i < SmartIndexer.this.folderIconList.size()) {
                    InternalBinder icon = (InternalBinder)((Object)SmartIndexer.this.folderIconList.get(i));
                    if (icon.isSelected()) {
                        icon.copyFolder();
                    }
                    ++i;
                }
            }
        };
        this.copyAction.setToolTipText("Copy");
        this.copyAction.setImageDescriptor(SmartIndexerPlugin.getImageDescriptor("icons/duplicatefolder.png"));
        bars.getToolBarManager().add((IAction)this.copyAction);
        this.deleteAction = new Action(){

            public void run() {
                int size = SmartIndexer.this.folderIconList.size();
                int i = 0;
                while (i < size) {
                    InternalBinder icon = (InternalBinder)((Object)SmartIndexer.this.folderIconList.get(i));
                    if (icon.isSelected()) {
                        icon.deleteFolder(true);
                        break;
                    }
                    ++i;
                }
            }
        };
        this.deleteAction.setToolTipText("Delete");
        this.deleteAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_DELETE"));
        bars.getToolBarManager().add((IAction)this.deleteAction);
        bars.getToolBarManager().add((IContributionItem)new Separator());
        this.searchAction = new Action(){

            public void run() {
                int i = 0;
                while (i < SmartIndexer.this.folderIconList.size()) {
                    InternalBinder icon = (InternalBinder)((Object)SmartIndexer.this.folderIconList.get(i));
                    if (icon.isSelected() && ((Object)((Object)icon)).getClass() == InternalSearcher.class) {
                        InternalSearcher sicon = (InternalSearcher)icon;
                        sicon.startSearch(true);
                    }
                    ++i;
                }
            }
        };
        this.searchAction.setToolTipText("Search");
        this.searchAction.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_FORWARD"));
        bars.getToolBarManager().add((IAction)this.searchAction);
        bars.getToolBarManager().add((IContributionItem)new Separator());
    }

    private void showMessage(String message) {
        MessageDialog.openInformation((Shell)this.scrComp.getShell(), (String)"SmartIndexer", (String)message);
    }

    public void setFocus() {
    }

    private class CopyAction
    extends Action {
        private InternalBinder icon;

        public CopyAction(InternalBinder obj) {
            this.icon = obj;
        }

        public void run() {
            if (this.icon.isSelected()) {
                if (((Object)((Object)this.icon)).getClass() == InternalSearcher.class) {
                    InternalSearcher sicon = (InternalSearcher)this.icon;
                    InternalSearcher folder = sicon.clone();
                    SmartIndexer.this.setSearchFolderIconAction(folder);
                    if (folder != null) {
                        SmartIndexer.this.folderIconList.add(folder);
                    }
                } else if (((Object)((Object)this.icon)).getClass() == InternalBinder.class) {
                    InternalBinder new_icon = this.icon.clone();
                    SmartIndexer.this.setFolderIconAction(new_icon);
                    if (new_icon != null) {
                        SmartIndexer.this.folderIconList.add(new_icon);
                    }
                }
                SmartIndexer.this.update();
            }
        }
    }

    class CreateNewFolderAction
    extends Action
    implements IMenuCreator {
        Menu fMenu;

        CreateNewFolderAction() {
            this.setMenuCreator(this);
        }

        public void run() {
            SmartIndexer.this.addFolderIcon(null, true);
        }

        public void dispose() {
        }

        public Menu getMenu(Control parent) {
            this.fMenu = new Menu(parent);
            Action newFolder = new Action(){

                public void run() {
                    SmartIndexer.this.addFolderIcon(null, true);
                }
            };
            newFolder.setText("New binder");
            this.addActionToMenu(this.fMenu, (IAction)newFolder);
            Action newSearchFolder = new Action(){

                public void run() {
                    SmartIndexer.this.addSearchFolderIcon(null, true, true);
                }
            };
            newSearchFolder.setText("New search");
            this.addActionToMenu(this.fMenu, (IAction)newSearchFolder);
            return this.fMenu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }

        protected void addActionToMenu(Menu parent, IAction action) {
            ActionContributionItem item = new ActionContributionItem(action);
            item.fill(parent, -1);
        }
    }

    private class DeleteAction
    extends Action {
        private InternalBinder icon;

        public DeleteAction(InternalBinder obj) {
            this.icon = obj;
        }

        public void run() {
            try {
                Element elem = this.icon.getConfigure();
                String sender = SmartIndexerPlugin.getDefault().getBundle().getSymbolicName();
                SearcherPlugin.removeInfo((Element)elem, (Object)sender);
                SmartIndexer.this.folderIconList.remove((Object)this.icon);
                SmartIndexer.this.update();
            }
            catch (Exception exp) {
                System.out.println(exp.getMessage());
            }
        }
    }

    private class FolderDropListener
    extends DropTargetAdapter {
        private InternalBinder icon;

        public FolderDropListener(InternalBinder obj) {
            this.icon = obj;
        }

        public void dragEnter(DropTargetEvent e) {
            if (!DataDomTransfer.getInstance().isSupportedType(e.currentDataType)) {
                e.detail = 0;
                return;
            }
            this.icon.setDropedBackground(true);
        }

        public void dragLeave(DropTargetEvent event) {
            this.icon.setDropedBackground(false);
        }

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void dragOver(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent e) {
            if (e == null) {
                return;
            }
            TransferData tData = e.currentDataType;
            if (LocalSelectionTransfer.getTransfer().isSupportedType(tData)) {
                SmartIndexer.this.showMessage("This operation is not supported.");
            } else if (FileTransfer.getInstance().isSupportedType(tData)) {
                SmartIndexer.this.showMessage("This operation is not supported.");
            } else if (DataDomTransfer.getInstance().isSupportedType(tData)) {
                Document[] docs = (Document[])e.data;
                int i = 1;
                while (i < docs.length) {
                    this.icon.addDocument(docs[i]);
                    ++i;
                }
            }
        }

        public void dropAccept(DropTargetEvent e) {
            if (!DataDomTransfer.getInstance().isSupportedType(e.currentDataType)) {
                e.detail = 0;
            }
        }
    }

    private class OpenAction
    extends Action {
        private InternalBinder icon;

        public OpenAction(InternalBinder obj) {
            this.icon = obj;
        }

        public void run() {
            if (this.icon.isSelected()) {
                Element config = this.icon.getConfigure();
                ArrayList d = Configure.getBindedDocuments((Element)config);
                SmartIndexerUtils.setDocumentsToTabulator(d, Configure.getName((Element)config));
            }
        }
    }

    private class OpenSearchAction
    extends Action {
        private InternalSearcher icon;

        public OpenSearchAction(InternalSearcher obj) {
            this.icon = obj;
        }

        public void run() {
            if (this.icon.isSelected()) {
                this.icon.startSearch(false);
            }
        }
    }

    private class SelectAction
    extends Action {
        private InternalBinder icon;

        public SelectAction(InternalBinder obj) {
            this.icon = obj;
        }

        public void run() {
            int size = SmartIndexer.this.folderIconList.size();
            int i = 0;
            while (i < size) {
                InternalBinder f = (InternalBinder)((Object)SmartIndexer.this.folderIconList.get(i));
                f.deselect();
                ++i;
            }
            this.icon.select();
            SmartIndexer.this.createAction.setEnabled(true);
            SmartIndexer.this.copyAction.setEnabled(true);
            SmartIndexer.this.deleteAction.setEnabled(true);
            SmartIndexer.this.searchAction.setEnabled(true);
            SmartIndexer.this.editSearchAction.setEnabled(true);
            if (((Object)((Object)this.icon)).getClass() == InternalBinder.class) {
                SmartIndexer.this.searchAction.setEnabled(false);
            } else if (((Object)((Object)this.icon)).getClass() == InternalSearcher.class) {
                SmartIndexer.this.searchAction.setEnabled(true);
            }
        }
    }

    private class UpdateDataAction
    extends Action {
        private InternalBinder icon;

        public UpdateDataAction(InternalBinder obj) {
            this.icon = obj;
        }

        public void run() {
            Element config = this.icon.getConfigure();
            ArrayList d = Configure.getBindedDocuments((Element)config);
            SmartIndexerUtils.setDocumentsToTabulator(d, Configure.getName((Element)config));
        }
    }
}

