/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import nga.servlet.CongaServletAdapterMultiCaster;
import nga.servlet.ErrorInfo;
import nga.servlet.RequestConfigInitializer;
import nga.servlet.ServiceInfo;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.dsp.DefaultCongaServletFactory;
import nga.servlet.dsp.adapter.ExceptionLogger;
import nga.servlet.spi.CongaServletAdapter;
import nga.servlet.spi.CongaServletFactory;
import nga.servlet.spi.ParameterParser;
import nga.servlet.spi.ResultWriter;
import nga.util.ConfigurationException;
import nga.util.Resource;
import nga.util.UserLocale;

public class CongaServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String WINDOW_ID = "_nga.window.id";
    public static final String ASYNC = "_nga.async";
    public static final String SYSTEM_ENCODING = "nga.servlet.system.encoding";
    public static final String CHARSET = "nga.servlet.charset";
    public static final String CONFIG_DIR = "nga.servlet.request-config-dir";
    public static final String CONFIG_FILE = "nga.servlet.request-config-file";
    public static final String FACTORY = "nga.servlet.factory";
    public static final String ADAPTER = "nga.servlet.adapter";
    private static final String SERVICE_INFO = "nga.service.info";
    private static final String SESSION_BINDING_LISTENER = "nga.session.binding.listener";
    private CongaServletFactory factory;
    private List<Class<? extends CongaServletAdapter>> adapterClassList;
    private Map<String, ModuleInfo> moduleInfoMap = new HashMap<String, ModuleInfo>();
    private Map<String, String> charsetMap = new HashMap<String, String>();
    private Resource resource = new Resource(((Object)((Object)this)).getClass().getPackage().getName() + ".Message");
    private ThreadLocal<CongaServletAdapter> adapter = new ThreadLocal<CongaServletAdapter>(){

        @Override
        protected synchronized CongaServletAdapter initialValue() {
            return new CongaServletAdapterMultiCaster(CongaServlet.this.adapterClassList);
        }
    };
    private static ThreadLocal<Map<String, ParameterParser>> parserMap = new ThreadLocal<Map<String, ParameterParser>>(){

        @Override
        protected synchronized Map<String, ParameterParser> initialValue() {
            return new HashMap<String, ParameterParser>();
        }
    };
    private static ThreadLocal<Map<String, ResultWriter>> writerMap = new ThreadLocal<Map<String, ResultWriter>>(){

        @Override
        protected synchronized Map<String, ResultWriter> initialValue() {
            return new HashMap<String, ResultWriter>();
        }
    };
    private String systemEncoding;

    public void init() throws ServletException {
        this.initFactory();
        this.initAdapter();
        this.initEncoding();
        this.adapter.get().init(this);
    }

    private void initAdapter() throws ServletException {
        this.adapterClassList = new ArrayList<Class<? extends CongaServletAdapter>>();
        String adapterList = this.getServletConfig().getInitParameter(ADAPTER);
        if (adapterList == null) {
            this.adapterClassList.add(ExceptionLogger.class);
        } else {
            try {
                StringTokenizer st = new StringTokenizer(adapterList, " ,\n\r;:");
                while (st.hasMoreTokens()) {
                    this.adapterClassList.add(Class.forName(st.nextToken()).asSubclass(CongaServletAdapter.class));
                }
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
    }

    private void initEncoding() {
        String cs;
        this.systemEncoding = this.getServletConfig().getInitParameter(SYSTEM_ENCODING);
        if (this.systemEncoding == null) {
            this.systemEncoding = System.getProperty("file.encoding");
        }
        if ((cs = this.getServletConfig().getInitParameter(CHARSET)) == null) {
            this.charsetMap.put(null, this.systemEncoding);
        } else {
            StringTokenizer st = new StringTokenizer(cs, " ;,:\t\n\r");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                int index = line.indexOf(61);
                String locale = null;
                String charset = this.systemEncoding;
                if (index > 0 && index < line.length() - 1) {
                    locale = line.substring(0, index).trim();
                    charset = line.substring(index + 1).trim();
                }
                this.charsetMap.put(locale, charset);
            }
        }
    }

    private void initFactory() throws ServletException {
        String factoryClassName = this.getServletConfig().getInitParameter(FACTORY);
        if (factoryClassName != null) {
            try {
                this.factory = Class.forName(factoryClassName).asSubclass(CongaServletFactory.class).newInstance();
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        } else {
            this.factory = new DefaultCongaServletFactory();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        UserLocale.setLocale(request.getLocale());
        this.initCharset(request);
        ServiceInfo serviceInfo = new ServiceInfo(this, request, response, this.systemEncoding);
        request.setAttribute(SERVICE_INFO, (Object)serviceInfo);
        String requestId = request.getServletPath();
        serviceInfo.setRequestId(requestId);
        this.checkSession(serviceInfo);
        try {
            this.adapter.get().begin(serviceInfo);
            RequestInfo requestInfo = this.getRequestInfo(requestId);
            if (requestInfo == null) {
                throw new ConfigurationException(this.resource.message("m_request_not_found", requestId));
            }
            serviceInfo.setRequestInfo(requestInfo);
            serviceInfo.setResource(this.getResource(requestInfo));
            serviceInfo.setErrorInfo(new ErrorInfo(serviceInfo.getResource()));
            String pageKey = CongaServlet.getPageKey(request, requestInfo.getPageId(), requestInfo.getModuleInfo().getId());
            try {
                if (this.lock(request, pageKey)) {
                    this.mainProc(serviceInfo, pageKey);
                } else {
                    response.setContentType("text/xml; charset=UTF-8");
                    PrintWriter writer = response.getWriter();
                    writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                    writer.println("<c></c>");
                }
            }
            finally {
                this.unlock(request, pageKey);
            }
        }
        catch (Throwable e) {
            this.adapter.get().abort(serviceInfo, e);
        }
        finally {
            this.adapter.get().end(serviceInfo, requestId);
        }
    }

    private void checkSession(ServiceInfo serviceInfo) throws ServletException {
        HttpSession session = serviceInfo.getSession();
        if (session.getAttribute(SESSION_BINDING_LISTENER) == null) {
            session.setAttribute(SESSION_BINDING_LISTENER, (Object)new HttpSessionBindingListener(){

                public void valueBound(HttpSessionBindingEvent event) {
                }

                public void valueUnbound(HttpSessionBindingEvent event) {
                    ((CongaServletAdapter)CongaServlet.this.adapter.get()).sessionDestroyed(CongaServlet.this, event.getSession());
                }
            });
            this.adapter.get().sessionCreated(serviceInfo);
        }
    }

    private boolean lock(HttpServletRequest request, String pageKey) {
        String param = request.getParameter(ASYNC);
        String attrName = pageKey + "*lock";
        HttpSession session = request.getSession();
        if (param == null) {
            while (true) {
                if (session.getAttribute(attrName) == null) {
                    session.setAttribute(attrName, (Object)attrName);
                    return true;
                }
                try {
                    Thread.sleep(20L);
                }
                catch (Exception e) {}
            }
        }
        if (Boolean.parseBoolean(param)) {
            return true;
        }
        if (session.getAttribute(attrName) == null) {
            session.setAttribute(attrName, (Object)attrName);
            return true;
        }
        return false;
    }

    private void unlock(HttpServletRequest request, String pageKey) {
        request.getSession().removeAttribute(pageKey + "*lock");
    }

    private void mainProc(ServiceInfo serviceInfo, String pageKey) throws Throwable {
        HttpServletRequest request = serviceInfo.getRequest();
        RequestInfo requestInfo = serviceInfo.getRequestInfo();
        ResultInfo resultInfo = requestInfo.getResultInfo();
        String oldRequestId = serviceInfo.getRequestId();
        String newRequestId = resultInfo.getForward();
        Object pageObject = this.getPageObject(request, requestInfo, pageKey);
        serviceInfo.setPageObject(pageObject);
        Object resultObject = null;
        boolean parsed = true;
        ParameterInfo parameterInfo = requestInfo.getParameterInfo();
        if (parameterInfo != null) {
            parsed = this.getParameterParser(parameterInfo).parse(serviceInfo);
        }
        if (parsed && requestInfo.getControllerClass() != null) {
            resultObject = this.execController(serviceInfo, requestInfo, pageObject, pageKey);
            newRequestId = serviceInfo.getRequestId();
        }
        if (resultObject == null) {
            resultObject = pageObject;
        }
        if (newRequestId != null && !newRequestId.equals(oldRequestId)) {
            this.adapter.get().forwarding(serviceInfo, oldRequestId, newRequestId);
            request.getRequestDispatcher(newRequestId).forward((ServletRequest)request, (ServletResponse)serviceInfo.getResponse());
            return;
        }
        serviceInfo.setResultObject(resultObject);
        this.getResultWriter(resultInfo).write(serviceInfo);
    }

    private void initCharset(HttpServletRequest request) throws UnsupportedEncodingException {
        String charset;
        int index = request.getContentType().lastIndexOf(";charset=");
        if (index > -1) {
            charset = request.getContentType().substring(index + 9);
        } else {
            charset = this.charsetMap.get(UserLocale.getLocale());
            if (charset == null && (charset = this.charsetMap.get(null)) == null) {
                charset = this.systemEncoding;
            }
        }
        request.setCharacterEncoding(charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RequestInfo getRequestInfo(String path) throws ServletException {
        ModuleInfo moduleInfo;
        int index = path.lastIndexOf(47);
        String moduleName = path.substring(0, index);
        String requestId = path.substring(index + 1);
        Map<String, ModuleInfo> map = this.moduleInfoMap;
        synchronized (map) {
            moduleInfo = this.moduleInfoMap.get(moduleName);
            if (moduleInfo == null) {
                moduleInfo = new RequestConfigInitializer().getModuleInfo(moduleName, this.getServletConfig(), this.getServletContext());
            }
        }
        return moduleInfo.getRequestInfo(requestId);
    }

    private Resource getResource(RequestInfo requestInfo) {
        Locale locale = UserLocale.getLocale();
        String resourceName = requestInfo.getResourceName();
        return this.factory.getResource(locale, resourceName);
    }

    public static ServiceInfo getServiceInfo(HttpServletRequest request) {
        return (ServiceInfo)request.getAttribute(SERVICE_INFO);
    }

    private static String getPageKey(HttpServletRequest request, String pageId, String moduleName) {
        String windowId = request.getParameter(WINDOW_ID);
        if (windowId == null) {
            windowId = "";
        }
        return moduleName + "/" + pageId + "@" + windowId;
    }

    public static String getWindowId() {
        return "w" + System.currentTimeMillis();
    }

    private Object getPageObject(HttpServletRequest request, RequestInfo requestInfo, String key) throws InstantiationException, IllegalAccessException {
        String pageId = requestInfo.getPageId();
        Class pageClass = null;
        try {
            pageClass = requestInfo.getPageClass();
            if (pageClass == null) {
                return pageClass;
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.resource.message("m_class_not_found", requestInfo.getPage()), e);
        }
        if (pageId != null) {
            Object pageObject = request.getSession().getAttribute(key);
            if (pageObject == null) {
                pageObject = pageClass.newInstance();
                request.getSession().setAttribute(key, pageObject);
            }
            return pageObject;
        }
        return pageClass.newInstance();
    }

    private ParameterParser getParameterParser(ParameterInfo parameterInfo) throws InstantiationException, IllegalAccessException {
        ParameterParser parser;
        Class<ParameterParser> parserClass = parameterInfo.getParser();
        String parserClassName = "";
        if (parserClass != null) {
            parserClassName = parserClass.getName();
        }
        if ((parser = parserMap.get().get(parserClassName)) == null) {
            parser = "".equals(parserClassName) ? this.factory.createParameterParser() : parserClass.newInstance();
            parserMap.get().put(parserClassName, parser);
        }
        return parser;
    }

    private Object execController(ServiceInfo serviceInfo, RequestInfo requestInfo, Object valueObject, String pageKey) throws Throwable {
        Class c;
        Object controller;
        String attrName = "controllerMap@" + pageKey;
        HashMap controllerMap = (HashMap)serviceInfo.getSession().getAttribute(attrName);
        if (controllerMap == null) {
            controllerMap = new HashMap();
            serviceInfo.getSession().setAttribute(attrName, controllerMap);
        }
        if ((controller = controllerMap.get(c = requestInfo.getControllerClass())) == null) {
            controller = c.newInstance();
            controllerMap.put(c, controller);
        }
        Method method = requestInfo.getControllerMethod();
        Class<?>[] paramClass = method.getParameterTypes();
        Object[] param = new Object[paramClass.length];
        for (int i = 0; i < param.length; ++i) {
            if (paramClass[i].isAssignableFrom(ServiceInfo.class)) {
                param[i] = serviceInfo;
                continue;
            }
            if (paramClass[i].isAssignableFrom(HttpServletRequest.class)) {
                param[i] = serviceInfo.getRequest();
                continue;
            }
            if (paramClass[i].isAssignableFrom(HttpServletResponse.class)) {
                param[i] = serviceInfo.getResponse();
                continue;
            }
            if (valueObject == null || !paramClass[i].isAssignableFrom(valueObject.getClass())) continue;
            param[i] = valueObject;
        }
        Object resultObject = null;
        if (this.adapter.get().checkParameter(serviceInfo, controller, method, param)) {
            try {
                resultObject = method.invoke(controller, param);
            }
            catch (InvocationTargetException e) {
                throw e.getCause();
            }
            this.adapter.get().editResult(serviceInfo, controller, method, resultObject);
        }
        return resultObject;
    }

    private ResultWriter getResultWriter(ResultInfo resultInfo) throws InstantiationException, IllegalAccessException {
        ResultWriter writer;
        Class<ResultWriter> writerClass = resultInfo.getWriter();
        String writerClassName = "";
        if (writerClass != null) {
            writerClassName = writerClass.getName();
        }
        if ((writer = writerMap.get().get(writerClassName)) == null) {
            writer = "".equals(writerClassName) ? this.factory.createResultWriter() : writerClass.newInstance();
            writerMap.get().put(writerClassName, writer);
        }
        return writer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        try {
            this.adapter.get().destroy(this);
        }
        finally {
            super.destroy();
        }
    }
}

