/*
 * Decompiled with CFR 0.152.
 */
package nga.servlet;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import nga.servlet.config.ModuleInfo;
import nga.servlet.config.PageInfo;
import nga.servlet.config.ParameterInfo;
import nga.servlet.config.PropertyInfo;
import nga.servlet.config.PropertyInfoMap;
import nga.servlet.config.RequestInfo;
import nga.servlet.config.ResultInfo;
import nga.servlet.config.TargetInfo;
import nga.servlet.config.TargetInfoList;
import nga.util.ConfigurationException;
import nga.util.Resource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

class RequestConfigInitializer {
    private static DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
    private Resource resource = new Resource(this.getClass().getPackage().getName() + ".Message");

    public ModuleInfo getModuleInfo(String dir, ServletConfig config, ServletContext context) throws ServletException {
        ModuleInfo moduleInfo = new ModuleInfo(dir);
        File[] file = this.getConfigFile(dir, config, context);
        for (int i = 0; i < file.length; ++i) {
            try {
                this.initModuleInfo(file[i], moduleInfo);
                continue;
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
        }
        return moduleInfo;
    }

    private File[] getConfigFile(String moduleName, ServletConfig config, ServletContext context) {
        int starIndex;
        String configDir = config.getInitParameter("nga.servlet.request-config-dir");
        if (configDir == null || configDir.length() == 0) {
            configDir = "conf";
        }
        if (configDir.charAt(0) == '/' || configDir.charAt(0) == '\\') {
            configDir = configDir.substring(1);
        }
        configDir = moduleName + "/" + configDir;
        String configFile = config.getInitParameter("nga.servlet.request-config-file");
        if (configFile == null) {
            configFile = "*request-config.xml";
        }
        final String prefix = (starIndex = configFile.indexOf(42)) > 0 ? configFile.substring(0, starIndex) : null;
        final String suffix = starIndex < configFile.length() - 1 ? configFile.substring(starIndex + 1) : null;
        File dir = new File(context.getRealPath(configDir));
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File d, String name) {
                if (prefix != null && !name.startsWith(prefix)) {
                    return false;
                }
                return suffix == null || name.endsWith(suffix);
            }
        });
        if (files == null || files.length == 0) {
            throw new ConfigurationException(this.message("m_not_found_config_file", dir + File.separator + configFile));
        }
        return files;
    }

    private void initModuleInfo(File file, ModuleInfo moduleInfo) throws ConfigurationException, IOException, SAXException, ParserConfigurationException {
        Document doc = builderFactory.newDocumentBuilder().parse(file);
        this.addPageInfo(moduleInfo, doc);
        this.addRequestInfo(moduleInfo, doc);
    }

    private void addPageInfo(ModuleInfo moduleInfo, Document doc) {
        NodeList list = doc.getElementsByTagName("page");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            PageInfo pageInfo = this.getPageInfo(node);
            if (moduleInfo.setPageInfo(pageInfo.getId(), pageInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_page", pageInfo.getId()));
        }
    }

    private PageInfo getPageInfo(Node node) throws ConfigurationException {
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_page_id", new Object[0]));
        }
        PageInfo pageInfo = new PageInfo(id);
        String cls = this.getValue(attr, "class");
        if (cls == null) {
            throw new ConfigurationException(this.message("m_null_page_class", new Object[0]));
        }
        try {
            Class<?> c = Class.forName(cls);
            pageInfo.setPageClass(c);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", cls), e);
        }
        return pageInfo;
    }

    private void addRequestInfo(ModuleInfo moduleInfo, Document doc) {
        NodeList list = doc.getElementsByTagName("request");
        for (int i = 0; i < list.getLength(); ++i) {
            Node node = list.item(i);
            RequestInfo requestInfo = this.getRequestInfo(node);
            if (moduleInfo.setRequestInfo(requestInfo.getId(), requestInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_request", requestInfo.getId()));
        }
    }

    private RequestInfo getRequestInfo(Node node) throws ConfigurationException {
        NamedNodeMap attr = node.getAttributes();
        String id = this.getValue(attr, "id");
        if (id == null) {
            throw new ConfigurationException(this.message("m_null_request_id", new Object[0]));
        }
        RequestInfo requestInfo = new RequestInfo(id);
        String controller = this.getValue(attr, "controller");
        if (controller != null) {
            int dotIndex = controller.lastIndexOf(46);
            if (dotIndex < 1 || dotIndex > controller.length() - 2) {
                throw new ConfigurationException(this.message("m_invalid_controller_attribute", new Object[0]));
            }
            try {
                Class<?> c = Class.forName(controller.substring(0, dotIndex));
                requestInfo.setControllerClass(c);
                String methodName = controller.substring(dotIndex + 1);
                Method[] method = c.getMethods();
                for (int i = 0; i < method.length; ++i) {
                    if (!method[i].getName().equals(methodName) || !Modifier.isPublic(method[i].getModifiers())) continue;
                    requestInfo.setControllerMethod(method[i]);
                    break;
                }
                if (requestInfo.getControllerMethod() == null) {
                    throw new ConfigurationException(this.message("m_invalid_controller_method", controller.substring(0, dotIndex), methodName));
                }
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(this.message("m_class_not_found", controller.substring(0, dotIndex)), e);
            }
        }
        requestInfo.setPage(this.getValue(attr, "page"));
        requestInfo.setResourceName(this.getValue(attr, "resource"));
        NodeList nlist = node.getChildNodes();
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            String name = child.getNodeName();
            if ("parameter".equals(name)) {
                requestInfo.setParameterInfo(this.getParameterInfo(child));
                continue;
            }
            if (!"result".equals(name)) continue;
            requestInfo.setResultInfo(this.getResultInfo(child));
        }
        return requestInfo;
    }

    private ResultInfo getResultInfo(Node node) {
        ResultInfo resultInfo = new ResultInfo();
        NamedNodeMap attr = node.getAttributes();
        String writerClass = this.getValue(attr, "writer");
        try {
            if (writerClass != null) {
                resultInfo.setWriter(Class.forName(writerClass));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", writerClass), e);
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            Node n = attr.item(i);
            resultInfo.put(n.getNodeName(), n.getNodeValue());
        }
        this.initTarget(resultInfo.getTargetInfoList(), node.getChildNodes());
        return resultInfo;
    }

    private void initTarget(TargetInfoList targetInfoList, NodeList nlist) {
        for (int i = 0; i < nlist.getLength(); ++i) {
            Node child = nlist.item(i);
            if (!"target".equals(child.getNodeName())) continue;
            targetInfoList.add(this.getTargetInfo(child));
        }
    }

    private TargetInfo getTargetInfo(Node node) {
        NamedNodeMap attr = node.getAttributes();
        TargetInfo targetInfo = new TargetInfo();
        for (int j = 0; j < attr.getLength(); ++j) {
            Node n = attr.item(j);
            targetInfo.put(n.getNodeName(), n.getNodeValue());
        }
        NodeList children = node.getChildNodes();
        if (children != null && children.getLength() > 0) {
            targetInfo.setChildren(new TargetInfoList());
            this.initTarget(targetInfo.getChildren(), children);
        }
        return targetInfo;
    }

    private ParameterInfo getParameterInfo(Node node) {
        ParameterInfo parameterInfo = new ParameterInfo();
        NamedNodeMap attr = node.getAttributes();
        String parserClass = this.getValue(attr, "parser");
        try {
            if (parserClass != null) {
                parameterInfo.setParser(Class.forName(parserClass));
            }
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException(this.message("m_class_not_found", parserClass), e);
        }
        for (int i = 0; i < attr.getLength(); ++i) {
            Node n = attr.item(i);
            parameterInfo.put(n.getNodeName(), n.getNodeValue());
        }
        this.initProperty(parameterInfo.getPropertyInfoMap(), node.getChildNodes());
        return parameterInfo;
    }

    private void initProperty(PropertyInfoMap propertyMap, NodeList nlist) {
        for (int i = 0; i < nlist.getLength(); ++i) {
            PropertyInfo propertyInfo;
            Node child = nlist.item(i);
            if (!"property".equals(child.getNodeName()) || propertyMap.put((propertyInfo = this.getPropertyInfo(child)).getName(), propertyInfo) == null) continue;
            throw new ConfigurationException(this.message("m_dup_property", propertyInfo.getName()));
        }
    }

    private PropertyInfo getPropertyInfo(Node node) {
        NamedNodeMap attr = node.getAttributes();
        String name = this.getValue(attr, "name");
        if (name == null) {
            throw new ConfigurationException(this.message("m_null_property_name", new Object[0]));
        }
        PropertyInfo propertyInfo = new PropertyInfo(name);
        for (int j = 0; j < attr.getLength(); ++j) {
            Node n = attr.item(j);
            propertyInfo.put(n.getNodeName(), n.getNodeValue());
        }
        return propertyInfo;
    }

    private String getValue(NamedNodeMap attr, String name) {
        if (attr == null) {
            return null;
        }
        Node node = attr.getNamedItem(name);
        if (node != null) {
            return node.getNodeValue();
        }
        return null;
    }

    private String message(String key, Object ... args) {
        return this.resource.message(key, args);
    }
}

